---
layout: news_item
date: "2016-06-04 12:00:00 +0000"
author: elserj
version: 1.8.0
categories: [release]
tag: v1-8-0
sha: ddfaf07
component: avatica
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

Apache Calcite Avatica 1.8.0 continues the focus on compatibility with previous
versions while also adding support for authentication between Avatica client and server.
Performance, notably on the write-path, is also major area of improvement
in this release, increasing as much as two to three times over previous versions
with the addition of new API support. The documentation for both users and developers
continues to receive improvements.

Authentication is a major theme of this release, providing multiple layers of
additional authentication mechanisms over previous versions. In these earlier
versions, the only authentication provided by Avatica was achieved via the JDBC URL's
standard user and password options. These have always been passed directly into
the backend database's authentication system, but not all databases provide username
and password based authentication systems. [CALCITE-1173](https://issues.apache.org/jira/browse/CALCITE-1173)
adds Avatica-level authentication over [HTTP Basic](https://en.wikipedia.org/wiki/Basic_access_authentication)
and [HTTP Digest](https://en.wikipedia.org/wiki/Digest_access_authentication)
authentication mechanisms. These are provided specifically for the case when
Avatica is used with a database that _does not already_ provide its own authentication
implementation.

Some systems rely on [Kerberos](http://web.mit.edu/kerberos/) for strong, centrally-
managed authentication. [CALCITE-1159](https://issues.apache.org/jira/browse/CALCITE-1159)
introduces Kerberos-based authentication for clients via [SPNEGO](https://en.wikipedia.org/wiki/SPNEGO).
The Avatica server can be configured to only allow clients with a valid Kerberos ticket,
optionally, also passing this information to the backend database to implement
basic "impersonation" (where the Avatica server issues requests on behalf of the end user).

Building on top of the work done in Avatica-1.7.0 in [CALCITE-1091](https://issues.apache.org/jira/browse/CALCITE-1091),
this release also contains [CALCITE-1128](https://issues.apache.org/jira/browse/CALCITE-1128) which
implements the batch-oriented JDBC APIs on `Statement`. Through careful inspection, it
was observed that the overall performance of Avatica clients in 100% write workloads was
dominated by the cost of the HTTP calls. By leveraging the `Statement#addBatch()`
and `Statement#executeBatch()` API calls, clients can efficiently batch multiple updates
in a single HTTP call. In testing this over the previous single HTTP call per update with
[Apache Phoenix](https://phoenix.apache.org), it was observed that performance increased by
two to three times, bringing Avatica's performance on par with the Phoenix "native" driver.

Returning back to compatibility, a new component appears in this release which is designed to
test versions of Avatica against each other. [CALCITE-1190](https://issues.apache.org/jira/browse/CALCITE-1190)
introduces a "Technology Compatibility Kit" (TCK) which automates the testing of one version
of Avatica against other versions. To further ease this testing, a runnable JAR to launch
an HSQLDB instance and an Avatica server also makes it debut with these changes. This TCK
makes it much easier to run tests of newer clients against older servers and vice versa.
Validating the backwards compatibility that is being built is extremely important to be
confident in the guarantees being provided to users.

Finally, a number of bugs are also fixed in the Protocol Buffer wire API. Some of these
include [CALCITE-1113](https://issues.apache.org/jira/browse/CALCITE-1113) and
[CALCITE-1103](https://issues.apache.org/jira/browse/CALCITE-1103) which fix how certain
numbers are serialized, [CALITE-1243](https://issues.apache.org/jira/browse/CALCITE-1243)
which corrects some fields in Protocol Buffer messages which were incorrectly marked
as unsigned integers instead of signed integers, and [CALCITE-1209](https://issues.apache.org/jira/browse/CALCITE-1209)
which removes incorrect parsing of binary fields as Base64-encoded strings. All of
these issues are fixed in a backwards-compatible manner and should have no additional negative
impact on older clients (older clients will not break, but they may continue to return
incorrect data for certain numbers).

For users of the Avatica driver, a new [client reference page]({{ base_url }}/avatica/docs/client_reference.html)
is added which details the options that are available in the Avatica JDBC Driver's URL.
The wire API documentation for Protocol Buffers continues to receive updates as the API continues to evolve.
