/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationControl;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSource;

public final class AMQPFederationSourceControlType
extends AbstractControl
implements AMQPFederationControl {
    private final AMQPFederationSource federation;

    public AMQPFederationSourceControlType(ActiveMQServer server, AMQPFederationSource federation) throws NotCompliantMBeanException {
        super(AMQPFederationControl.class, server.getStorageManager());
        this.federation = federation;
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.federation);
        }
        this.clearIO();
        try {
            String string = this.federation.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesReceived() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesReceived((Object)this.federation);
        }
        this.clearIO();
        try {
            long l = this.federation.getMetrics().getMessagesReceived();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesSent() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesSent((Object)this.federation);
        }
        this.clearIO();
        try {
            long l = this.federation.getMetrics().getMessagesSent();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPFederationControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPFederationControl.class);
    }
}

