/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Objects;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationType;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;

public abstract class AMQPFederationPolicyManager {
    protected final AMQPFederationMetrics metrics;
    protected final ActiveMQServer server;
    protected final AMQPFederation federation;
    protected final String policyName;
    protected final FederationType policyType;
    protected volatile State state = State.UNINITIALIZED;
    protected boolean connected;
    protected AMQPSessionContext session;

    public AMQPFederationPolicyManager(AMQPFederation federation, AMQPFederationMetrics metrics, String policyName, FederationType policyType) {
        Objects.requireNonNull(federation, "The Federation instance cannot be null");
        this.federation = federation;
        this.server = federation.getServer();
        this.policyName = policyName;
        this.policyType = policyType;
        this.metrics = metrics;
    }

    public final synchronized void initialize() {
        this.failIfShutdown();
        if (this.state.ordinal() < State.STOPPED.ordinal()) {
            this.state = State.STOPPED;
            this.handleManagerInitialized();
        }
    }

    public final synchronized void start() {
        if (!this.federation.isStarted()) {
            throw new IllegalStateException("Cannot start a federation policy manager when the federation is stopped.");
        }
        if (this.state == State.UNINITIALIZED) {
            throw new IllegalStateException("Federation policy manager has not been initialized");
        }
        this.failIfShutdown();
        if (this.state.ordinal() < State.STARTED.ordinal()) {
            this.state = State.STARTED;
            this.handleManagerStarted();
        }
    }

    public final synchronized void stop() {
        if (this.state == State.UNINITIALIZED) {
            throw new IllegalStateException("Federation policy manager has not been initialized");
        }
        if (this.state == State.STARTED) {
            this.state = State.STOPPED;
            this.handleManagerStopped();
        }
    }

    public final synchronized void shutdown() {
        if (this.state.ordinal() < State.SHUTDOWN.ordinal()) {
            this.state = State.SHUTDOWN;
            this.handleManagerShutdown();
        }
    }

    public final boolean isStarted() {
        return this.state == State.STARTED;
    }

    public AMQPFederationMetrics getMetrics() {
        return this.metrics;
    }

    public final FederationType getPolicyType() {
        return this.policyType;
    }

    public final String getPolicyName() {
        return this.policyName;
    }

    public AMQPFederation getFederation() {
        return this.federation;
    }

    public final synchronized void connectionInterrupted() {
        this.connected = false;
        this.handleConnectionInterrupted();
    }

    public final synchronized void connectionRestored() {
        this.connected = true;
        this.session = this.federation.getSessionContext();
        this.handleConnectionRestored();
    }

    protected final void failIfShutdown() throws IllegalStateException {
        if (this.state == State.SHUTDOWN) {
            throw new IllegalStateException("The federation policy manager has already been shutdown");
        }
    }

    protected final boolean isActive() {
        return this.connected && this.state == State.STARTED;
    }

    protected final boolean isConnected() {
        return this.connected;
    }

    protected abstract void handleManagerInitialized();

    protected abstract void handleManagerStarted();

    protected abstract void handleManagerStopped();

    protected abstract void handleManagerShutdown();

    protected abstract void handleConnectionInterrupted();

    protected abstract void handleConnectionRestored();

    public static enum State {
        UNINITIALIZED,
        STOPPED,
        STARTED,
        SHUTDOWN;

    }
}

