/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConfiguration;

public final class AMQPFederationConsumerConfiguration {
    private final Map<String, Object> properties;
    private final AMQPFederationConfiguration configuration;

    public AMQPFederationConsumerConfiguration(AMQPFederationConfiguration configuration, Map<String, ?> properties) {
        Objects.requireNonNull(configuration, "Federation configuration cannot be null");
        this.configuration = configuration;
        this.properties = properties == null || properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(properties));
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getReceiverCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getReceiverCreditsLow();
    }

    public int getReceiverQuiesceTimeout() {
        Object property = this.properties.get("receiverQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getReceiverQuiesceTimeout();
    }

    public int getAddressReceiverIdleTimeout() {
        Object property = this.properties.get("addressReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getAddressReceiverIdleTimeout();
    }

    public int getQueueReceiverIdleTimeout() {
        Object property = this.properties.get("queueReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getQueueReceiverIdleTimeout();
    }

    public int getPullReceiverBatchSize() {
        Object property = this.properties.get("amqpPullConsumerCredits");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getPullReceiverBatchSize();
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getLargeMessageThreshold();
    }

    public int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getLinkAttachTimeout();
    }

    public boolean isCoreMessageTunnelingEnabled() {
        Object property = this.properties.get("tunnel-core-messages");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isCoreMessageTunnelingEnabled();
    }

    public boolean isIgnoreAddressBindingFilters() {
        Object property = this.properties.get("ignoreAddressBindingFilters");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isIgnoreAddressBindingFilters();
    }

    public boolean isIgnoreSubscriptionFilters() {
        Object property = this.properties.get("ignoreQueueConsumerFilters");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isIgnoreSubscriptionFilters();
    }

    public boolean isIgnoreSubscriptionPriorities() {
        Object property = this.properties.get("ignoreQueueConsumerPriorities");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isIgnoreSubscriptionPriorities();
    }

    public boolean isUseModifiedForTransientDeliveryErrors() {
        Object property = this.properties.get("amqpUseModifiedForTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isUseModifiedForTransientDeliveryErrors();
    }

    public boolean isDrainOnTransientDeliveryErrors() {
        Object property = this.properties.get("amqpDrainOnTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isDrainOnTransientDeliveryErrors();
    }

    public int getLinkQuiesceTimeout() {
        Object property = this.properties.get("amqpLinkQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getLinkQuiesceTimeout();
    }
}

