/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json.simplifier;

import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.json.simplifier.AttributeExtractor;
import org.jolokia.service.serializer.object.Converter;

public abstract class SimplifierAccessor<T>
implements ObjectAccessor {
    private final Map<String, AttributeExtractor<T>> extractors = new HashMap<String, AttributeExtractor<T>>();
    private final Class<T> type;

    protected SimplifierAccessor(Class<T> pType) {
        this.type = pType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String path = pPathParts.isEmpty() ? null : pPathParts.pop();
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        if (path != null) {
            return this.extractAttribute(pConverter, pValue, pPathParts, pJsonify, path, faultHandler);
        }
        return pJsonify ? this.extractAllAttributes(pConverter, pValue, pPathParts) : pValue;
    }

    @Override
    public final boolean supportsStringConversion() {
        return true;
    }

    @Override
    public final boolean canSetValue() {
        return false;
    }

    @Override
    public final Object setObjectValue(Converter<String> pConverter, Object pObject, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("A simplifier can't be used to set a value");
    }

    private Object extractAllAttributes(ObjectToJsonConverter pConverter, T pValue, Deque<String> pPath) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (Map.Entry<String, AttributeExtractor<T>> entry : this.extractors.entrySet()) {
            LinkedList<String> paths = new LinkedList<String>(pPath);
            try {
                Object value = entry.getValue().extract(pValue);
                ret.put((Object)entry.getKey(), pConverter.extractObject(value, paths, true));
            }
            catch (ValueFaultHandler.AttributeFilteredException | AttributeExtractor.SkipAttributeException throwable) {}
        }
        if (ret.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractAttribute(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPath, boolean pJsonify, String pAttribute, ValueFaultHandler pFaultHandler) throws AttributeNotFoundException {
        AttributeExtractor<Object> extractor = this.extractors.get(pAttribute);
        if (extractor == null) {
            return pFaultHandler.handleException((Throwable)new AttributeNotFoundException("Illegal path element " + pAttribute + " for object " + String.valueOf(pValue)));
        }
        try {
            Object attributeValue = extractor.extract(pValue);
            return pConverter.extractObject(attributeValue, pPath, pJsonify);
        }
        catch (AttributeExtractor.SkipAttributeException e) {
            return pFaultHandler.handleException((Throwable)new AttributeNotFoundException("Illegal path element " + pAttribute + " for object " + String.valueOf(pValue)));
        }
    }

    protected final void addExtractor(String pName, AttributeExtractor<T> pExtractor) {
        this.extractors.put(pName, pExtractor);
    }
}

