# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180608


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetSystemDetails(object):
    """
    The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
    """

    #: A constant which can be used with the target_system_type property of a TargetSystemDetails.
    #: This constant has a value of "ADB"
    TARGET_SYSTEM_TYPE_ADB = "ADB"

    #: A constant which can be used with the target_system_type property of a TargetSystemDetails.
    #: This constant has a value of "FUNCTION"
    TARGET_SYSTEM_TYPE_FUNCTION = "FUNCTION"

    def __init__(self, **kwargs):
        """
        Initializes a new TargetSystemDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.vault.models.AdbTargetSystemDetails`
        * :class:`~oci.vault.models.FunctionTargetSystemDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_system_type:
            The value to assign to the target_system_type property of this TargetSystemDetails.
            Allowed values for this property are: "ADB", "FUNCTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type target_system_type: str

        """
        self.swagger_types = {
            'target_system_type': 'str'
        }

        self.attribute_map = {
            'target_system_type': 'targetSystemType'
        }

        self._target_system_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['targetSystemType']

        if type == 'ADB':
            return 'AdbTargetSystemDetails'

        if type == 'FUNCTION':
            return 'FunctionTargetSystemDetails'
        else:
            return 'TargetSystemDetails'

    @property
    def target_system_type(self):
        """
        **[Required]** Gets the target_system_type of this TargetSystemDetails.
        Unique identifier of the target system that Vault Secret connects to.

        Allowed values for this property are: "ADB", "FUNCTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The target_system_type of this TargetSystemDetails.
        :rtype: str
        """
        return self._target_system_type

    @target_system_type.setter
    def target_system_type(self, target_system_type):
        """
        Sets the target_system_type of this TargetSystemDetails.
        Unique identifier of the target system that Vault Secret connects to.


        :param target_system_type: The target_system_type of this TargetSystemDetails.
        :type: str
        """
        allowed_values = ["ADB", "FUNCTION"]
        if not value_allowed_none_or_none_sentinel(target_system_type, allowed_values):
            target_system_type = 'UNKNOWN_ENUM_VALUE'
        self._target_system_type = target_system_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
