# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMaintenanceWindowDetails(object):
    """
    Infomation to create a new Maintenance Window.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMaintenanceWindowDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateMaintenanceWindowDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateMaintenanceWindowDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMaintenanceWindowDetails.
        :type compartment_id: str

        :param resources:
            The value to assign to the resources property of this CreateMaintenanceWindowDetails.
        :type resources: list[oci.stack_monitoring.models.CreateMaintenanceWindowResourceDetails]

        :param schedule:
            The value to assign to the schedule property of this CreateMaintenanceWindowDetails.
        :type schedule: oci.stack_monitoring.models.MaintenanceWindowSchedule

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'resources': 'list[CreateMaintenanceWindowResourceDetails]',
            'schedule': 'MaintenanceWindowSchedule'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'resources': 'resources',
            'schedule': 'schedule'
        }

        self._name = None
        self._description = None
        self._compartment_id = None
        self._resources = None
        self._schedule = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateMaintenanceWindowDetails.
        Maintenance Window name.


        :return: The name of this CreateMaintenanceWindowDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateMaintenanceWindowDetails.
        Maintenance Window name.


        :param name: The name of this CreateMaintenanceWindowDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CreateMaintenanceWindowDetails.
        Maintenance Window description.


        :return: The description of this CreateMaintenanceWindowDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateMaintenanceWindowDetails.
        Maintenance Window description.


        :param description: The description of this CreateMaintenanceWindowDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateMaintenanceWindowDetails.
        Compartment Identifier `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateMaintenanceWindowDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateMaintenanceWindowDetails.
        Compartment Identifier `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateMaintenanceWindowDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resources(self):
        """
        **[Required]** Gets the resources of this CreateMaintenanceWindowDetails.
        List of resource Ids which are part of the Maintenance Window


        :return: The resources of this CreateMaintenanceWindowDetails.
        :rtype: list[oci.stack_monitoring.models.CreateMaintenanceWindowResourceDetails]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this CreateMaintenanceWindowDetails.
        List of resource Ids which are part of the Maintenance Window


        :param resources: The resources of this CreateMaintenanceWindowDetails.
        :type: list[oci.stack_monitoring.models.CreateMaintenanceWindowResourceDetails]
        """
        self._resources = resources

    @property
    def schedule(self):
        """
        **[Required]** Gets the schedule of this CreateMaintenanceWindowDetails.

        :return: The schedule of this CreateMaintenanceWindowDetails.
        :rtype: oci.stack_monitoring.models.MaintenanceWindowSchedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """
        Sets the schedule of this CreateMaintenanceWindowDetails.

        :param schedule: The schedule of this CreateMaintenanceWindowDetails.
        :type: oci.stack_monitoring.models.MaintenanceWindowSchedule
        """
        self._schedule = schedule

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
