# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240815


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateSecurityAttributeDetails(object):
    """
    Details of the security attribute to be updated for a specific security attribute namespace.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateSecurityAttributeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateSecurityAttributeDetails.
        :type description: str

        :param is_retired:
            The value to assign to the is_retired property of this UpdateSecurityAttributeDetails.
        :type is_retired: bool

        :param validator:
            The value to assign to the validator property of this UpdateSecurityAttributeDetails.
        :type validator: oci.security_attribute.models.BaseSecurityAttributeValidator

        """
        self.swagger_types = {
            'description': 'str',
            'is_retired': 'bool',
            'validator': 'BaseSecurityAttributeValidator'
        }

        self.attribute_map = {
            'description': 'description',
            'is_retired': 'isRetired',
            'validator': 'validator'
        }

        self._description = None
        self._is_retired = None
        self._validator = None

    @property
    def description(self):
        """
        Gets the description of this UpdateSecurityAttributeDetails.
        The description of the security attribute during creation.


        :return: The description of this UpdateSecurityAttributeDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateSecurityAttributeDetails.
        The description of the security attribute during creation.


        :param description: The description of this UpdateSecurityAttributeDetails.
        :type: str
        """
        self._description = description

    @property
    def is_retired(self):
        """
        Gets the is_retired of this UpdateSecurityAttributeDetails.
        Whether the security attribute is retired.
        See `Managing Security Attributes`__.

        __ https://docs.cloud.oracle.com/Content/zero-trust-packet-routing/managing-security-attributes.htm


        :return: The is_retired of this UpdateSecurityAttributeDetails.
        :rtype: bool
        """
        return self._is_retired

    @is_retired.setter
    def is_retired(self, is_retired):
        """
        Sets the is_retired of this UpdateSecurityAttributeDetails.
        Whether the security attribute is retired.
        See `Managing Security Attributes`__.

        __ https://docs.cloud.oracle.com/Content/zero-trust-packet-routing/managing-security-attributes.htm


        :param is_retired: The is_retired of this UpdateSecurityAttributeDetails.
        :type: bool
        """
        self._is_retired = is_retired

    @property
    def validator(self):
        """
        Gets the validator of this UpdateSecurityAttributeDetails.

        :return: The validator of this UpdateSecurityAttributeDetails.
        :rtype: oci.security_attribute.models.BaseSecurityAttributeValidator
        """
        return self._validator

    @validator.setter
    def validator(self, validator):
        """
        Sets the validator of this UpdateSecurityAttributeDetails.

        :param validator: The validator of this UpdateSecurityAttributeDetails.
        :type: oci.security_attribute.models.BaseSecurityAttributeValidator
        """
        self._validator = validator

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
