# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ShapeOcpuOptions(object):
    """
    Options for the the shape OCPU
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ShapeOcpuOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param min:
            The value to assign to the min property of this ShapeOcpuOptions.
        :type min: int

        :param max:
            The value to assign to the max property of this ShapeOcpuOptions.
        :type max: int

        """
        self.swagger_types = {
            'min': 'int',
            'max': 'int'
        }

        self.attribute_map = {
            'min': 'min',
            'max': 'max'
        }

        self._min = None
        self._max = None

    @property
    def min(self):
        """
        **[Required]** Gets the min of this ShapeOcpuOptions.
        Minimum OCPU configuration


        :return: The min of this ShapeOcpuOptions.
        :rtype: int
        """
        return self._min

    @min.setter
    def min(self, min):
        """
        Sets the min of this ShapeOcpuOptions.
        Minimum OCPU configuration


        :param min: The min of this ShapeOcpuOptions.
        :type: int
        """
        self._min = min

    @property
    def max(self):
        """
        **[Required]** Gets the max of this ShapeOcpuOptions.
        Maximum OCPU configuration


        :return: The max of this ShapeOcpuOptions.
        :rtype: int
        """
        return self._max

    @max.setter
    def max(self, max):
        """
        Sets the max of this ShapeOcpuOptions.
        Maximum OCPU configuration


        :param max: The max of this ShapeOcpuOptions.
        :type: int
        """
        self._max = max

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
