# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConnectionDetails(object):
    """
    Database system connection information. Used to connect to PostgreSQL instance(s).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ca_certificate:
            The value to assign to the ca_certificate property of this ConnectionDetails.
        :type ca_certificate: str

        :param primary_db_endpoint:
            The value to assign to the primary_db_endpoint property of this ConnectionDetails.
        :type primary_db_endpoint: oci.psql.models.Endpoint

        :param instance_endpoints:
            The value to assign to the instance_endpoints property of this ConnectionDetails.
        :type instance_endpoints: list[oci.psql.models.DbInstanceEndpoint]

        :param reader_endpoint:
            The value to assign to the reader_endpoint property of this ConnectionDetails.
        :type reader_endpoint: oci.psql.models.Endpoint

        """
        self.swagger_types = {
            'ca_certificate': 'str',
            'primary_db_endpoint': 'Endpoint',
            'instance_endpoints': 'list[DbInstanceEndpoint]',
            'reader_endpoint': 'Endpoint'
        }

        self.attribute_map = {
            'ca_certificate': 'caCertificate',
            'primary_db_endpoint': 'primaryDbEndpoint',
            'instance_endpoints': 'instanceEndpoints',
            'reader_endpoint': 'readerEndpoint'
        }

        self._ca_certificate = None
        self._primary_db_endpoint = None
        self._instance_endpoints = None
        self._reader_endpoint = None

    @property
    def ca_certificate(self):
        """
        **[Required]** Gets the ca_certificate of this ConnectionDetails.
        The CA certificate to be used by the PosgreSQL client to connect to the database.
        The CA certificate is used to authenticate the server identity.
        It is issued by PostgreSQL Service Private CA.


        :return: The ca_certificate of this ConnectionDetails.
        :rtype: str
        """
        return self._ca_certificate

    @ca_certificate.setter
    def ca_certificate(self, ca_certificate):
        """
        Sets the ca_certificate of this ConnectionDetails.
        The CA certificate to be used by the PosgreSQL client to connect to the database.
        The CA certificate is used to authenticate the server identity.
        It is issued by PostgreSQL Service Private CA.


        :param ca_certificate: The ca_certificate of this ConnectionDetails.
        :type: str
        """
        self._ca_certificate = ca_certificate

    @property
    def primary_db_endpoint(self):
        """
        **[Required]** Gets the primary_db_endpoint of this ConnectionDetails.

        :return: The primary_db_endpoint of this ConnectionDetails.
        :rtype: oci.psql.models.Endpoint
        """
        return self._primary_db_endpoint

    @primary_db_endpoint.setter
    def primary_db_endpoint(self, primary_db_endpoint):
        """
        Sets the primary_db_endpoint of this ConnectionDetails.

        :param primary_db_endpoint: The primary_db_endpoint of this ConnectionDetails.
        :type: oci.psql.models.Endpoint
        """
        self._primary_db_endpoint = primary_db_endpoint

    @property
    def instance_endpoints(self):
        """
        **[Required]** Gets the instance_endpoints of this ConnectionDetails.
        The list of database instance node endpoints in the database system.


        :return: The instance_endpoints of this ConnectionDetails.
        :rtype: list[oci.psql.models.DbInstanceEndpoint]
        """
        return self._instance_endpoints

    @instance_endpoints.setter
    def instance_endpoints(self, instance_endpoints):
        """
        Sets the instance_endpoints of this ConnectionDetails.
        The list of database instance node endpoints in the database system.


        :param instance_endpoints: The instance_endpoints of this ConnectionDetails.
        :type: list[oci.psql.models.DbInstanceEndpoint]
        """
        self._instance_endpoints = instance_endpoints

    @property
    def reader_endpoint(self):
        """
        Gets the reader_endpoint of this ConnectionDetails.

        :return: The reader_endpoint of this ConnectionDetails.
        :rtype: oci.psql.models.Endpoint
        """
        return self._reader_endpoint

    @reader_endpoint.setter
    def reader_endpoint(self, reader_endpoint):
        """
        Sets the reader_endpoint of this ConnectionDetails.

        :param reader_endpoint: The reader_endpoint of this ConnectionDetails.
        :type: oci.psql.models.Endpoint
        """
        self._reader_endpoint = reader_endpoint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
