# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Backup(object):
    """
    Database system backup information.
    """

    #: A constant which can be used with the source_type property of a Backup.
    #: This constant has a value of "SCHEDULED"
    SOURCE_TYPE_SCHEDULED = "SCHEDULED"

    #: A constant which can be used with the source_type property of a Backup.
    #: This constant has a value of "MANUAL"
    SOURCE_TYPE_MANUAL = "MANUAL"

    #: A constant which can be used with the lifecycle_state property of a Backup.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Backup.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Backup.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Backup.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Backup.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new Backup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Backup.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Backup.
        :type display_name: str

        :param description:
            The value to assign to the description property of this Backup.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Backup.
        :type compartment_id: str

        :param source_type:
            The value to assign to the source_type property of this Backup.
            Allowed values for this property are: "SCHEDULED", "MANUAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source_type: str

        :param time_created:
            The value to assign to the time_created property of this Backup.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Backup.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Backup.
            Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Backup.
        :type lifecycle_details: str

        :param retention_period:
            The value to assign to the retention_period property of this Backup.
        :type retention_period: int

        :param backup_size:
            The value to assign to the backup_size property of this Backup.
        :type backup_size: int

        :param db_system_id:
            The value to assign to the db_system_id property of this Backup.
        :type db_system_id: str

        :param db_system_details:
            The value to assign to the db_system_details property of this Backup.
        :type db_system_details: oci.psql.models.DbSystemDetails

        :param last_accepted_request_token:
            The value to assign to the last_accepted_request_token property of this Backup.
        :type last_accepted_request_token: str

        :param last_completed_request_token:
            The value to assign to the last_completed_request_token property of this Backup.
        :type last_completed_request_token: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Backup.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Backup.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Backup.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'source_type': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'retention_period': 'int',
            'backup_size': 'int',
            'db_system_id': 'str',
            'db_system_details': 'DbSystemDetails',
            'last_accepted_request_token': 'str',
            'last_completed_request_token': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'source_type': 'sourceType',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'retention_period': 'retentionPeriod',
            'backup_size': 'backupSize',
            'db_system_id': 'dbSystemId',
            'db_system_details': 'dbSystemDetails',
            'last_accepted_request_token': 'lastAcceptedRequestToken',
            'last_completed_request_token': 'lastCompletedRequestToken',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._source_type = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._retention_period = None
        self._backup_size = None
        self._db_system_id = None
        self._db_system_details = None
        self._last_accepted_request_token = None
        self._last_completed_request_token = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Backup.
        The `OCID`__ of the backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this Backup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Backup.
        The `OCID`__ of the backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this Backup.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Backup.
        A user-friendly display name for the backup. Avoid entering confidential information.


        :return: The display_name of this Backup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Backup.
        A user-friendly display name for the backup. Avoid entering confidential information.


        :param display_name: The display_name of this Backup.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Backup.
        A description for the backup.


        :return: The description of this Backup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Backup.
        A description for the backup.


        :param description: The description of this Backup.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Backup.
        The `OCID`__ of the compartment that contains the backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Backup.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Backup.
        The `OCID`__ of the compartment that contains the backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Backup.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def source_type(self):
        """
        Gets the source_type of this Backup.
        Specifies whether the backup was created manually, or by a management policy.

        Allowed values for this property are: "SCHEDULED", "MANUAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The source_type of this Backup.
        :rtype: str
        """
        return self._source_type

    @source_type.setter
    def source_type(self, source_type):
        """
        Sets the source_type of this Backup.
        Specifies whether the backup was created manually, or by a management policy.


        :param source_type: The source_type of this Backup.
        :type: str
        """
        allowed_values = ["SCHEDULED", "MANUAL"]
        if not value_allowed_none_or_none_sentinel(source_type, allowed_values):
            source_type = 'UNKNOWN_ENUM_VALUE'
        self._source_type = source_type

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Backup.
        The date and time the backup request was received, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this Backup.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Backup.
        The date and time the backup request was received, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this Backup.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Backup.
        The date and time the backup was updated, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this Backup.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Backup.
        The date and time the backup was updated, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this Backup.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Backup.
        The current state of the backup.

        Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Backup.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Backup.
        The current state of the backup.


        :param lifecycle_state: The lifecycle_state of this Backup.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Backup.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this Backup.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Backup.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this Backup.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def retention_period(self):
        """
        Gets the retention_period of this Backup.
        Backup retention period in days.


        :return: The retention_period of this Backup.
        :rtype: int
        """
        return self._retention_period

    @retention_period.setter
    def retention_period(self, retention_period):
        """
        Sets the retention_period of this Backup.
        Backup retention period in days.


        :param retention_period: The retention_period of this Backup.
        :type: int
        """
        self._retention_period = retention_period

    @property
    def backup_size(self):
        """
        **[Required]** Gets the backup_size of this Backup.
        The size of the backup, in gigabytes.


        :return: The backup_size of this Backup.
        :rtype: int
        """
        return self._backup_size

    @backup_size.setter
    def backup_size(self, backup_size):
        """
        Sets the backup_size of this Backup.
        The size of the backup, in gigabytes.


        :param backup_size: The backup_size of this Backup.
        :type: int
        """
        self._backup_size = backup_size

    @property
    def db_system_id(self):
        """
        Gets the db_system_id of this Backup.
        The `OCID`__ of the backup's source database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_system_id of this Backup.
        :rtype: str
        """
        return self._db_system_id

    @db_system_id.setter
    def db_system_id(self, db_system_id):
        """
        Sets the db_system_id of this Backup.
        The `OCID`__ of the backup's source database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_system_id: The db_system_id of this Backup.
        :type: str
        """
        self._db_system_id = db_system_id

    @property
    def db_system_details(self):
        """
        **[Required]** Gets the db_system_details of this Backup.

        :return: The db_system_details of this Backup.
        :rtype: oci.psql.models.DbSystemDetails
        """
        return self._db_system_details

    @db_system_details.setter
    def db_system_details(self, db_system_details):
        """
        Sets the db_system_details of this Backup.

        :param db_system_details: The db_system_details of this Backup.
        :type: oci.psql.models.DbSystemDetails
        """
        self._db_system_details = db_system_details

    @property
    def last_accepted_request_token(self):
        """
        Gets the last_accepted_request_token of this Backup.
        lastAcceptedRequestToken from MP.


        :return: The last_accepted_request_token of this Backup.
        :rtype: str
        """
        return self._last_accepted_request_token

    @last_accepted_request_token.setter
    def last_accepted_request_token(self, last_accepted_request_token):
        """
        Sets the last_accepted_request_token of this Backup.
        lastAcceptedRequestToken from MP.


        :param last_accepted_request_token: The last_accepted_request_token of this Backup.
        :type: str
        """
        self._last_accepted_request_token = last_accepted_request_token

    @property
    def last_completed_request_token(self):
        """
        Gets the last_completed_request_token of this Backup.
        lastCompletedRequestToken from MP.


        :return: The last_completed_request_token of this Backup.
        :rtype: str
        """
        return self._last_completed_request_token

    @last_completed_request_token.setter
    def last_completed_request_token(self, last_completed_request_token):
        """
        Sets the last_completed_request_token of this Backup.
        lastCompletedRequestToken from MP.


        :param last_completed_request_token: The last_completed_request_token of this Backup.
        :type: str
        """
        self._last_completed_request_token = last_completed_request_token

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this Backup.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this Backup.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Backup.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this Backup.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this Backup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Backup.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Backup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Backup.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Backup.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Backup.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Backup.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Backup.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
