# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstallWindowsUpdatesOnManagedInstanceDetails(object):
    """
    Provides the information used to install Windows updates on a managed instance.
    """

    #: A constant which can be used with the windows_update_types property of a InstallWindowsUpdatesOnManagedInstanceDetails.
    #: This constant has a value of "SECURITY"
    WINDOWS_UPDATE_TYPES_SECURITY = "SECURITY"

    #: A constant which can be used with the windows_update_types property of a InstallWindowsUpdatesOnManagedInstanceDetails.
    #: This constant has a value of "BUGFIX"
    WINDOWS_UPDATE_TYPES_BUGFIX = "BUGFIX"

    #: A constant which can be used with the windows_update_types property of a InstallWindowsUpdatesOnManagedInstanceDetails.
    #: This constant has a value of "ENHANCEMENT"
    WINDOWS_UPDATE_TYPES_ENHANCEMENT = "ENHANCEMENT"

    #: A constant which can be used with the windows_update_types property of a InstallWindowsUpdatesOnManagedInstanceDetails.
    #: This constant has a value of "OTHER"
    WINDOWS_UPDATE_TYPES_OTHER = "OTHER"

    #: A constant which can be used with the windows_update_types property of a InstallWindowsUpdatesOnManagedInstanceDetails.
    #: This constant has a value of "ALL"
    WINDOWS_UPDATE_TYPES_ALL = "ALL"

    def __init__(self, **kwargs):
        """
        Initializes a new InstallWindowsUpdatesOnManagedInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param windows_update_name:
            The value to assign to the windows_update_name property of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :type windows_update_name: list[str]

        :param windows_update_types:
            The value to assign to the windows_update_types property of this InstallWindowsUpdatesOnManagedInstanceDetails.
            Allowed values for items in this list are: "SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", "ALL"
        :type windows_update_types: list[str]

        :param work_request_details:
            The value to assign to the work_request_details property of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :type work_request_details: oci.os_management_hub.models.WorkRequestDetails

        """
        self.swagger_types = {
            'windows_update_name': 'list[str]',
            'windows_update_types': 'list[str]',
            'work_request_details': 'WorkRequestDetails'
        }

        self.attribute_map = {
            'windows_update_name': 'windowsUpdateName',
            'windows_update_types': 'windowsUpdateTypes',
            'work_request_details': 'workRequestDetails'
        }

        self._windows_update_name = None
        self._windows_update_types = None
        self._work_request_details = None

    @property
    def windows_update_name(self):
        """
        Gets the windows_update_name of this InstallWindowsUpdatesOnManagedInstanceDetails.
        The list of Windows update unique identifiers.
        Note that this is not an OCID, but is a unique identifier assigned by Microsoft.
        Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'


        :return: The windows_update_name of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :rtype: list[str]
        """
        return self._windows_update_name

    @windows_update_name.setter
    def windows_update_name(self, windows_update_name):
        """
        Sets the windows_update_name of this InstallWindowsUpdatesOnManagedInstanceDetails.
        The list of Windows update unique identifiers.
        Note that this is not an OCID, but is a unique identifier assigned by Microsoft.
        Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'


        :param windows_update_name: The windows_update_name of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :type: list[str]
        """
        self._windows_update_name = windows_update_name

    @property
    def windows_update_types(self):
        """
        Gets the windows_update_types of this InstallWindowsUpdatesOnManagedInstanceDetails.
        The types of Windows updates to be installed.

        Allowed values for items in this list are: "SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", "ALL"


        :return: The windows_update_types of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :rtype: list[str]
        """
        return self._windows_update_types

    @windows_update_types.setter
    def windows_update_types(self, windows_update_types):
        """
        Sets the windows_update_types of this InstallWindowsUpdatesOnManagedInstanceDetails.
        The types of Windows updates to be installed.


        :param windows_update_types: The windows_update_types of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :type: list[str]
        """
        allowed_values = ["SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", "ALL"]

        if windows_update_types and windows_update_types is not NONE_SENTINEL:
            for value in windows_update_types:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `windows_update_types`, must be None or one of {allowed_values}"
                    )
        self._windows_update_types = windows_update_types

    @property
    def work_request_details(self):
        """
        Gets the work_request_details of this InstallWindowsUpdatesOnManagedInstanceDetails.

        :return: The work_request_details of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :rtype: oci.os_management_hub.models.WorkRequestDetails
        """
        return self._work_request_details

    @work_request_details.setter
    def work_request_details(self, work_request_details):
        """
        Sets the work_request_details of this InstallWindowsUpdatesOnManagedInstanceDetails.

        :param work_request_details: The work_request_details of this InstallWindowsUpdatesOnManagedInstanceDetails.
        :type: oci.os_management_hub.models.WorkRequestDetails
        """
        self._work_request_details = work_request_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
