# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .host_performance_metric_group import HostPerformanceMetricGroup
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostIoUsage(HostPerformanceMetricGroup):
    """
    Host IO Performance Metrics
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostIoUsage object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.HostIoUsage.metric_name` attribute
        of this class is ``HOST_IO_USAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this HostIoUsage.
            Allowed values for this property are: "HOST_CPU_USAGE", "HOST_MEMORY_USAGE", "HOST_NETWORK_ACTIVITY_SUMMARY", "HOST_TOP_PROCESSES", "HOST_FILESYSTEM_USAGE", "HOST_GPU_USAGE", "HOST_GPU_PROCESSES", "HOST_IO_USAGE"
        :type metric_name: str

        :param time_collected:
            The value to assign to the time_collected property of this HostIoUsage.
        :type time_collected: datetime

        :param mount_point:
            The value to assign to the mount_point property of this HostIoUsage.
        :type mount_point: str

        :param disk_bytes_read:
            The value to assign to the disk_bytes_read property of this HostIoUsage.
        :type disk_bytes_read: float

        :param disk_bytes_written:
            The value to assign to the disk_bytes_written property of this HostIoUsage.
        :type disk_bytes_written: float

        :param disk_iops_read:
            The value to assign to the disk_iops_read property of this HostIoUsage.
        :type disk_iops_read: float

        :param disk_iops_written:
            The value to assign to the disk_iops_written property of this HostIoUsage.
        :type disk_iops_written: float

        :param disk_iops:
            The value to assign to the disk_iops property of this HostIoUsage.
        :type disk_iops: float

        """
        self.swagger_types = {
            'metric_name': 'str',
            'time_collected': 'datetime',
            'mount_point': 'str',
            'disk_bytes_read': 'float',
            'disk_bytes_written': 'float',
            'disk_iops_read': 'float',
            'disk_iops_written': 'float',
            'disk_iops': 'float'
        }

        self.attribute_map = {
            'metric_name': 'metricName',
            'time_collected': 'timeCollected',
            'mount_point': 'mountPoint',
            'disk_bytes_read': 'diskBytesRead',
            'disk_bytes_written': 'diskBytesWritten',
            'disk_iops_read': 'diskIopsRead',
            'disk_iops_written': 'diskIopsWritten',
            'disk_iops': 'diskIops'
        }

        self._metric_name = None
        self._time_collected = None
        self._mount_point = None
        self._disk_bytes_read = None
        self._disk_bytes_written = None
        self._disk_iops_read = None
        self._disk_iops_written = None
        self._disk_iops = None
        self._metric_name = 'HOST_IO_USAGE'

    @property
    def mount_point(self):
        """
        Gets the mount_point of this HostIoUsage.
        Mount point


        :return: The mount_point of this HostIoUsage.
        :rtype: str
        """
        return self._mount_point

    @mount_point.setter
    def mount_point(self, mount_point):
        """
        Sets the mount_point of this HostIoUsage.
        Mount point


        :param mount_point: The mount_point of this HostIoUsage.
        :type: str
        """
        self._mount_point = mount_point

    @property
    def disk_bytes_read(self):
        """
        Gets the disk_bytes_read of this HostIoUsage.
        Bytes Read


        :return: The disk_bytes_read of this HostIoUsage.
        :rtype: float
        """
        return self._disk_bytes_read

    @disk_bytes_read.setter
    def disk_bytes_read(self, disk_bytes_read):
        """
        Sets the disk_bytes_read of this HostIoUsage.
        Bytes Read


        :param disk_bytes_read: The disk_bytes_read of this HostIoUsage.
        :type: float
        """
        self._disk_bytes_read = disk_bytes_read

    @property
    def disk_bytes_written(self):
        """
        Gets the disk_bytes_written of this HostIoUsage.
        Bytes Written


        :return: The disk_bytes_written of this HostIoUsage.
        :rtype: float
        """
        return self._disk_bytes_written

    @disk_bytes_written.setter
    def disk_bytes_written(self, disk_bytes_written):
        """
        Sets the disk_bytes_written of this HostIoUsage.
        Bytes Written


        :param disk_bytes_written: The disk_bytes_written of this HostIoUsage.
        :type: float
        """
        self._disk_bytes_written = disk_bytes_written

    @property
    def disk_iops_read(self):
        """
        Gets the disk_iops_read of this HostIoUsage.
        Read transactions per second


        :return: The disk_iops_read of this HostIoUsage.
        :rtype: float
        """
        return self._disk_iops_read

    @disk_iops_read.setter
    def disk_iops_read(self, disk_iops_read):
        """
        Sets the disk_iops_read of this HostIoUsage.
        Read transactions per second


        :param disk_iops_read: The disk_iops_read of this HostIoUsage.
        :type: float
        """
        self._disk_iops_read = disk_iops_read

    @property
    def disk_iops_written(self):
        """
        Gets the disk_iops_written of this HostIoUsage.
        Write transactions per second


        :return: The disk_iops_written of this HostIoUsage.
        :rtype: float
        """
        return self._disk_iops_written

    @disk_iops_written.setter
    def disk_iops_written(self, disk_iops_written):
        """
        Sets the disk_iops_written of this HostIoUsage.
        Write transactions per second


        :param disk_iops_written: The disk_iops_written of this HostIoUsage.
        :type: float
        """
        self._disk_iops_written = disk_iops_written

    @property
    def disk_iops(self):
        """
        Gets the disk_iops of this HostIoUsage.
        IO Transactions per second


        :return: The disk_iops of this HostIoUsage.
        :rtype: float
        """
        return self._disk_iops

    @disk_iops.setter
    def disk_iops(self, disk_iops):
        """
        Sets the disk_iops of this HostIoUsage.
        IO Transactions per second


        :param disk_iops: The disk_iops of this HostIoUsage.
        :type: float
        """
        self._disk_iops = disk_iops

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
