# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .host_performance_metric_group import HostPerformanceMetricGroup
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostGpuUsage(HostPerformanceMetricGroup):
    """
    GPU performance metrics
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostGpuUsage object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.HostGpuUsage.metric_name` attribute
        of this class is ``HOST_GPU_USAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this HostGpuUsage.
            Allowed values for this property are: "HOST_CPU_USAGE", "HOST_MEMORY_USAGE", "HOST_NETWORK_ACTIVITY_SUMMARY", "HOST_TOP_PROCESSES", "HOST_FILESYSTEM_USAGE", "HOST_GPU_USAGE", "HOST_GPU_PROCESSES", "HOST_IO_USAGE"
        :type metric_name: str

        :param time_collected:
            The value to assign to the time_collected property of this HostGpuUsage.
        :type time_collected: datetime

        :param gpu_id:
            The value to assign to the gpu_id property of this HostGpuUsage.
        :type gpu_id: int

        :param utilization:
            The value to assign to the utilization property of this HostGpuUsage.
        :type utilization: float

        :param memory_utilization:
            The value to assign to the memory_utilization property of this HostGpuUsage.
        :type memory_utilization: float

        :param power_draw:
            The value to assign to the power_draw property of this HostGpuUsage.
        :type power_draw: float

        :param temperature:
            The value to assign to the temperature property of this HostGpuUsage.
        :type temperature: float

        :param fan_utilization:
            The value to assign to the fan_utilization property of this HostGpuUsage.
        :type fan_utilization: float

        :param clock_speed_graphics:
            The value to assign to the clock_speed_graphics property of this HostGpuUsage.
        :type clock_speed_graphics: float

        :param clock_speed_sm:
            The value to assign to the clock_speed_sm property of this HostGpuUsage.
        :type clock_speed_sm: float

        :param clock_speed_video:
            The value to assign to the clock_speed_video property of this HostGpuUsage.
        :type clock_speed_video: float

        :param clock_speed_memory:
            The value to assign to the clock_speed_memory property of this HostGpuUsage.
        :type clock_speed_memory: float

        :param performance_state:
            The value to assign to the performance_state property of this HostGpuUsage.
        :type performance_state: float

        :param ecc_single_bit_errors:
            The value to assign to the ecc_single_bit_errors property of this HostGpuUsage.
        :type ecc_single_bit_errors: int

        :param ecc_double_bit_errors:
            The value to assign to the ecc_double_bit_errors property of this HostGpuUsage.
        :type ecc_double_bit_errors: int

        :param clock_event_idle:
            The value to assign to the clock_event_idle property of this HostGpuUsage.
        :type clock_event_idle: int

        :param clock_event_hw_thermal_slow_down:
            The value to assign to the clock_event_hw_thermal_slow_down property of this HostGpuUsage.
        :type clock_event_hw_thermal_slow_down: int

        :param clock_event_sw_power_cap:
            The value to assign to the clock_event_sw_power_cap property of this HostGpuUsage.
        :type clock_event_sw_power_cap: int

        :param clock_event_app_clock_setting:
            The value to assign to the clock_event_app_clock_setting property of this HostGpuUsage.
        :type clock_event_app_clock_setting: int

        :param clock_event_hw_power_break:
            The value to assign to the clock_event_hw_power_break property of this HostGpuUsage.
        :type clock_event_hw_power_break: int

        :param clock_event_sw_thermal_slowdown:
            The value to assign to the clock_event_sw_thermal_slowdown property of this HostGpuUsage.
        :type clock_event_sw_thermal_slowdown: int

        :param clock_event_sync_boost:
            The value to assign to the clock_event_sync_boost property of this HostGpuUsage.
        :type clock_event_sync_boost: int

        """
        self.swagger_types = {
            'metric_name': 'str',
            'time_collected': 'datetime',
            'gpu_id': 'int',
            'utilization': 'float',
            'memory_utilization': 'float',
            'power_draw': 'float',
            'temperature': 'float',
            'fan_utilization': 'float',
            'clock_speed_graphics': 'float',
            'clock_speed_sm': 'float',
            'clock_speed_video': 'float',
            'clock_speed_memory': 'float',
            'performance_state': 'float',
            'ecc_single_bit_errors': 'int',
            'ecc_double_bit_errors': 'int',
            'clock_event_idle': 'int',
            'clock_event_hw_thermal_slow_down': 'int',
            'clock_event_sw_power_cap': 'int',
            'clock_event_app_clock_setting': 'int',
            'clock_event_hw_power_break': 'int',
            'clock_event_sw_thermal_slowdown': 'int',
            'clock_event_sync_boost': 'int'
        }

        self.attribute_map = {
            'metric_name': 'metricName',
            'time_collected': 'timeCollected',
            'gpu_id': 'gpuId',
            'utilization': 'utilization',
            'memory_utilization': 'memoryUtilization',
            'power_draw': 'powerDraw',
            'temperature': 'temperature',
            'fan_utilization': 'fanUtilization',
            'clock_speed_graphics': 'clockSpeedGraphics',
            'clock_speed_sm': 'clockSpeedSm',
            'clock_speed_video': 'clockSpeedVideo',
            'clock_speed_memory': 'clockSpeedMemory',
            'performance_state': 'performanceState',
            'ecc_single_bit_errors': 'eccSingleBitErrors',
            'ecc_double_bit_errors': 'eccDoubleBitErrors',
            'clock_event_idle': 'clockEventIdle',
            'clock_event_hw_thermal_slow_down': 'clockEventHwThermalSlowDown',
            'clock_event_sw_power_cap': 'clockEventSwPowerCap',
            'clock_event_app_clock_setting': 'clockEventAppClockSetting',
            'clock_event_hw_power_break': 'clockEventHwPowerBreak',
            'clock_event_sw_thermal_slowdown': 'clockEventSwThermalSlowdown',
            'clock_event_sync_boost': 'clockEventSyncBoost'
        }

        self._metric_name = None
        self._time_collected = None
        self._gpu_id = None
        self._utilization = None
        self._memory_utilization = None
        self._power_draw = None
        self._temperature = None
        self._fan_utilization = None
        self._clock_speed_graphics = None
        self._clock_speed_sm = None
        self._clock_speed_video = None
        self._clock_speed_memory = None
        self._performance_state = None
        self._ecc_single_bit_errors = None
        self._ecc_double_bit_errors = None
        self._clock_event_idle = None
        self._clock_event_hw_thermal_slow_down = None
        self._clock_event_sw_power_cap = None
        self._clock_event_app_clock_setting = None
        self._clock_event_hw_power_break = None
        self._clock_event_sw_thermal_slowdown = None
        self._clock_event_sync_boost = None
        self._metric_name = 'HOST_GPU_USAGE'

    @property
    def gpu_id(self):
        """
        Gets the gpu_id of this HostGpuUsage.
        GPU Identifier


        :return: The gpu_id of this HostGpuUsage.
        :rtype: int
        """
        return self._gpu_id

    @gpu_id.setter
    def gpu_id(self, gpu_id):
        """
        Sets the gpu_id of this HostGpuUsage.
        GPU Identifier


        :param gpu_id: The gpu_id of this HostGpuUsage.
        :type: int
        """
        self._gpu_id = gpu_id

    @property
    def utilization(self):
        """
        Gets the utilization of this HostGpuUsage.
        GPU Utilization Percent


        :return: The utilization of this HostGpuUsage.
        :rtype: float
        """
        return self._utilization

    @utilization.setter
    def utilization(self, utilization):
        """
        Sets the utilization of this HostGpuUsage.
        GPU Utilization Percent


        :param utilization: The utilization of this HostGpuUsage.
        :type: float
        """
        self._utilization = utilization

    @property
    def memory_utilization(self):
        """
        Gets the memory_utilization of this HostGpuUsage.
        GPU Memory Utilization Percent


        :return: The memory_utilization of this HostGpuUsage.
        :rtype: float
        """
        return self._memory_utilization

    @memory_utilization.setter
    def memory_utilization(self, memory_utilization):
        """
        Sets the memory_utilization of this HostGpuUsage.
        GPU Memory Utilization Percent


        :param memory_utilization: The memory_utilization of this HostGpuUsage.
        :type: float
        """
        self._memory_utilization = memory_utilization

    @property
    def power_draw(self):
        """
        Gets the power_draw of this HostGpuUsage.
        GPU Power Draw in Watts


        :return: The power_draw of this HostGpuUsage.
        :rtype: float
        """
        return self._power_draw

    @power_draw.setter
    def power_draw(self, power_draw):
        """
        Sets the power_draw of this HostGpuUsage.
        GPU Power Draw in Watts


        :param power_draw: The power_draw of this HostGpuUsage.
        :type: float
        """
        self._power_draw = power_draw

    @property
    def temperature(self):
        """
        Gets the temperature of this HostGpuUsage.
        GPU Temperature in Celsius


        :return: The temperature of this HostGpuUsage.
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """
        Sets the temperature of this HostGpuUsage.
        GPU Temperature in Celsius


        :param temperature: The temperature of this HostGpuUsage.
        :type: float
        """
        self._temperature = temperature

    @property
    def fan_utilization(self):
        """
        Gets the fan_utilization of this HostGpuUsage.
        GPU Fan Utilization


        :return: The fan_utilization of this HostGpuUsage.
        :rtype: float
        """
        return self._fan_utilization

    @fan_utilization.setter
    def fan_utilization(self, fan_utilization):
        """
        Sets the fan_utilization of this HostGpuUsage.
        GPU Fan Utilization


        :param fan_utilization: The fan_utilization of this HostGpuUsage.
        :type: float
        """
        self._fan_utilization = fan_utilization

    @property
    def clock_speed_graphics(self):
        """
        Gets the clock_speed_graphics of this HostGpuUsage.
        GPU Graphics (Shader) Clock Speed


        :return: The clock_speed_graphics of this HostGpuUsage.
        :rtype: float
        """
        return self._clock_speed_graphics

    @clock_speed_graphics.setter
    def clock_speed_graphics(self, clock_speed_graphics):
        """
        Sets the clock_speed_graphics of this HostGpuUsage.
        GPU Graphics (Shader) Clock Speed


        :param clock_speed_graphics: The clock_speed_graphics of this HostGpuUsage.
        :type: float
        """
        self._clock_speed_graphics = clock_speed_graphics

    @property
    def clock_speed_sm(self):
        """
        Gets the clock_speed_sm of this HostGpuUsage.
        GPU SM (Streaming Multiprocessor) Clock Speed


        :return: The clock_speed_sm of this HostGpuUsage.
        :rtype: float
        """
        return self._clock_speed_sm

    @clock_speed_sm.setter
    def clock_speed_sm(self, clock_speed_sm):
        """
        Sets the clock_speed_sm of this HostGpuUsage.
        GPU SM (Streaming Multiprocessor) Clock Speed


        :param clock_speed_sm: The clock_speed_sm of this HostGpuUsage.
        :type: float
        """
        self._clock_speed_sm = clock_speed_sm

    @property
    def clock_speed_video(self):
        """
        Gets the clock_speed_video of this HostGpuUsage.
        GPU Video Clock Speed


        :return: The clock_speed_video of this HostGpuUsage.
        :rtype: float
        """
        return self._clock_speed_video

    @clock_speed_video.setter
    def clock_speed_video(self, clock_speed_video):
        """
        Sets the clock_speed_video of this HostGpuUsage.
        GPU Video Clock Speed


        :param clock_speed_video: The clock_speed_video of this HostGpuUsage.
        :type: float
        """
        self._clock_speed_video = clock_speed_video

    @property
    def clock_speed_memory(self):
        """
        Gets the clock_speed_memory of this HostGpuUsage.
        GPU Memory Clock Speed


        :return: The clock_speed_memory of this HostGpuUsage.
        :rtype: float
        """
        return self._clock_speed_memory

    @clock_speed_memory.setter
    def clock_speed_memory(self, clock_speed_memory):
        """
        Sets the clock_speed_memory of this HostGpuUsage.
        GPU Memory Clock Speed


        :param clock_speed_memory: The clock_speed_memory of this HostGpuUsage.
        :type: float
        """
        self._clock_speed_memory = clock_speed_memory

    @property
    def performance_state(self):
        """
        Gets the performance_state of this HostGpuUsage.
        GPU Performance State


        :return: The performance_state of this HostGpuUsage.
        :rtype: float
        """
        return self._performance_state

    @performance_state.setter
    def performance_state(self, performance_state):
        """
        Sets the performance_state of this HostGpuUsage.
        GPU Performance State


        :param performance_state: The performance_state of this HostGpuUsage.
        :type: float
        """
        self._performance_state = performance_state

    @property
    def ecc_single_bit_errors(self):
        """
        Gets the ecc_single_bit_errors of this HostGpuUsage.
        GPU ECC Single Bit Errors


        :return: The ecc_single_bit_errors of this HostGpuUsage.
        :rtype: int
        """
        return self._ecc_single_bit_errors

    @ecc_single_bit_errors.setter
    def ecc_single_bit_errors(self, ecc_single_bit_errors):
        """
        Sets the ecc_single_bit_errors of this HostGpuUsage.
        GPU ECC Single Bit Errors


        :param ecc_single_bit_errors: The ecc_single_bit_errors of this HostGpuUsage.
        :type: int
        """
        self._ecc_single_bit_errors = ecc_single_bit_errors

    @property
    def ecc_double_bit_errors(self):
        """
        Gets the ecc_double_bit_errors of this HostGpuUsage.
        GPU ECC Double Bit Errors


        :return: The ecc_double_bit_errors of this HostGpuUsage.
        :rtype: int
        """
        return self._ecc_double_bit_errors

    @ecc_double_bit_errors.setter
    def ecc_double_bit_errors(self, ecc_double_bit_errors):
        """
        Sets the ecc_double_bit_errors of this HostGpuUsage.
        GPU ECC Double Bit Errors


        :param ecc_double_bit_errors: The ecc_double_bit_errors of this HostGpuUsage.
        :type: int
        """
        self._ecc_double_bit_errors = ecc_double_bit_errors

    @property
    def clock_event_idle(self):
        """
        Gets the clock_event_idle of this HostGpuUsage.
        Nothing running on CPU, clocks are idle


        :return: The clock_event_idle of this HostGpuUsage.
        :rtype: int
        """
        return self._clock_event_idle

    @clock_event_idle.setter
    def clock_event_idle(self, clock_event_idle):
        """
        Sets the clock_event_idle of this HostGpuUsage.
        Nothing running on CPU, clocks are idle


        :param clock_event_idle: The clock_event_idle of this HostGpuUsage.
        :type: int
        """
        self._clock_event_idle = clock_event_idle

    @property
    def clock_event_hw_thermal_slow_down(self):
        """
        Gets the clock_event_hw_thermal_slow_down of this HostGpuUsage.
        HW Thermal Slowdown (reducing the core clocks by a factor of 2 or more) is engaged. Temp too high


        :return: The clock_event_hw_thermal_slow_down of this HostGpuUsage.
        :rtype: int
        """
        return self._clock_event_hw_thermal_slow_down

    @clock_event_hw_thermal_slow_down.setter
    def clock_event_hw_thermal_slow_down(self, clock_event_hw_thermal_slow_down):
        """
        Sets the clock_event_hw_thermal_slow_down of this HostGpuUsage.
        HW Thermal Slowdown (reducing the core clocks by a factor of 2 or more) is engaged. Temp too high


        :param clock_event_hw_thermal_slow_down: The clock_event_hw_thermal_slow_down of this HostGpuUsage.
        :type: int
        """
        self._clock_event_hw_thermal_slow_down = clock_event_hw_thermal_slow_down

    @property
    def clock_event_sw_power_cap(self):
        """
        Gets the clock_event_sw_power_cap of this HostGpuUsage.
        SW Power Scaling algorithm is reducing the clocks below requested clocks because the GPU is consuming too much power


        :return: The clock_event_sw_power_cap of this HostGpuUsage.
        :rtype: int
        """
        return self._clock_event_sw_power_cap

    @clock_event_sw_power_cap.setter
    def clock_event_sw_power_cap(self, clock_event_sw_power_cap):
        """
        Sets the clock_event_sw_power_cap of this HostGpuUsage.
        SW Power Scaling algorithm is reducing the clocks below requested clocks because the GPU is consuming too much power


        :param clock_event_sw_power_cap: The clock_event_sw_power_cap of this HostGpuUsage.
        :type: int
        """
        self._clock_event_sw_power_cap = clock_event_sw_power_cap

    @property
    def clock_event_app_clock_setting(self):
        """
        Gets the clock_event_app_clock_setting of this HostGpuUsage.
        GPU clocks are limited by applications clocks setting


        :return: The clock_event_app_clock_setting of this HostGpuUsage.
        :rtype: int
        """
        return self._clock_event_app_clock_setting

    @clock_event_app_clock_setting.setter
    def clock_event_app_clock_setting(self, clock_event_app_clock_setting):
        """
        Sets the clock_event_app_clock_setting of this HostGpuUsage.
        GPU clocks are limited by applications clocks setting


        :param clock_event_app_clock_setting: The clock_event_app_clock_setting of this HostGpuUsage.
        :type: int
        """
        self._clock_event_app_clock_setting = clock_event_app_clock_setting

    @property
    def clock_event_hw_power_break(self):
        """
        Gets the clock_event_hw_power_break of this HostGpuUsage.
        HW Power Brake Slowdown (reducing the core clocks by a factor of 2 or more) is engaged


        :return: The clock_event_hw_power_break of this HostGpuUsage.
        :rtype: int
        """
        return self._clock_event_hw_power_break

    @clock_event_hw_power_break.setter
    def clock_event_hw_power_break(self, clock_event_hw_power_break):
        """
        Sets the clock_event_hw_power_break of this HostGpuUsage.
        HW Power Brake Slowdown (reducing the core clocks by a factor of 2 or more) is engaged


        :param clock_event_hw_power_break: The clock_event_hw_power_break of this HostGpuUsage.
        :type: int
        """
        self._clock_event_hw_power_break = clock_event_hw_power_break

    @property
    def clock_event_sw_thermal_slowdown(self):
        """
        Gets the clock_event_sw_thermal_slowdown of this HostGpuUsage.
        SW Thermal capping algorithm is reducing clocks below requested clocks because GPU temperature is higher than Max Operating Temp


        :return: The clock_event_sw_thermal_slowdown of this HostGpuUsage.
        :rtype: int
        """
        return self._clock_event_sw_thermal_slowdown

    @clock_event_sw_thermal_slowdown.setter
    def clock_event_sw_thermal_slowdown(self, clock_event_sw_thermal_slowdown):
        """
        Sets the clock_event_sw_thermal_slowdown of this HostGpuUsage.
        SW Thermal capping algorithm is reducing clocks below requested clocks because GPU temperature is higher than Max Operating Temp


        :param clock_event_sw_thermal_slowdown: The clock_event_sw_thermal_slowdown of this HostGpuUsage.
        :type: int
        """
        self._clock_event_sw_thermal_slowdown = clock_event_sw_thermal_slowdown

    @property
    def clock_event_sync_boost(self):
        """
        Gets the clock_event_sync_boost of this HostGpuUsage.
        HW Power Brake Slowdown (reducing the core clocks by a factor of 2 or more) is engaged


        :return: The clock_event_sync_boost of this HostGpuUsage.
        :rtype: int
        """
        return self._clock_event_sync_boost

    @clock_event_sync_boost.setter
    def clock_event_sync_boost(self, clock_event_sync_boost):
        """
        Sets the clock_event_sync_boost of this HostGpuUsage.
        HW Power Brake Slowdown (reducing the core clocks by a factor of 2 or more) is engaged


        :param clock_event_sync_boost: The clock_event_sync_boost of this HostGpuUsage.
        :type: int
        """
        self._clock_event_sync_boost = clock_event_sync_boost

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
