# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190506

from .create_skill_entity_details import CreateSkillEntityDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSkillCompositeEntityDetails(CreateSkillEntityDetails):
    """
    Properties that are required to create a skill composite entity.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSkillCompositeEntityDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.oda.models.CreateSkillCompositeEntityDetails.type` attribute
        of this class is ``COMPOSITE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateSkillCompositeEntityDetails.
        :type name: str

        :param type:
            The value to assign to the type property of this CreateSkillCompositeEntityDetails.
            Allowed values for this property are: "COMPOSITE", "ENUM_VALUES"
        :type type: str

        :param attributes:
            The value to assign to the attributes property of this CreateSkillCompositeEntityDetails.
        :type attributes: list[oci.oda.models.EntityAttribute]

        :param actions:
            The value to assign to the actions property of this CreateSkillCompositeEntityDetails.
        :type actions: list[oci.oda.models.EntityAction]

        :param natural_language_mapping:
            The value to assign to the natural_language_mapping property of this CreateSkillCompositeEntityDetails.
        :type natural_language_mapping: oci.oda.models.EntityNaturalLanguageMapping

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'attributes': 'list[EntityAttribute]',
            'actions': 'list[EntityAction]',
            'natural_language_mapping': 'EntityNaturalLanguageMapping'
        }

        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'attributes': 'attributes',
            'actions': 'actions',
            'natural_language_mapping': 'naturalLanguageMapping'
        }

        self._name = None
        self._type = None
        self._attributes = None
        self._actions = None
        self._natural_language_mapping = None
        self._type = 'COMPOSITE'

    @property
    def attributes(self):
        """
        **[Required]** Gets the attributes of this CreateSkillCompositeEntityDetails.
        List of entity attributes.


        :return: The attributes of this CreateSkillCompositeEntityDetails.
        :rtype: list[oci.oda.models.EntityAttribute]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this CreateSkillCompositeEntityDetails.
        List of entity attributes.


        :param attributes: The attributes of this CreateSkillCompositeEntityDetails.
        :type: list[oci.oda.models.EntityAttribute]
        """
        self._attributes = attributes

    @property
    def actions(self):
        """
        Gets the actions of this CreateSkillCompositeEntityDetails.
        List of entity actions.


        :return: The actions of this CreateSkillCompositeEntityDetails.
        :rtype: list[oci.oda.models.EntityAction]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """
        Sets the actions of this CreateSkillCompositeEntityDetails.
        List of entity actions.


        :param actions: The actions of this CreateSkillCompositeEntityDetails.
        :type: list[oci.oda.models.EntityAction]
        """
        self._actions = actions

    @property
    def natural_language_mapping(self):
        """
        Gets the natural_language_mapping of this CreateSkillCompositeEntityDetails.

        :return: The natural_language_mapping of this CreateSkillCompositeEntityDetails.
        :rtype: oci.oda.models.EntityNaturalLanguageMapping
        """
        return self._natural_language_mapping

    @natural_language_mapping.setter
    def natural_language_mapping(self, natural_language_mapping):
        """
        Sets the natural_language_mapping of this CreateSkillCompositeEntityDetails.

        :param natural_language_mapping: The natural_language_mapping of this CreateSkillCompositeEntityDetails.
        :type: oci.oda.models.EntityNaturalLanguageMapping
        """
        self._natural_language_mapping = natural_language_mapping

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
