# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportedEsxiSoftwareVersionSummary(object):
    """
    A specific version of bundled ESXi software supported by the Oracle Cloud
    VMware Solution.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SupportedEsxiSoftwareVersionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param version:
            The value to assign to the version property of this SupportedEsxiSoftwareVersionSummary.
        :type version: str

        :param description:
            The value to assign to the description property of this SupportedEsxiSoftwareVersionSummary.
        :type description: str

        :param supported_host_shape_names:
            The value to assign to the supported_host_shape_names property of this SupportedEsxiSoftwareVersionSummary.
        :type supported_host_shape_names: list[str]

        """
        self.swagger_types = {
            'version': 'str',
            'description': 'str',
            'supported_host_shape_names': 'list[str]'
        }

        self.attribute_map = {
            'version': 'version',
            'description': 'description',
            'supported_host_shape_names': 'supportedHostShapeNames'
        }

        self._version = None
        self._description = None
        self._supported_host_shape_names = None

    @property
    def version(self):
        """
        **[Required]** Gets the version of this SupportedEsxiSoftwareVersionSummary.
        A short, unique string that identifies the version of bundled software.


        :return: The version of this SupportedEsxiSoftwareVersionSummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this SupportedEsxiSoftwareVersionSummary.
        A short, unique string that identifies the version of bundled software.


        :param version: The version of this SupportedEsxiSoftwareVersionSummary.
        :type: str
        """
        self._version = version

    @property
    def description(self):
        """
        **[Required]** Gets the description of this SupportedEsxiSoftwareVersionSummary.
        A description of the software in the bundle.


        :return: The description of this SupportedEsxiSoftwareVersionSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SupportedEsxiSoftwareVersionSummary.
        A description of the software in the bundle.


        :param description: The description of this SupportedEsxiSoftwareVersionSummary.
        :type: str
        """
        self._description = description

    @property
    def supported_host_shape_names(self):
        """
        **[Required]** Gets the supported_host_shape_names of this SupportedEsxiSoftwareVersionSummary.
        A list of ESXi host shapes supported by the version of bundled software.


        :return: The supported_host_shape_names of this SupportedEsxiSoftwareVersionSummary.
        :rtype: list[str]
        """
        return self._supported_host_shape_names

    @supported_host_shape_names.setter
    def supported_host_shape_names(self, supported_host_shape_names):
        """
        Sets the supported_host_shape_names of this SupportedEsxiSoftwareVersionSummary.
        A list of ESXi host shapes supported by the version of bundled software.


        :param supported_host_shape_names: The supported_host_shape_names of this SupportedEsxiSoftwareVersionSummary.
        :type: list[str]
        """
        self._supported_host_shape_names = supported_host_shape_names

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
