# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Sddc(object):
    """
    An `Oracle Cloud VMware Solution`__ software-defined data center (SDDC) contains the resources required for a
    functional VMware environment. Instances in an SDDC
    (see :class:`EsxiHost`) run in a virtual cloud network (VCN)
    and are preconfigured with VMware and storage. Use the vCenter utility to manage
    and deploy VMware virtual machines (VMs) in the SDDC.

    The SDDC uses a single management subnet for provisioning the SDDC. It also uses a
    set of VLANs for various components of the VMware environment (vSphere, vMotion,
    vSAN, and so on). See the Core Services API for information about VCN subnets and VLANs.

    __ https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/ocvsoverview.htm
    """

    #: A constant which can be used with the hcx_mode property of a Sddc.
    #: This constant has a value of "DISABLED"
    HCX_MODE_DISABLED = "DISABLED"

    #: A constant which can be used with the hcx_mode property of a Sddc.
    #: This constant has a value of "ADVANCED"
    HCX_MODE_ADVANCED = "ADVANCED"

    #: A constant which can be used with the hcx_mode property of a Sddc.
    #: This constant has a value of "ENTERPRISE"
    HCX_MODE_ENTERPRISE = "ENTERPRISE"

    #: A constant which can be used with the lifecycle_state property of a Sddc.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Sddc.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Sddc.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Sddc.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Sddc.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Sddc.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new Sddc object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Sddc.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Sddc.
        :type display_name: str

        :param vmware_software_version:
            The value to assign to the vmware_software_version property of this Sddc.
        :type vmware_software_version: str

        :param esxi_software_version:
            The value to assign to the esxi_software_version property of this Sddc.
        :type esxi_software_version: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Sddc.
        :type compartment_id: str

        :param clusters_count:
            The value to assign to the clusters_count property of this Sddc.
        :type clusters_count: int

        :param vcenter_fqdn:
            The value to assign to the vcenter_fqdn property of this Sddc.
        :type vcenter_fqdn: str

        :param nsx_manager_fqdn:
            The value to assign to the nsx_manager_fqdn property of this Sddc.
        :type nsx_manager_fqdn: str

        :param vcenter_private_ip_id:
            The value to assign to the vcenter_private_ip_id property of this Sddc.
        :type vcenter_private_ip_id: str

        :param nsx_manager_private_ip_id:
            The value to assign to the nsx_manager_private_ip_id property of this Sddc.
        :type nsx_manager_private_ip_id: str

        :param vcenter_username:
            The value to assign to the vcenter_username property of this Sddc.
        :type vcenter_username: str

        :param nsx_manager_username:
            The value to assign to the nsx_manager_username property of this Sddc.
        :type nsx_manager_username: str

        :param ssh_authorized_keys:
            The value to assign to the ssh_authorized_keys property of this Sddc.
        :type ssh_authorized_keys: str

        :param nsx_edge_uplink_ip_id:
            The value to assign to the nsx_edge_uplink_ip_id property of this Sddc.
        :type nsx_edge_uplink_ip_id: str

        :param hcx_private_ip_id:
            The value to assign to the hcx_private_ip_id property of this Sddc.
        :type hcx_private_ip_id: str

        :param hcx_fqdn:
            The value to assign to the hcx_fqdn property of this Sddc.
        :type hcx_fqdn: str

        :param hcx_mode:
            The value to assign to the hcx_mode property of this Sddc.
            Allowed values for this property are: "DISABLED", "ADVANCED", "ENTERPRISE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type hcx_mode: str

        :param initial_configuration:
            The value to assign to the initial_configuration property of this Sddc.
        :type initial_configuration: oci.ocvp.models.InitialConfiguration

        :param is_hcx_pending_downgrade:
            The value to assign to the is_hcx_pending_downgrade property of this Sddc.
        :type is_hcx_pending_downgrade: bool

        :param hcx_on_prem_licenses:
            The value to assign to the hcx_on_prem_licenses property of this Sddc.
        :type hcx_on_prem_licenses: list[oci.ocvp.models.HcxLicenseSummary]

        :param time_hcx_billing_cycle_end:
            The value to assign to the time_hcx_billing_cycle_end property of this Sddc.
        :type time_hcx_billing_cycle_end: datetime

        :param time_hcx_license_status_updated:
            The value to assign to the time_hcx_license_status_updated property of this Sddc.
        :type time_hcx_license_status_updated: datetime

        :param is_single_host_sddc:
            The value to assign to the is_single_host_sddc property of this Sddc.
        :type is_single_host_sddc: bool

        :param time_created:
            The value to assign to the time_created property of this Sddc.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Sddc.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Sddc.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Sddc.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Sddc.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Sddc.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'vmware_software_version': 'str',
            'esxi_software_version': 'str',
            'compartment_id': 'str',
            'clusters_count': 'int',
            'vcenter_fqdn': 'str',
            'nsx_manager_fqdn': 'str',
            'vcenter_private_ip_id': 'str',
            'nsx_manager_private_ip_id': 'str',
            'vcenter_username': 'str',
            'nsx_manager_username': 'str',
            'ssh_authorized_keys': 'str',
            'nsx_edge_uplink_ip_id': 'str',
            'hcx_private_ip_id': 'str',
            'hcx_fqdn': 'str',
            'hcx_mode': 'str',
            'initial_configuration': 'InitialConfiguration',
            'is_hcx_pending_downgrade': 'bool',
            'hcx_on_prem_licenses': 'list[HcxLicenseSummary]',
            'time_hcx_billing_cycle_end': 'datetime',
            'time_hcx_license_status_updated': 'datetime',
            'is_single_host_sddc': 'bool',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'vmware_software_version': 'vmwareSoftwareVersion',
            'esxi_software_version': 'esxiSoftwareVersion',
            'compartment_id': 'compartmentId',
            'clusters_count': 'clustersCount',
            'vcenter_fqdn': 'vcenterFqdn',
            'nsx_manager_fqdn': 'nsxManagerFqdn',
            'vcenter_private_ip_id': 'vcenterPrivateIpId',
            'nsx_manager_private_ip_id': 'nsxManagerPrivateIpId',
            'vcenter_username': 'vcenterUsername',
            'nsx_manager_username': 'nsxManagerUsername',
            'ssh_authorized_keys': 'sshAuthorizedKeys',
            'nsx_edge_uplink_ip_id': 'nsxEdgeUplinkIpId',
            'hcx_private_ip_id': 'hcxPrivateIpId',
            'hcx_fqdn': 'hcxFqdn',
            'hcx_mode': 'hcxMode',
            'initial_configuration': 'initialConfiguration',
            'is_hcx_pending_downgrade': 'isHcxPendingDowngrade',
            'hcx_on_prem_licenses': 'hcxOnPremLicenses',
            'time_hcx_billing_cycle_end': 'timeHcxBillingCycleEnd',
            'time_hcx_license_status_updated': 'timeHcxLicenseStatusUpdated',
            'is_single_host_sddc': 'isSingleHostSddc',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._display_name = None
        self._vmware_software_version = None
        self._esxi_software_version = None
        self._compartment_id = None
        self._clusters_count = None
        self._vcenter_fqdn = None
        self._nsx_manager_fqdn = None
        self._vcenter_private_ip_id = None
        self._nsx_manager_private_ip_id = None
        self._vcenter_username = None
        self._nsx_manager_username = None
        self._ssh_authorized_keys = None
        self._nsx_edge_uplink_ip_id = None
        self._hcx_private_ip_id = None
        self._hcx_fqdn = None
        self._hcx_mode = None
        self._initial_configuration = None
        self._is_hcx_pending_downgrade = None
        self._hcx_on_prem_licenses = None
        self._time_hcx_billing_cycle_end = None
        self._time_hcx_license_status_updated = None
        self._is_single_host_sddc = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Sddc.
        The `OCID`__ of the SDDC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this Sddc.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Sddc.
        The `OCID`__ of the SDDC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this Sddc.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Sddc.
        A descriptive name for the SDDC. It must be unique, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :return: The display_name of this Sddc.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Sddc.
        A descriptive name for the SDDC. It must be unique, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :param display_name: The display_name of this Sddc.
        :type: str
        """
        self._display_name = display_name

    @property
    def vmware_software_version(self):
        """
        **[Required]** Gets the vmware_software_version of this Sddc.
        In general, this is a specific version of bundled VMware software supported by
        Oracle Cloud VMware Solution (see
        :func:`list_supported_vmware_software_versions`).

        This attribute is not guaranteed to reflect the version of
        software currently installed on the ESXi hosts in the SDDC. The purpose
        of this attribute is to show the version of software that the Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        SDDC in the future* with :func:`create_esxi_host`.

        Therefore, if you upgrade the existing ESXi hosts in the SDDC to use a newer
        version of bundled VMware software supported by the Oracle Cloud VMware Solution, you
        should use :func:`update_sddc` to update the SDDC's
        `vmwareSoftwareVersion` with that new version.


        :return: The vmware_software_version of this Sddc.
        :rtype: str
        """
        return self._vmware_software_version

    @vmware_software_version.setter
    def vmware_software_version(self, vmware_software_version):
        """
        Sets the vmware_software_version of this Sddc.
        In general, this is a specific version of bundled VMware software supported by
        Oracle Cloud VMware Solution (see
        :func:`list_supported_vmware_software_versions`).

        This attribute is not guaranteed to reflect the version of
        software currently installed on the ESXi hosts in the SDDC. The purpose
        of this attribute is to show the version of software that the Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        SDDC in the future* with :func:`create_esxi_host`.

        Therefore, if you upgrade the existing ESXi hosts in the SDDC to use a newer
        version of bundled VMware software supported by the Oracle Cloud VMware Solution, you
        should use :func:`update_sddc` to update the SDDC's
        `vmwareSoftwareVersion` with that new version.


        :param vmware_software_version: The vmware_software_version of this Sddc.
        :type: str
        """
        self._vmware_software_version = vmware_software_version

    @property
    def esxi_software_version(self):
        """
        Gets the esxi_software_version of this Sddc.
        In general, this is a specific version of bundled ESXi software supported by
        Oracle Cloud VMware Solution (see
        :func:`list_supported_vmware_software_versions`).

        This attribute is not guaranteed to reflect the version of
        software currently installed on the ESXi hosts in the SDDC. The purpose
        of this attribute is to show the version of software that the Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        SDDC in the future* with :func:`create_esxi_host`
        unless a different version is configured on the Cluster or ESXi host level.

        Therefore, if you upgrade the existing ESXi hosts in the SDDC to use a newer
        version of bundled ESXi software supported by the Oracle Cloud VMware Solution, you
        should use :func:`update_sddc` to update the SDDC's
        `vmwareSoftwareVersion` with that new version.


        :return: The esxi_software_version of this Sddc.
        :rtype: str
        """
        return self._esxi_software_version

    @esxi_software_version.setter
    def esxi_software_version(self, esxi_software_version):
        """
        Sets the esxi_software_version of this Sddc.
        In general, this is a specific version of bundled ESXi software supported by
        Oracle Cloud VMware Solution (see
        :func:`list_supported_vmware_software_versions`).

        This attribute is not guaranteed to reflect the version of
        software currently installed on the ESXi hosts in the SDDC. The purpose
        of this attribute is to show the version of software that the Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        SDDC in the future* with :func:`create_esxi_host`
        unless a different version is configured on the Cluster or ESXi host level.

        Therefore, if you upgrade the existing ESXi hosts in the SDDC to use a newer
        version of bundled ESXi software supported by the Oracle Cloud VMware Solution, you
        should use :func:`update_sddc` to update the SDDC's
        `vmwareSoftwareVersion` with that new version.


        :param esxi_software_version: The esxi_software_version of this Sddc.
        :type: str
        """
        self._esxi_software_version = esxi_software_version

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Sddc.
        The `OCID`__ of the compartment that
        contains the SDDC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Sddc.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Sddc.
        The `OCID`__ of the compartment that
        contains the SDDC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Sddc.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def clusters_count(self):
        """
        **[Required]** Gets the clusters_count of this Sddc.
        The number of Clusters in the SDDC.


        :return: The clusters_count of this Sddc.
        :rtype: int
        """
        return self._clusters_count

    @clusters_count.setter
    def clusters_count(self, clusters_count):
        """
        Sets the clusters_count of this Sddc.
        The number of Clusters in the SDDC.


        :param clusters_count: The clusters_count of this Sddc.
        :type: int
        """
        self._clusters_count = clusters_count

    @property
    def vcenter_fqdn(self):
        """
        **[Required]** Gets the vcenter_fqdn of this Sddc.
        The FQDN for vCenter.

        Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`


        :return: The vcenter_fqdn of this Sddc.
        :rtype: str
        """
        return self._vcenter_fqdn

    @vcenter_fqdn.setter
    def vcenter_fqdn(self, vcenter_fqdn):
        """
        Sets the vcenter_fqdn of this Sddc.
        The FQDN for vCenter.

        Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`


        :param vcenter_fqdn: The vcenter_fqdn of this Sddc.
        :type: str
        """
        self._vcenter_fqdn = vcenter_fqdn

    @property
    def nsx_manager_fqdn(self):
        """
        **[Required]** Gets the nsx_manager_fqdn of this Sddc.
        The FQDN for NSX Manager.

        Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`


        :return: The nsx_manager_fqdn of this Sddc.
        :rtype: str
        """
        return self._nsx_manager_fqdn

    @nsx_manager_fqdn.setter
    def nsx_manager_fqdn(self, nsx_manager_fqdn):
        """
        Sets the nsx_manager_fqdn of this Sddc.
        The FQDN for NSX Manager.

        Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`


        :param nsx_manager_fqdn: The nsx_manager_fqdn of this Sddc.
        :type: str
        """
        self._nsx_manager_fqdn = nsx_manager_fqdn

    @property
    def vcenter_private_ip_id(self):
        """
        **[Required]** Gets the vcenter_private_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the
        Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vcenter_private_ip_id of this Sddc.
        :rtype: str
        """
        return self._vcenter_private_ip_id

    @vcenter_private_ip_id.setter
    def vcenter_private_ip_id(self, vcenter_private_ip_id):
        """
        Sets the vcenter_private_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the
        Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vcenter_private_ip_id: The vcenter_private_ip_id of this Sddc.
        :type: str
        """
        self._vcenter_private_ip_id = vcenter_private_ip_id

    @property
    def nsx_manager_private_ip_id(self):
        """
        **[Required]** Gets the nsx_manager_private_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the
        Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The nsx_manager_private_ip_id of this Sddc.
        :rtype: str
        """
        return self._nsx_manager_private_ip_id

    @nsx_manager_private_ip_id.setter
    def nsx_manager_private_ip_id(self, nsx_manager_private_ip_id):
        """
        Sets the nsx_manager_private_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the
        Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param nsx_manager_private_ip_id: The nsx_manager_private_ip_id of this Sddc.
        :type: str
        """
        self._nsx_manager_private_ip_id = nsx_manager_private_ip_id

    @property
    def vcenter_username(self):
        """
        Gets the vcenter_username of this Sddc.
        The SDDC includes an administrator username and password for vCenter. You can
        change this initial username to a different value in vCenter.


        :return: The vcenter_username of this Sddc.
        :rtype: str
        """
        return self._vcenter_username

    @vcenter_username.setter
    def vcenter_username(self, vcenter_username):
        """
        Sets the vcenter_username of this Sddc.
        The SDDC includes an administrator username and password for vCenter. You can
        change this initial username to a different value in vCenter.


        :param vcenter_username: The vcenter_username of this Sddc.
        :type: str
        """
        self._vcenter_username = vcenter_username

    @property
    def nsx_manager_username(self):
        """
        Gets the nsx_manager_username of this Sddc.
        The SDDC includes an administrator username and initial password for NSX Manager. You
        can change this initial username to a different value in NSX Manager.


        :return: The nsx_manager_username of this Sddc.
        :rtype: str
        """
        return self._nsx_manager_username

    @nsx_manager_username.setter
    def nsx_manager_username(self, nsx_manager_username):
        """
        Sets the nsx_manager_username of this Sddc.
        The SDDC includes an administrator username and initial password for NSX Manager. You
        can change this initial username to a different value in NSX Manager.


        :param nsx_manager_username: The nsx_manager_username of this Sddc.
        :type: str
        """
        self._nsx_manager_username = nsx_manager_username

    @property
    def ssh_authorized_keys(self):
        """
        **[Required]** Gets the ssh_authorized_keys of this Sddc.
        One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for
        the default user on each ESXi host. Use a newline character to separate multiple keys.
        The SSH keys must be in the format required for the `authorized_keys` file.

        This attribute is not guaranteed to reflect the public SSH keys
        currently installed on the ESXi hosts in the SDDC. The purpose
        of this attribute is to show the public SSH keys that Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        SDDC in the future* with :func:`create_esxi_host`.

        Therefore, if you upgrade the existing ESXi hosts in the SDDC to use different
        SSH keys, you should use :func:`update_sddc` to update
        the SDDC's `sshAuthorizedKeys` with the new public keys.


        :return: The ssh_authorized_keys of this Sddc.
        :rtype: str
        """
        return self._ssh_authorized_keys

    @ssh_authorized_keys.setter
    def ssh_authorized_keys(self, ssh_authorized_keys):
        """
        Sets the ssh_authorized_keys of this Sddc.
        One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for
        the default user on each ESXi host. Use a newline character to separate multiple keys.
        The SSH keys must be in the format required for the `authorized_keys` file.

        This attribute is not guaranteed to reflect the public SSH keys
        currently installed on the ESXi hosts in the SDDC. The purpose
        of this attribute is to show the public SSH keys that Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        SDDC in the future* with :func:`create_esxi_host`.

        Therefore, if you upgrade the existing ESXi hosts in the SDDC to use different
        SSH keys, you should use :func:`update_sddc` to update
        the SDDC's `sshAuthorizedKeys` with the new public keys.


        :param ssh_authorized_keys: The ssh_authorized_keys of this Sddc.
        :type: str
        """
        self._ssh_authorized_keys = ssh_authorized_keys

    @property
    def nsx_edge_uplink_ip_id(self):
        """
        Gets the nsx_edge_uplink_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for
        route table rules when setting up connectivity between the SDDC and other networks.
        For information about `PrivateIp` objects, see the Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The nsx_edge_uplink_ip_id of this Sddc.
        :rtype: str
        """
        return self._nsx_edge_uplink_ip_id

    @nsx_edge_uplink_ip_id.setter
    def nsx_edge_uplink_ip_id(self, nsx_edge_uplink_ip_id):
        """
        Sets the nsx_edge_uplink_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for
        route table rules when setting up connectivity between the SDDC and other networks.
        For information about `PrivateIp` objects, see the Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param nsx_edge_uplink_ip_id: The nsx_edge_uplink_ip_id of this Sddc.
        :type: str
        """
        self._nsx_edge_uplink_ip_id = nsx_edge_uplink_ip_id

    @property
    def hcx_private_ip_id(self):
        """
        Gets the hcx_private_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the
        Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The hcx_private_ip_id of this Sddc.
        :rtype: str
        """
        return self._hcx_private_ip_id

    @hcx_private_ip_id.setter
    def hcx_private_ip_id(self, hcx_private_ip_id):
        """
        Sets the hcx_private_ip_id of this Sddc.
        The `OCID`__ of the `PrivateIp` object that is
        the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the
        Core Services API.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param hcx_private_ip_id: The hcx_private_ip_id of this Sddc.
        :type: str
        """
        self._hcx_private_ip_id = hcx_private_ip_id

    @property
    def hcx_fqdn(self):
        """
        Gets the hcx_fqdn of this Sddc.
        The FQDN for HCX Manager.

        Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`


        :return: The hcx_fqdn of this Sddc.
        :rtype: str
        """
        return self._hcx_fqdn

    @hcx_fqdn.setter
    def hcx_fqdn(self, hcx_fqdn):
        """
        Sets the hcx_fqdn of this Sddc.
        The FQDN for HCX Manager.

        Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`


        :param hcx_fqdn: The hcx_fqdn of this Sddc.
        :type: str
        """
        self._hcx_fqdn = hcx_fqdn

    @property
    def hcx_mode(self):
        """
        **[Required]** Gets the hcx_mode of this Sddc.
        HCX configuration of the SDDC.

        Allowed values for this property are: "DISABLED", "ADVANCED", "ENTERPRISE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The hcx_mode of this Sddc.
        :rtype: str
        """
        return self._hcx_mode

    @hcx_mode.setter
    def hcx_mode(self, hcx_mode):
        """
        Sets the hcx_mode of this Sddc.
        HCX configuration of the SDDC.


        :param hcx_mode: The hcx_mode of this Sddc.
        :type: str
        """
        allowed_values = ["DISABLED", "ADVANCED", "ENTERPRISE"]
        if not value_allowed_none_or_none_sentinel(hcx_mode, allowed_values):
            hcx_mode = 'UNKNOWN_ENUM_VALUE'
        self._hcx_mode = hcx_mode

    @property
    def initial_configuration(self):
        """
        **[Required]** Gets the initial_configuration of this Sddc.

        :return: The initial_configuration of this Sddc.
        :rtype: oci.ocvp.models.InitialConfiguration
        """
        return self._initial_configuration

    @initial_configuration.setter
    def initial_configuration(self, initial_configuration):
        """
        Sets the initial_configuration of this Sddc.

        :param initial_configuration: The initial_configuration of this Sddc.
        :type: oci.ocvp.models.InitialConfiguration
        """
        self._initial_configuration = initial_configuration

    @property
    def is_hcx_pending_downgrade(self):
        """
        Gets the is_hcx_pending_downgrade of this Sddc.
        Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.


        :return: The is_hcx_pending_downgrade of this Sddc.
        :rtype: bool
        """
        return self._is_hcx_pending_downgrade

    @is_hcx_pending_downgrade.setter
    def is_hcx_pending_downgrade(self, is_hcx_pending_downgrade):
        """
        Sets the is_hcx_pending_downgrade of this Sddc.
        Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.


        :param is_hcx_pending_downgrade: The is_hcx_pending_downgrade of this Sddc.
        :type: bool
        """
        self._is_hcx_pending_downgrade = is_hcx_pending_downgrade

    @property
    def hcx_on_prem_licenses(self):
        """
        Gets the hcx_on_prem_licenses of this Sddc.
        The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.


        :return: The hcx_on_prem_licenses of this Sddc.
        :rtype: list[oci.ocvp.models.HcxLicenseSummary]
        """
        return self._hcx_on_prem_licenses

    @hcx_on_prem_licenses.setter
    def hcx_on_prem_licenses(self, hcx_on_prem_licenses):
        """
        Sets the hcx_on_prem_licenses of this Sddc.
        The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.


        :param hcx_on_prem_licenses: The hcx_on_prem_licenses of this Sddc.
        :type: list[oci.ocvp.models.HcxLicenseSummary]
        """
        self._hcx_on_prem_licenses = hcx_on_prem_licenses

    @property
    def time_hcx_billing_cycle_end(self):
        """
        Gets the time_hcx_billing_cycle_end of this Sddc.
        The date and time current HCX Enterprise billing cycle ends, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_hcx_billing_cycle_end of this Sddc.
        :rtype: datetime
        """
        return self._time_hcx_billing_cycle_end

    @time_hcx_billing_cycle_end.setter
    def time_hcx_billing_cycle_end(self, time_hcx_billing_cycle_end):
        """
        Sets the time_hcx_billing_cycle_end of this Sddc.
        The date and time current HCX Enterprise billing cycle ends, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_hcx_billing_cycle_end: The time_hcx_billing_cycle_end of this Sddc.
        :type: datetime
        """
        self._time_hcx_billing_cycle_end = time_hcx_billing_cycle_end

    @property
    def time_hcx_license_status_updated(self):
        """
        Gets the time_hcx_license_status_updated of this Sddc.
        The date and time the SDDC's HCX on-premise license status was updated, in the format defined by
        `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_hcx_license_status_updated of this Sddc.
        :rtype: datetime
        """
        return self._time_hcx_license_status_updated

    @time_hcx_license_status_updated.setter
    def time_hcx_license_status_updated(self, time_hcx_license_status_updated):
        """
        Sets the time_hcx_license_status_updated of this Sddc.
        The date and time the SDDC's HCX on-premise license status was updated, in the format defined by
        `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_hcx_license_status_updated: The time_hcx_license_status_updated of this Sddc.
        :type: datetime
        """
        self._time_hcx_license_status_updated = time_hcx_license_status_updated

    @property
    def is_single_host_sddc(self):
        """
        Gets the is_single_host_sddc of this Sddc.
        Indicates whether this SDDC is designated for only single ESXi host.


        :return: The is_single_host_sddc of this Sddc.
        :rtype: bool
        """
        return self._is_single_host_sddc

    @is_single_host_sddc.setter
    def is_single_host_sddc(self, is_single_host_sddc):
        """
        Sets the is_single_host_sddc of this Sddc.
        Indicates whether this SDDC is designated for only single ESXi host.


        :param is_single_host_sddc: The is_single_host_sddc of this Sddc.
        :type: bool
        """
        self._is_single_host_sddc = is_single_host_sddc

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Sddc.
        The date and time the SDDC was created, in the format defined by
        `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this Sddc.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Sddc.
        The date and time the SDDC was created, in the format defined by
        `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this Sddc.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Sddc.
        The date and time the SDDC was updated, in the format defined by
        `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this Sddc.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Sddc.
        The date and time the SDDC was updated, in the format defined by
        `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this Sddc.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this Sddc.
        The current state of the SDDC.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Sddc.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Sddc.
        The current state of the SDDC.


        :param lifecycle_state: The lifecycle_state of this Sddc.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this Sddc.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Sddc.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Sddc.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Sddc.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this Sddc.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Sddc.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Sddc.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Sddc.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Sddc.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :return: The system_tags of this Sddc.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Sddc.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :param system_tags: The system_tags of this Sddc.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
