# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplaceHostDetails(object):
    """
    The details for replacing ESXi host.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReplaceHostDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param esxi_software_version:
            The value to assign to the esxi_software_version property of this ReplaceHostDetails.
        :type esxi_software_version: str

        """
        self.swagger_types = {
            'esxi_software_version': 'str'
        }

        self.attribute_map = {
            'esxi_software_version': 'esxiSoftwareVersion'
        }

        self._esxi_software_version = None

    @property
    def esxi_software_version(self):
        """
        Gets the esxi_software_version of this ReplaceHostDetails.
        The ESXi software bundle to install on the ESXi host.
        Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted.
        To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :return: The esxi_software_version of this ReplaceHostDetails.
        :rtype: str
        """
        return self._esxi_software_version

    @esxi_software_version.setter
    def esxi_software_version(self, esxi_software_version):
        """
        Sets the esxi_software_version of this ReplaceHostDetails.
        The ESXi software bundle to install on the ESXi host.
        Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted.
        To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :param esxi_software_version: The esxi_software_version of this ReplaceHostDetails.
        :type: str
        """
        self._esxi_software_version = esxi_software_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
