# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrefixFqdns(object):
    """
    An object containing FQDNs
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrefixFqdns object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param object_storage_api_fqdn:
            The value to assign to the object_storage_api_fqdn property of this PrefixFqdns.
        :type object_storage_api_fqdn: str

        :param s3_compatibility_api_fqdn:
            The value to assign to the s3_compatibility_api_fqdn property of this PrefixFqdns.
        :type s3_compatibility_api_fqdn: str

        :param swift_api_fqdn:
            The value to assign to the swift_api_fqdn property of this PrefixFqdns.
        :type swift_api_fqdn: str

        """
        self.swagger_types = {
            'object_storage_api_fqdn': 'str',
            's3_compatibility_api_fqdn': 'str',
            'swift_api_fqdn': 'str'
        }

        self.attribute_map = {
            'object_storage_api_fqdn': 'objectStorageApiFqdn',
            's3_compatibility_api_fqdn': 's3CompatibilityApiFqdn',
            'swift_api_fqdn': 'swiftApiFqdn'
        }

        self._object_storage_api_fqdn = None
        self._s3_compatibility_api_fqdn = None
        self._swift_api_fqdn = None

    @property
    def object_storage_api_fqdn(self):
        """
        Gets the object_storage_api_fqdn of this PrefixFqdns.
        ObjectStorage API FQDN


        :return: The object_storage_api_fqdn of this PrefixFqdns.
        :rtype: str
        """
        return self._object_storage_api_fqdn

    @object_storage_api_fqdn.setter
    def object_storage_api_fqdn(self, object_storage_api_fqdn):
        """
        Sets the object_storage_api_fqdn of this PrefixFqdns.
        ObjectStorage API FQDN


        :param object_storage_api_fqdn: The object_storage_api_fqdn of this PrefixFqdns.
        :type: str
        """
        self._object_storage_api_fqdn = object_storage_api_fqdn

    @property
    def s3_compatibility_api_fqdn(self):
        """
        Gets the s3_compatibility_api_fqdn of this PrefixFqdns.
        S3 Compatibility API FQDN


        :return: The s3_compatibility_api_fqdn of this PrefixFqdns.
        :rtype: str
        """
        return self._s3_compatibility_api_fqdn

    @s3_compatibility_api_fqdn.setter
    def s3_compatibility_api_fqdn(self, s3_compatibility_api_fqdn):
        """
        Sets the s3_compatibility_api_fqdn of this PrefixFqdns.
        S3 Compatibility API FQDN


        :param s3_compatibility_api_fqdn: The s3_compatibility_api_fqdn of this PrefixFqdns.
        :type: str
        """
        self._s3_compatibility_api_fqdn = s3_compatibility_api_fqdn

    @property
    def swift_api_fqdn(self):
        """
        Gets the swift_api_fqdn of this PrefixFqdns.
        Swift API FQDN


        :return: The swift_api_fqdn of this PrefixFqdns.
        :rtype: str
        """
        return self._swift_api_fqdn

    @swift_api_fqdn.setter
    def swift_api_fqdn(self, swift_api_fqdn):
        """
        Sets the swift_api_fqdn of this PrefixFqdns.
        Swift API FQDN


        :param swift_api_fqdn: The swift_api_fqdn of this PrefixFqdns.
        :type: str
        """
        self._swift_api_fqdn = swift_api_fqdn

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
