# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TunnelInspectionRule(object):
    """
    Tunnel Inspection Rule used in the firewall policy rules.
    Tunnel Inspection Rule determines whether tunnel inspection is applied on the traffic based on attributes
    such as  Tunnel Inspect protocol, the source and destination IP addresses.
    """

    #: A constant which can be used with the protocol property of a TunnelInspectionRule.
    #: This constant has a value of "VXLAN"
    PROTOCOL_VXLAN = "VXLAN"

    #: A constant which can be used with the action property of a TunnelInspectionRule.
    #: This constant has a value of "INSPECT"
    ACTION_INSPECT = "INSPECT"

    #: A constant which can be used with the action property of a TunnelInspectionRule.
    #: This constant has a value of "INSPECT_AND_CAPTURE_LOG"
    ACTION_INSPECT_AND_CAPTURE_LOG = "INSPECT_AND_CAPTURE_LOG"

    def __init__(self, **kwargs):
        """
        Initializes a new TunnelInspectionRule object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.network_firewall.models.VxlanInspectionRule`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this TunnelInspectionRule.
        :type name: str

        :param protocol:
            The value to assign to the protocol property of this TunnelInspectionRule.
            Allowed values for this property are: "VXLAN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type protocol: str

        :param action:
            The value to assign to the action property of this TunnelInspectionRule.
            Allowed values for this property are: "INSPECT", "INSPECT_AND_CAPTURE_LOG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action: str

        :param priority_order:
            The value to assign to the priority_order property of this TunnelInspectionRule.
        :type priority_order: int

        :param position:
            The value to assign to the position property of this TunnelInspectionRule.
        :type position: oci.network_firewall.models.RulePosition

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this TunnelInspectionRule.
        :type parent_resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'protocol': 'str',
            'action': 'str',
            'priority_order': 'int',
            'position': 'RulePosition',
            'parent_resource_id': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'protocol': 'protocol',
            'action': 'action',
            'priority_order': 'priorityOrder',
            'position': 'position',
            'parent_resource_id': 'parentResourceId'
        }

        self._name = None
        self._protocol = None
        self._action = None
        self._priority_order = None
        self._position = None
        self._parent_resource_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['protocol']

        if type == 'VXLAN':
            return 'VxlanInspectionRule'
        else:
            return 'TunnelInspectionRule'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this TunnelInspectionRule.
        Name for the Tunnel Inspection Rule, must be unique within the policy.


        :return: The name of this TunnelInspectionRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TunnelInspectionRule.
        Name for the Tunnel Inspection Rule, must be unique within the policy.


        :param name: The name of this TunnelInspectionRule.
        :type: str
        """
        self._name = name

    @property
    def protocol(self):
        """
        **[Required]** Gets the protocol of this TunnelInspectionRule.
        Types of Tunnel Inspection Protocol to be applied on the traffic.

          * VXLAN - VXLAN Tunnel Inspection Protocol will be applied on the traffic.

        Allowed values for this property are: "VXLAN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The protocol of this TunnelInspectionRule.
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """
        Sets the protocol of this TunnelInspectionRule.
        Types of Tunnel Inspection Protocol to be applied on the traffic.

          * VXLAN - VXLAN Tunnel Inspection Protocol will be applied on the traffic.


        :param protocol: The protocol of this TunnelInspectionRule.
        :type: str
        """
        allowed_values = ["VXLAN"]
        if not value_allowed_none_or_none_sentinel(protocol, allowed_values):
            protocol = 'UNKNOWN_ENUM_VALUE'
        self._protocol = protocol

    @property
    def action(self):
        """
        Gets the action of this TunnelInspectionRule.
        Types of Inspect Action on the Traffic flow.

          * INSPECT - Inspect the traffic.
          * INSPECT_AND_CAPTURE_LOG - Inspect and capture logs for the traffic.

        Allowed values for this property are: "INSPECT", "INSPECT_AND_CAPTURE_LOG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action of this TunnelInspectionRule.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this TunnelInspectionRule.
        Types of Inspect Action on the Traffic flow.

          * INSPECT - Inspect the traffic.
          * INSPECT_AND_CAPTURE_LOG - Inspect and capture logs for the traffic.


        :param action: The action of this TunnelInspectionRule.
        :type: str
        """
        allowed_values = ["INSPECT", "INSPECT_AND_CAPTURE_LOG"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            action = 'UNKNOWN_ENUM_VALUE'
        self._action = action

    @property
    def priority_order(self):
        """
        Gets the priority_order of this TunnelInspectionRule.
        The priority order in which this rule should be evaluated


        :return: The priority_order of this TunnelInspectionRule.
        :rtype: int
        """
        return self._priority_order

    @priority_order.setter
    def priority_order(self, priority_order):
        """
        Sets the priority_order of this TunnelInspectionRule.
        The priority order in which this rule should be evaluated


        :param priority_order: The priority_order of this TunnelInspectionRule.
        :type: int
        """
        self._priority_order = priority_order

    @property
    def position(self):
        """
        Gets the position of this TunnelInspectionRule.

        :return: The position of this TunnelInspectionRule.
        :rtype: oci.network_firewall.models.RulePosition
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this TunnelInspectionRule.

        :param position: The position of this TunnelInspectionRule.
        :type: oci.network_firewall.models.RulePosition
        """
        self._position = position

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this TunnelInspectionRule.
        OCID of the Network Firewall Policy this Tunnel Inspection Rule belongs to.


        :return: The parent_resource_id of this TunnelInspectionRule.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this TunnelInspectionRule.
        OCID of the Network Firewall Policy this Tunnel Inspection Rule belongs to.


        :param parent_resource_id: The parent_resource_id of this TunnelInspectionRule.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
