# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180401


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAlarmSuppressionDetails(object):
    """
    The configuration details for creating an alarm suppression.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAlarmSuppressionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param alarm_suppression_target:
            The value to assign to the alarm_suppression_target property of this CreateAlarmSuppressionDetails.
        :type alarm_suppression_target: oci.monitoring.models.AlarmSuppressionTarget

        :param level:
            The value to assign to the level property of this CreateAlarmSuppressionDetails.
        :type level: str

        :param display_name:
            The value to assign to the display_name property of this CreateAlarmSuppressionDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateAlarmSuppressionDetails.
        :type description: str

        :param dimensions:
            The value to assign to the dimensions property of this CreateAlarmSuppressionDetails.
        :type dimensions: dict(str, str)

        :param time_suppress_from:
            The value to assign to the time_suppress_from property of this CreateAlarmSuppressionDetails.
        :type time_suppress_from: datetime

        :param time_suppress_until:
            The value to assign to the time_suppress_until property of this CreateAlarmSuppressionDetails.
        :type time_suppress_until: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAlarmSuppressionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAlarmSuppressionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param suppression_conditions:
            The value to assign to the suppression_conditions property of this CreateAlarmSuppressionDetails.
        :type suppression_conditions: list[oci.monitoring.models.SuppressionCondition]

        """
        self.swagger_types = {
            'alarm_suppression_target': 'AlarmSuppressionTarget',
            'level': 'str',
            'display_name': 'str',
            'description': 'str',
            'dimensions': 'dict(str, str)',
            'time_suppress_from': 'datetime',
            'time_suppress_until': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'suppression_conditions': 'list[SuppressionCondition]'
        }

        self.attribute_map = {
            'alarm_suppression_target': 'alarmSuppressionTarget',
            'level': 'level',
            'display_name': 'displayName',
            'description': 'description',
            'dimensions': 'dimensions',
            'time_suppress_from': 'timeSuppressFrom',
            'time_suppress_until': 'timeSuppressUntil',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'suppression_conditions': 'suppressionConditions'
        }

        self._alarm_suppression_target = None
        self._level = None
        self._display_name = None
        self._description = None
        self._dimensions = None
        self._time_suppress_from = None
        self._time_suppress_until = None
        self._freeform_tags = None
        self._defined_tags = None
        self._suppression_conditions = None

    @property
    def alarm_suppression_target(self):
        """
        **[Required]** Gets the alarm_suppression_target of this CreateAlarmSuppressionDetails.

        :return: The alarm_suppression_target of this CreateAlarmSuppressionDetails.
        :rtype: oci.monitoring.models.AlarmSuppressionTarget
        """
        return self._alarm_suppression_target

    @alarm_suppression_target.setter
    def alarm_suppression_target(self, alarm_suppression_target):
        """
        Sets the alarm_suppression_target of this CreateAlarmSuppressionDetails.

        :param alarm_suppression_target: The alarm_suppression_target of this CreateAlarmSuppressionDetails.
        :type: oci.monitoring.models.AlarmSuppressionTarget
        """
        self._alarm_suppression_target = alarm_suppression_target

    @property
    def level(self):
        """
        Gets the level of this CreateAlarmSuppressionDetails.
        The level of this alarm suppression.
        `ALARM` indicates a suppression of the entire alarm, regardless of dimension.
        `DIMENSION` indicates a suppression configured for specified dimensions.

        Defaut: `DIMENSION`


        :return: The level of this CreateAlarmSuppressionDetails.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this CreateAlarmSuppressionDetails.
        The level of this alarm suppression.
        `ALARM` indicates a suppression of the entire alarm, regardless of dimension.
        `DIMENSION` indicates a suppression configured for specified dimensions.

        Defaut: `DIMENSION`


        :param level: The level of this CreateAlarmSuppressionDetails.
        :type: str
        """
        self._level = level

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateAlarmSuppressionDetails.
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateAlarmSuppressionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateAlarmSuppressionDetails.
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateAlarmSuppressionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateAlarmSuppressionDetails.
        Human-readable reason for this alarm suppression.
        It does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work,
        such as a ticket number.

        Example: `Planned outage due to change IT-1234.`


        :return: The description of this CreateAlarmSuppressionDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateAlarmSuppressionDetails.
        Human-readable reason for this alarm suppression.
        It does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work,
        such as a ticket number.

        Example: `Planned outage due to change IT-1234.`


        :param description: The description of this CreateAlarmSuppressionDetails.
        :type: str
        """
        self._description = description

    @property
    def dimensions(self):
        """
        Gets the dimensions of this CreateAlarmSuppressionDetails.
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs.
        If you specify {\"availabilityDomain\": \"phx-ad-1\"}
        and the alarm state entry corresponds to the set {\"availabilityDomain\": \"phx-ad-1\" and \"resourceId\": \"ocid1.instance.region1.phx.exampleuniqueID\"},
        then this alarm will be included for suppression.

        This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object.
        Only a single value is allowed per key. No grouping of multiple values is allowed under the same key.
        Maximum characters (after serialization): 4000. This maximum satisfies typical use cases.
        The response for an exceeded maximum is `HTTP 400` with an \"dimensions values are too long\" message.


        :return: The dimensions of this CreateAlarmSuppressionDetails.
        :rtype: dict(str, str)
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this CreateAlarmSuppressionDetails.
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs.
        If you specify {\"availabilityDomain\": \"phx-ad-1\"}
        and the alarm state entry corresponds to the set {\"availabilityDomain\": \"phx-ad-1\" and \"resourceId\": \"ocid1.instance.region1.phx.exampleuniqueID\"},
        then this alarm will be included for suppression.

        This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object.
        Only a single value is allowed per key. No grouping of multiple values is allowed under the same key.
        Maximum characters (after serialization): 4000. This maximum satisfies typical use cases.
        The response for an exceeded maximum is `HTTP 400` with an \"dimensions values are too long\" message.


        :param dimensions: The dimensions of this CreateAlarmSuppressionDetails.
        :type: dict(str, str)
        """
        self._dimensions = dimensions

    @property
    def time_suppress_from(self):
        """
        **[Required]** Gets the time_suppress_from of this CreateAlarmSuppressionDetails.
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T01:02:29.600Z`


        :return: The time_suppress_from of this CreateAlarmSuppressionDetails.
        :rtype: datetime
        """
        return self._time_suppress_from

    @time_suppress_from.setter
    def time_suppress_from(self, time_suppress_from):
        """
        Sets the time_suppress_from of this CreateAlarmSuppressionDetails.
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T01:02:29.600Z`


        :param time_suppress_from: The time_suppress_from of this CreateAlarmSuppressionDetails.
        :type: datetime
        """
        self._time_suppress_from = time_suppress_from

    @property
    def time_suppress_until(self):
        """
        **[Required]** Gets the time_suppress_until of this CreateAlarmSuppressionDetails.
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T02:02:29.600Z`


        :return: The time_suppress_until of this CreateAlarmSuppressionDetails.
        :rtype: datetime
        """
        return self._time_suppress_until

    @time_suppress_until.setter
    def time_suppress_until(self, time_suppress_until):
        """
        Sets the time_suppress_until of this CreateAlarmSuppressionDetails.
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T02:02:29.600Z`


        :param time_suppress_until: The time_suppress_until of this CreateAlarmSuppressionDetails.
        :type: datetime
        """
        self._time_suppress_until = time_suppress_until

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAlarmSuppressionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"Department\": \"Finance\"}`


        :return: The freeform_tags of this CreateAlarmSuppressionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAlarmSuppressionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"Department\": \"Finance\"}`


        :param freeform_tags: The freeform_tags of this CreateAlarmSuppressionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAlarmSuppressionDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :return: The defined_tags of this CreateAlarmSuppressionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAlarmSuppressionDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :param defined_tags: The defined_tags of this CreateAlarmSuppressionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def suppression_conditions(self):
        """
        Gets the suppression_conditions of this CreateAlarmSuppressionDetails.
        Array of all preconditions for alarm suppression.
        Example: `[{
          conditionType: \"RECURRENCE\",
          suppressionRecurrence: \"FRQ=DAILY;BYHOUR=10\",
          suppressionDuration: \"PT1H\"
        }]`


        :return: The suppression_conditions of this CreateAlarmSuppressionDetails.
        :rtype: list[oci.monitoring.models.SuppressionCondition]
        """
        return self._suppression_conditions

    @suppression_conditions.setter
    def suppression_conditions(self, suppression_conditions):
        """
        Sets the suppression_conditions of this CreateAlarmSuppressionDetails.
        Array of all preconditions for alarm suppression.
        Example: `[{
          conditionType: \"RECURRENCE\",
          suppressionRecurrence: \"FRQ=DAILY;BYHOUR=10\",
          suppressionDuration: \"PT1H\"
        }]`


        :param suppression_conditions: The suppression_conditions of this CreateAlarmSuppressionDetails.
        :type: list[oci.monitoring.models.SuppressionCondition]
        """
        self._suppression_conditions = suppression_conditions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
