# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901

from .listing_revision_attachment import ListingRevisionAttachment
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoAttachment(ListingRevisionAttachment):
    """
    Video attachment for the listing revision.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoAttachment object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.VideoAttachment.attachment_type` attribute
        of this class is ``VIDEO`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this VideoAttachment.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VideoAttachment.
        :type compartment_id: str

        :param listing_revision_id:
            The value to assign to the listing_revision_id property of this VideoAttachment.
        :type listing_revision_id: str

        :param display_name:
            The value to assign to the display_name property of this VideoAttachment.
        :type display_name: str

        :param description:
            The value to assign to the description property of this VideoAttachment.
        :type description: str

        :param attachment_type:
            The value to assign to the attachment_type property of this VideoAttachment.
            Allowed values for this property are: "RELATED_DOCUMENT", "SCREENSHOT", "VIDEO"
        :type attachment_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this VideoAttachment.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETED"
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this VideoAttachment.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this VideoAttachment.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this VideoAttachment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this VideoAttachment.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this VideoAttachment.
        :type system_tags: dict(str, dict(str, object))

        :param content_url:
            The value to assign to the content_url property of this VideoAttachment.
        :type content_url: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'listing_revision_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'attachment_type': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'content_url': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'listing_revision_id': 'listingRevisionId',
            'display_name': 'displayName',
            'description': 'description',
            'attachment_type': 'attachmentType',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'content_url': 'contentUrl'
        }

        self._id = None
        self._compartment_id = None
        self._listing_revision_id = None
        self._display_name = None
        self._description = None
        self._attachment_type = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._content_url = None
        self._attachment_type = 'VIDEO'

    @property
    def content_url(self):
        """
        **[Required]** Gets the content_url of this VideoAttachment.
        The URL for the video.


        :return: The content_url of this VideoAttachment.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url):
        """
        Sets the content_url of this VideoAttachment.
        The URL for the video.


        :param content_url: The content_url of this VideoAttachment.
        :type: str
        """
        self._content_url = content_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
