# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Attachment(object):
    """
    Description of Attachment.
    """

    #: A constant which can be used with the type property of a Attachment.
    #: This constant has a value of "CONTRACT_T_AND_C"
    TYPE_CONTRACT_T_AND_C = "CONTRACT_T_AND_C"

    #: A constant which can be used with the type property of a Attachment.
    #: This constant has a value of "QUOTE"
    TYPE_QUOTE = "QUOTE"

    #: A constant which can be used with the type property of a Attachment.
    #: This constant has a value of "EULA"
    TYPE_EULA = "EULA"

    #: A constant which can be used with the type property of a Attachment.
    #: This constant has a value of "TERMS_OF_USE"
    TYPE_TERMS_OF_USE = "TERMS_OF_USE"

    #: A constant which can be used with the type property of a Attachment.
    #: This constant has a value of "MISC"
    TYPE_MISC = "MISC"

    #: A constant which can be used with the lifecycle_state property of a Attachment.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Attachment.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Attachment.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Attachment.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Attachment.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Attachment.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new Attachment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Attachment.
        :type id: str

        :param seller_compartment_id:
            The value to assign to the seller_compartment_id property of this Attachment.
        :type seller_compartment_id: str

        :param offer_id:
            The value to assign to the offer_id property of this Attachment.
        :type offer_id: str

        :param buyer_compartment_id:
            The value to assign to the buyer_compartment_id property of this Attachment.
        :type buyer_compartment_id: str

        :param mime_type:
            The value to assign to the mime_type property of this Attachment.
        :type mime_type: str

        :param display_name:
            The value to assign to the display_name property of this Attachment.
        :type display_name: str

        :param type:
            The value to assign to the type property of this Attachment.
            Allowed values for this property are: "CONTRACT_T_AND_C", "QUOTE", "EULA", "TERMS_OF_USE", "MISC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param time_created:
            The value to assign to the time_created property of this Attachment.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Attachment.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Attachment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Attachment.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'seller_compartment_id': 'str',
            'offer_id': 'str',
            'buyer_compartment_id': 'str',
            'mime_type': 'str',
            'display_name': 'str',
            'type': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'seller_compartment_id': 'sellerCompartmentId',
            'offer_id': 'offerId',
            'buyer_compartment_id': 'buyerCompartmentId',
            'mime_type': 'mimeType',
            'display_name': 'displayName',
            'type': 'type',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._seller_compartment_id = None
        self._offer_id = None
        self._buyer_compartment_id = None
        self._mime_type = None
        self._display_name = None
        self._type = None
        self._time_created = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Attachment.
        Unique identifier that is immutable on creation


        :return: The id of this Attachment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Attachment.
        Unique identifier that is immutable on creation


        :param id: The id of this Attachment.
        :type: str
        """
        self._id = id

    @property
    def seller_compartment_id(self):
        """
        **[Required]** Gets the seller_compartment_id of this Attachment.
        OCID of the seller's tenancy (root compartment).


        :return: The seller_compartment_id of this Attachment.
        :rtype: str
        """
        return self._seller_compartment_id

    @seller_compartment_id.setter
    def seller_compartment_id(self, seller_compartment_id):
        """
        Sets the seller_compartment_id of this Attachment.
        OCID of the seller's tenancy (root compartment).


        :param seller_compartment_id: The seller_compartment_id of this Attachment.
        :type: str
        """
        self._seller_compartment_id = seller_compartment_id

    @property
    def offer_id(self):
        """
        **[Required]** Gets the offer_id of this Attachment.
        Unique identifier of the associated offer that is immutable on creation


        :return: The offer_id of this Attachment.
        :rtype: str
        """
        return self._offer_id

    @offer_id.setter
    def offer_id(self, offer_id):
        """
        Sets the offer_id of this Attachment.
        Unique identifier of the associated offer that is immutable on creation


        :param offer_id: The offer_id of this Attachment.
        :type: str
        """
        self._offer_id = offer_id

    @property
    def buyer_compartment_id(self):
        """
        Gets the buyer_compartment_id of this Attachment.
        OCID of the buyer's tenancy (root compartment).


        :return: The buyer_compartment_id of this Attachment.
        :rtype: str
        """
        return self._buyer_compartment_id

    @buyer_compartment_id.setter
    def buyer_compartment_id(self, buyer_compartment_id):
        """
        Sets the buyer_compartment_id of this Attachment.
        OCID of the buyer's tenancy (root compartment).


        :param buyer_compartment_id: The buyer_compartment_id of this Attachment.
        :type: str
        """
        self._buyer_compartment_id = buyer_compartment_id

    @property
    def mime_type(self):
        """
        Gets the mime_type of this Attachment.
        The MIME type of the uploaded data.


        :return: The mime_type of this Attachment.
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """
        Sets the mime_type of this Attachment.
        The MIME type of the uploaded data.


        :param mime_type: The mime_type of this Attachment.
        :type: str
        """
        self._mime_type = mime_type

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Attachment.
        The name used to refer to the uploaded data.


        :return: The display_name of this Attachment.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Attachment.
        The name used to refer to the uploaded data.


        :param display_name: The display_name of this Attachment.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this Attachment.
        The type of offer attachment.

        Allowed values for this property are: "CONTRACT_T_AND_C", "QUOTE", "EULA", "TERMS_OF_USE", "MISC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this Attachment.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Attachment.
        The type of offer attachment.


        :param type: The type of this Attachment.
        :type: str
        """
        allowed_values = ["CONTRACT_T_AND_C", "QUOTE", "EULA", "TERMS_OF_USE", "MISC"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Attachment.
        The time the the Offer was created. An RFC3339 formatted datetime string


        :return: The time_created of this Attachment.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Attachment.
        The time the the Offer was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this Attachment.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Attachment.
        The current state of the Offer.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Attachment.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Attachment.
        The current state of the Offer.


        :param lifecycle_state: The lifecycle_state of this Attachment.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this Attachment.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this Attachment.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Attachment.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this Attachment.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this Attachment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Attachment.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Attachment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Attachment.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
