# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202

from .data_source_summary import DataSourceSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrometheusEmitterDataSourceSummary(DataSourceSummary):
    """
    A Prometheus emitter data source summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrometheusEmitterDataSourceSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.management_agent.models.PrometheusEmitterDataSourceSummary.type` attribute
        of this class is ``PROMETHEUS_EMITTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this PrometheusEmitterDataSourceSummary.
        :type key: str

        :param type:
            The value to assign to the type property of this PrometheusEmitterDataSourceSummary.
            Allowed values for this property are: "KUBERNETES_CLUSTER", "PROMETHEUS_EMITTER"
        :type type: str

        :param name:
            The value to assign to the name property of this PrometheusEmitterDataSourceSummary.
        :type name: str

        """
        self.swagger_types = {
            'key': 'str',
            'type': 'str',
            'name': 'str'
        }

        self.attribute_map = {
            'key': 'key',
            'type': 'type',
            'name': 'name'
        }

        self._key = None
        self._type = None
        self._name = None
        self._type = 'PROMETHEUS_EMITTER'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
