# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531

from .unified_agent_logging_filter import UnifiedAgentLoggingFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentCustomFilter(UnifiedAgentLoggingFilter):
    """
    Logging custom filter plugin.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentCustomFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.logging.models.UnifiedAgentCustomFilter.filter_type` attribute
        of this class is ``CUSTOM_FILTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UnifiedAgentCustomFilter.
        :type name: str

        :param filter_type:
            The value to assign to the filter_type property of this UnifiedAgentCustomFilter.
            Allowed values for this property are: "PARSER_FILTER", "GREP_FILTER", "RECORD_TRANSFORMER_FILTER", "CUSTOM_FILTER"
        :type filter_type: str

        :param custom_filter_type:
            The value to assign to the custom_filter_type property of this UnifiedAgentCustomFilter.
        :type custom_filter_type: str

        :param params:
            The value to assign to the params property of this UnifiedAgentCustomFilter.
        :type params: dict(str, str)

        :param custom_sections:
            The value to assign to the custom_sections property of this UnifiedAgentCustomFilter.
        :type custom_sections: list[oci.logging.models.UnifiedAgentCustomSection]

        """
        self.swagger_types = {
            'name': 'str',
            'filter_type': 'str',
            'custom_filter_type': 'str',
            'params': 'dict(str, str)',
            'custom_sections': 'list[UnifiedAgentCustomSection]'
        }

        self.attribute_map = {
            'name': 'name',
            'filter_type': 'filterType',
            'custom_filter_type': 'customFilterType',
            'params': 'params',
            'custom_sections': 'customSections'
        }

        self._name = None
        self._filter_type = None
        self._custom_filter_type = None
        self._params = None
        self._custom_sections = None
        self._filter_type = 'CUSTOM_FILTER'

    @property
    def custom_filter_type(self):
        """
        **[Required]** Gets the custom_filter_type of this UnifiedAgentCustomFilter.
        Type of the custom filter


        :return: The custom_filter_type of this UnifiedAgentCustomFilter.
        :rtype: str
        """
        return self._custom_filter_type

    @custom_filter_type.setter
    def custom_filter_type(self, custom_filter_type):
        """
        Sets the custom_filter_type of this UnifiedAgentCustomFilter.
        Type of the custom filter


        :param custom_filter_type: The custom_filter_type of this UnifiedAgentCustomFilter.
        :type: str
        """
        self._custom_filter_type = custom_filter_type

    @property
    def params(self):
        """
        Gets the params of this UnifiedAgentCustomFilter.
        Parameters of the custom filter


        :return: The params of this UnifiedAgentCustomFilter.
        :rtype: dict(str, str)
        """
        return self._params

    @params.setter
    def params(self, params):
        """
        Sets the params of this UnifiedAgentCustomFilter.
        Parameters of the custom filter


        :param params: The params of this UnifiedAgentCustomFilter.
        :type: dict(str, str)
        """
        self._params = params

    @property
    def custom_sections(self):
        """
        Gets the custom_sections of this UnifiedAgentCustomFilter.
        List of custom sections in custom filter


        :return: The custom_sections of this UnifiedAgentCustomFilter.
        :rtype: list[oci.logging.models.UnifiedAgentCustomSection]
        """
        return self._custom_sections

    @custom_sections.setter
    def custom_sections(self, custom_sections):
        """
        Sets the custom_sections of this UnifiedAgentCustomFilter.
        List of custom sections in custom filter


        :param custom_sections: The custom_sections of this UnifiedAgentCustomFilter.
        :type: list[oci.logging.models.UnifiedAgentCustomSection]
        """
        self._custom_sections = custom_sections

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
