# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DependentSource(object):
    """
    A source that uses the parser, either directly or indirectly.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DependentSource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_name:
            The value to assign to the source_name property of this DependentSource.
        :type source_name: str

        :param source_display_name:
            The value to assign to the source_display_name property of this DependentSource.
        :type source_display_name: str

        :param source_id:
            The value to assign to the source_id property of this DependentSource.
        :type source_id: int

        :param source_type:
            The value to assign to the source_type property of this DependentSource.
        :type source_type: str

        :param is_system:
            The value to assign to the is_system property of this DependentSource.
        :type is_system: bool

        :param is_auto_association_enabled:
            The value to assign to the is_auto_association_enabled property of this DependentSource.
        :type is_auto_association_enabled: bool

        :param entity_types:
            The value to assign to the entity_types property of this DependentSource.
        :type entity_types: list[oci.log_analytics.models.LogAnalyticsSourceEntityType]

        :param dependencies:
            The value to assign to the dependencies property of this DependentSource.
        :type dependencies: list[oci.log_analytics.models.Dependency]

        """
        self.swagger_types = {
            'source_name': 'str',
            'source_display_name': 'str',
            'source_id': 'int',
            'source_type': 'str',
            'is_system': 'bool',
            'is_auto_association_enabled': 'bool',
            'entity_types': 'list[LogAnalyticsSourceEntityType]',
            'dependencies': 'list[Dependency]'
        }

        self.attribute_map = {
            'source_name': 'sourceName',
            'source_display_name': 'sourceDisplayName',
            'source_id': 'sourceId',
            'source_type': 'sourceType',
            'is_system': 'isSystem',
            'is_auto_association_enabled': 'isAutoAssociationEnabled',
            'entity_types': 'entityTypes',
            'dependencies': 'dependencies'
        }

        self._source_name = None
        self._source_display_name = None
        self._source_id = None
        self._source_type = None
        self._is_system = None
        self._is_auto_association_enabled = None
        self._entity_types = None
        self._dependencies = None

    @property
    def source_name(self):
        """
        Gets the source_name of this DependentSource.
        The source name.


        :return: The source_name of this DependentSource.
        :rtype: str
        """
        return self._source_name

    @source_name.setter
    def source_name(self, source_name):
        """
        Sets the source_name of this DependentSource.
        The source name.


        :param source_name: The source_name of this DependentSource.
        :type: str
        """
        self._source_name = source_name

    @property
    def source_display_name(self):
        """
        Gets the source_display_name of this DependentSource.
        The source display name.


        :return: The source_display_name of this DependentSource.
        :rtype: str
        """
        return self._source_display_name

    @source_display_name.setter
    def source_display_name(self, source_display_name):
        """
        Sets the source_display_name of this DependentSource.
        The source display name.


        :param source_display_name: The source_display_name of this DependentSource.
        :type: str
        """
        self._source_display_name = source_display_name

    @property
    def source_id(self):
        """
        Gets the source_id of this DependentSource.
        The source unique identifier.


        :return: The source_id of this DependentSource.
        :rtype: int
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id):
        """
        Sets the source_id of this DependentSource.
        The source unique identifier.


        :param source_id: The source_id of this DependentSource.
        :type: int
        """
        self._source_id = source_id

    @property
    def source_type(self):
        """
        Gets the source_type of this DependentSource.
        The source type.


        :return: The source_type of this DependentSource.
        :rtype: str
        """
        return self._source_type

    @source_type.setter
    def source_type(self, source_type):
        """
        Sets the source_type of this DependentSource.
        The source type.


        :param source_type: The source_type of this DependentSource.
        :type: str
        """
        self._source_type = source_type

    @property
    def is_system(self):
        """
        Gets the is_system of this DependentSource.
        The system flag.  A value of false denotes a custom, or user
        defined object.  A value of true denotes a built in object.


        :return: The is_system of this DependentSource.
        :rtype: bool
        """
        return self._is_system

    @is_system.setter
    def is_system(self, is_system):
        """
        Sets the is_system of this DependentSource.
        The system flag.  A value of false denotes a custom, or user
        defined object.  A value of true denotes a built in object.


        :param is_system: The is_system of this DependentSource.
        :type: bool
        """
        self._is_system = is_system

    @property
    def is_auto_association_enabled(self):
        """
        Gets the is_auto_association_enabled of this DependentSource.
        A flag indicating whether or not the source is marked for auto association.


        :return: The is_auto_association_enabled of this DependentSource.
        :rtype: bool
        """
        return self._is_auto_association_enabled

    @is_auto_association_enabled.setter
    def is_auto_association_enabled(self, is_auto_association_enabled):
        """
        Sets the is_auto_association_enabled of this DependentSource.
        A flag indicating whether or not the source is marked for auto association.


        :param is_auto_association_enabled: The is_auto_association_enabled of this DependentSource.
        :type: bool
        """
        self._is_auto_association_enabled = is_auto_association_enabled

    @property
    def entity_types(self):
        """
        Gets the entity_types of this DependentSource.
        The entity types.


        :return: The entity_types of this DependentSource.
        :rtype: list[oci.log_analytics.models.LogAnalyticsSourceEntityType]
        """
        return self._entity_types

    @entity_types.setter
    def entity_types(self, entity_types):
        """
        Sets the entity_types of this DependentSource.
        The entity types.


        :param entity_types: The entity_types of this DependentSource.
        :type: list[oci.log_analytics.models.LogAnalyticsSourceEntityType]
        """
        self._entity_types = entity_types

    @property
    def dependencies(self):
        """
        Gets the dependencies of this DependentSource.
        The list of dependencies defined by the source.


        :return: The dependencies of this DependentSource.
        :rtype: list[oci.log_analytics.models.Dependency]
        """
        return self._dependencies

    @dependencies.setter
    def dependencies(self, dependencies):
        """
        Sets the dependencies of this DependentSource.
        The list of dependencies defined by the source.


        :param dependencies: The dependencies of this DependentSource.
        :type: list[oci.log_analytics.models.Dependency]
        """
        self._dependencies = dependencies

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
