# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManageDrsDetails(object):
    """
    Details of the request to manage DRS in active managed instance(s) in a Fleet.
    When the targets aren't specified, then all active managed instance(s) currently in the Fleet are selected.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManageDrsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param targets:
            The value to assign to the targets property of this ManageDrsDetails.
        :type targets: list[oci.jms.models.DrsTarget]

        """
        self.swagger_types = {
            'targets': 'list[DrsTarget]'
        }

        self.attribute_map = {
            'targets': 'targets'
        }

        self._targets = None

    @property
    def targets(self):
        """
        Gets the targets of this ManageDrsDetails.
        The targets to manage DRS.


        :return: The targets of this ManageDrsDetails.
        :rtype: list[oci.jms.models.DrsTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this ManageDrsDetails.
        The targets to manage DRS.


        :param targets: The targets of this ManageDrsDetails.
        :type: list[oci.jms.models.DrsTarget]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
