# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RuleConditionGroup(object):
    """
    Condition or ConditionGroup assigned to the rule

    **SCIM++ Properties:**
    - idcsSearchable: true
    - multiValued: false
    - mutability: readWrite
    - required: false
    - returned: default
    - type: complex
    - uniqueness: none
    """

    #: A constant which can be used with the type property of a RuleConditionGroup.
    #: This constant has a value of "Condition"
    TYPE_CONDITION = "Condition"

    #: A constant which can be used with the type property of a RuleConditionGroup.
    #: This constant has a value of "ConditionGroup"
    TYPE_CONDITION_GROUP = "ConditionGroup"

    def __init__(self, **kwargs):
        """
        Initializes a new RuleConditionGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this RuleConditionGroup.
        :type value: str

        :param ref:
            The value to assign to the ref property of this RuleConditionGroup.
        :type ref: str

        :param type:
            The value to assign to the type property of this RuleConditionGroup.
            Allowed values for this property are: "Condition", "ConditionGroup", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param name:
            The value to assign to the name property of this RuleConditionGroup.
        :type name: str

        """
        self.swagger_types = {
            'value': 'str',
            'ref': 'str',
            'type': 'str',
            'name': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'ref': '$ref',
            'type': 'type',
            'name': 'name'
        }

        self._value = None
        self._ref = None
        self._type = None
        self._name = None

    @property
    def value(self):
        """
        Gets the value of this RuleConditionGroup.
        Condition or ConditionGroup identifier.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this RuleConditionGroup.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this RuleConditionGroup.
        Condition or ConditionGroup identifier.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this RuleConditionGroup.
        :type: str
        """
        self._value = value

    @property
    def ref(self):
        """
        Gets the ref of this RuleConditionGroup.
        ConditionGroup URI

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :return: The ref of this RuleConditionGroup.
        :rtype: str
        """
        return self._ref

    @ref.setter
    def ref(self, ref):
        """
        Sets the ref of this RuleConditionGroup.
        ConditionGroup URI

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :param ref: The ref of this RuleConditionGroup.
        :type: str
        """
        self._ref = ref

    @property
    def type(self):
        """
        **[Required]** Gets the type of this RuleConditionGroup.
        A label that indicates whether this is Condition or ConditionGroup.

        **SCIM++ Properties:**
         - idcsDefaultValue: Condition
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "Condition", "ConditionGroup", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this RuleConditionGroup.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this RuleConditionGroup.
        A label that indicates whether this is Condition or ConditionGroup.

        **SCIM++ Properties:**
         - idcsDefaultValue: Condition
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param type: The type of this RuleConditionGroup.
        :type: str
        """
        allowed_values = ["Condition", "ConditionGroup"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def name(self):
        """
        Gets the name of this RuleConditionGroup.
        Condition or ConditionGroup name

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this RuleConditionGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this RuleConditionGroup.
        Condition or ConditionGroup name

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this RuleConditionGroup.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
