# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceTypeSchemaAttribute(object):
    """
    ResourceTypeSchemaAttribute Schema Definition
    """

    #: A constant which can be used with the idcs_prevented_operations property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "string"
    TYPE_STRING = "string"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "complex"
    TYPE_COMPLEX = "complex"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "boolean"
    TYPE_BOOLEAN = "boolean"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "decimal"
    TYPE_DECIMAL = "decimal"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "integer"
    TYPE_INTEGER = "integer"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "dateTime"
    TYPE_DATE_TIME = "dateTime"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "reference"
    TYPE_REFERENCE = "reference"

    #: A constant which can be used with the type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "binary"
    TYPE_BINARY = "binary"

    #: A constant which can be used with the mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "readOnly"
    MUTABILITY_READ_ONLY = "readOnly"

    #: A constant which can be used with the mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "readWrite"
    MUTABILITY_READ_WRITE = "readWrite"

    #: A constant which can be used with the mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "immutable"
    MUTABILITY_IMMUTABLE = "immutable"

    #: A constant which can be used with the mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "writeOnly"
    MUTABILITY_WRITE_ONLY = "writeOnly"

    #: A constant which can be used with the end_user_mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "readOnly"
    END_USER_MUTABILITY_READ_ONLY = "readOnly"

    #: A constant which can be used with the end_user_mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "readWrite"
    END_USER_MUTABILITY_READ_WRITE = "readWrite"

    #: A constant which can be used with the end_user_mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "immutable"
    END_USER_MUTABILITY_IMMUTABLE = "immutable"

    #: A constant which can be used with the end_user_mutability property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "hidden"
    END_USER_MUTABILITY_HIDDEN = "hidden"

    #: A constant which can be used with the end_user_mutability_allowed_values property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "readOnly"
    END_USER_MUTABILITY_ALLOWED_VALUES_READ_ONLY = "readOnly"

    #: A constant which can be used with the end_user_mutability_allowed_values property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "readWrite"
    END_USER_MUTABILITY_ALLOWED_VALUES_READ_WRITE = "readWrite"

    #: A constant which can be used with the end_user_mutability_allowed_values property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "immutable"
    END_USER_MUTABILITY_ALLOWED_VALUES_IMMUTABLE = "immutable"

    #: A constant which can be used with the end_user_mutability_allowed_values property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "hidden"
    END_USER_MUTABILITY_ALLOWED_VALUES_HIDDEN = "hidden"

    #: A constant which can be used with the returned property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "always"
    RETURNED_ALWAYS = "always"

    #: A constant which can be used with the returned property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "never"
    RETURNED_NEVER = "never"

    #: A constant which can be used with the returned property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "default"
    RETURNED_DEFAULT = "default"

    #: A constant which can be used with the returned property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "request"
    RETURNED_REQUEST = "request"

    #: A constant which can be used with the uniqueness property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "none"
    UNIQUENESS_NONE = "none"

    #: A constant which can be used with the uniqueness property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "server"
    UNIQUENESS_SERVER = "server"

    #: A constant which can be used with the uniqueness property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "global"
    UNIQUENESS_GLOBAL = "global"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "string"
    IDCS_ICF_ATTRIBUTE_TYPE_STRING = "string"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "long"
    IDCS_ICF_ATTRIBUTE_TYPE_LONG = "long"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "char"
    IDCS_ICF_ATTRIBUTE_TYPE_CHAR = "char"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "double"
    IDCS_ICF_ATTRIBUTE_TYPE_DOUBLE = "double"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "float"
    IDCS_ICF_ATTRIBUTE_TYPE_FLOAT = "float"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "integer"
    IDCS_ICF_ATTRIBUTE_TYPE_INTEGER = "integer"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "boolean"
    IDCS_ICF_ATTRIBUTE_TYPE_BOOLEAN = "boolean"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "bytes"
    IDCS_ICF_ATTRIBUTE_TYPE_BYTES = "bytes"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "bigdecimal"
    IDCS_ICF_ATTRIBUTE_TYPE_BIGDECIMAL = "bigdecimal"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "biginteger"
    IDCS_ICF_ATTRIBUTE_TYPE_BIGINTEGER = "biginteger"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "guardedbytes"
    IDCS_ICF_ATTRIBUTE_TYPE_GUARDEDBYTES = "guardedbytes"

    #: A constant which can be used with the idcs_icf_attribute_type property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "guardedstring"
    IDCS_ICF_ATTRIBUTE_TYPE_GUARDEDSTRING = "guardedstring"

    #: A constant which can be used with the idcs_sensitive property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "encrypt"
    IDCS_SENSITIVE_ENCRYPT = "encrypt"

    #: A constant which can be used with the idcs_sensitive property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "hash"
    IDCS_SENSITIVE_HASH = "hash"

    #: A constant which can be used with the idcs_sensitive property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "hash_sc"
    IDCS_SENSITIVE_HASH_SC = "hash_sc"

    #: A constant which can be used with the idcs_sensitive property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "checksum"
    IDCS_SENSITIVE_CHECKSUM = "checksum"

    #: A constant which can be used with the idcs_sensitive property of a ResourceTypeSchemaAttribute.
    #: This constant has a value of "none"
    IDCS_SENSITIVE_NONE = "none"

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceTypeSchemaAttribute object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ResourceTypeSchemaAttribute.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this ResourceTypeSchemaAttribute.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this ResourceTypeSchemaAttribute.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this ResourceTypeSchemaAttribute.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this ResourceTypeSchemaAttribute.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this ResourceTypeSchemaAttribute.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this ResourceTypeSchemaAttribute.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this ResourceTypeSchemaAttribute.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this ResourceTypeSchemaAttribute.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this ResourceTypeSchemaAttribute.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this ResourceTypeSchemaAttribute.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this ResourceTypeSchemaAttribute.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this ResourceTypeSchemaAttribute.
        :type tenancy_ocid: str

        :param name:
            The value to assign to the name property of this ResourceTypeSchemaAttribute.
        :type name: str

        :param idcs_display_name_message_id:
            The value to assign to the idcs_display_name_message_id property of this ResourceTypeSchemaAttribute.
        :type idcs_display_name_message_id: str

        :param resource_type:
            The value to assign to the resource_type property of this ResourceTypeSchemaAttribute.
        :type resource_type: str

        :param idcs_schema_urn:
            The value to assign to the idcs_schema_urn property of this ResourceTypeSchemaAttribute.
        :type idcs_schema_urn: str

        :param idcs_fully_qualified_name:
            The value to assign to the idcs_fully_qualified_name property of this ResourceTypeSchemaAttribute.
        :type idcs_fully_qualified_name: str

        :param idcs_custom_attribute:
            The value to assign to the idcs_custom_attribute property of this ResourceTypeSchemaAttribute.
        :type idcs_custom_attribute: bool

        :param type:
            The value to assign to the type property of this ResourceTypeSchemaAttribute.
            Allowed values for this property are: "string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param multi_valued:
            The value to assign to the multi_valued property of this ResourceTypeSchemaAttribute.
        :type multi_valued: bool

        :param description:
            The value to assign to the description property of this ResourceTypeSchemaAttribute.
        :type description: str

        :param required:
            The value to assign to the required property of this ResourceTypeSchemaAttribute.
        :type required: bool

        :param canonical_values:
            The value to assign to the canonical_values property of this ResourceTypeSchemaAttribute.
        :type canonical_values: list[str]

        :param case_exact:
            The value to assign to the case_exact property of this ResourceTypeSchemaAttribute.
        :type case_exact: bool

        :param mutability:
            The value to assign to the mutability property of this ResourceTypeSchemaAttribute.
            Allowed values for this property are: "readOnly", "readWrite", "immutable", "writeOnly", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mutability: str

        :param end_user_mutability:
            The value to assign to the end_user_mutability property of this ResourceTypeSchemaAttribute.
            Allowed values for this property are: "readOnly", "readWrite", "immutable", "hidden", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type end_user_mutability: str

        :param end_user_mutability_allowed_values:
            The value to assign to the end_user_mutability_allowed_values property of this ResourceTypeSchemaAttribute.
            Allowed values for items in this list are: "readOnly", "readWrite", "immutable", "hidden", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type end_user_mutability_allowed_values: list[str]

        :param returned:
            The value to assign to the returned property of this ResourceTypeSchemaAttribute.
            Allowed values for this property are: "always", "never", "default", "request", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type returned: str

        :param uniqueness:
            The value to assign to the uniqueness property of this ResourceTypeSchemaAttribute.
            Allowed values for this property are: "none", "server", "global", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type uniqueness: str

        :param idcs_csv_column_header_name:
            The value to assign to the idcs_csv_column_header_name property of this ResourceTypeSchemaAttribute.
        :type idcs_csv_column_header_name: str

        :param idcs_icf_bundle_attribute_name:
            The value to assign to the idcs_icf_bundle_attribute_name property of this ResourceTypeSchemaAttribute.
        :type idcs_icf_bundle_attribute_name: str

        :param idcs_icf_required:
            The value to assign to the idcs_icf_required property of this ResourceTypeSchemaAttribute.
        :type idcs_icf_required: bool

        :param idcs_icf_attribute_type:
            The value to assign to the idcs_icf_attribute_type property of this ResourceTypeSchemaAttribute.
            Allowed values for this property are: "string", "long", "char", "double", "float", "integer", "boolean", "bytes", "bigdecimal", "biginteger", "guardedbytes", "guardedstring", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_icf_attribute_type: str

        :param reference_types:
            The value to assign to the reference_types property of this ResourceTypeSchemaAttribute.
        :type reference_types: list[str]

        :param idcs_deprecated_since_version:
            The value to assign to the idcs_deprecated_since_version property of this ResourceTypeSchemaAttribute.
        :type idcs_deprecated_since_version: int

        :param idcs_added_since_version:
            The value to assign to the idcs_added_since_version property of this ResourceTypeSchemaAttribute.
        :type idcs_added_since_version: int

        :param idcs_deprecated_since_release_number:
            The value to assign to the idcs_deprecated_since_release_number property of this ResourceTypeSchemaAttribute.
        :type idcs_deprecated_since_release_number: str

        :param idcs_added_since_release_number:
            The value to assign to the idcs_added_since_release_number property of this ResourceTypeSchemaAttribute.
        :type idcs_added_since_release_number: str

        :param idcs_min_length:
            The value to assign to the idcs_min_length property of this ResourceTypeSchemaAttribute.
        :type idcs_min_length: int

        :param idcs_max_length:
            The value to assign to the idcs_max_length property of this ResourceTypeSchemaAttribute.
        :type idcs_max_length: int

        :param idcs_min_value:
            The value to assign to the idcs_min_value property of this ResourceTypeSchemaAttribute.
        :type idcs_min_value: int

        :param idcs_max_value:
            The value to assign to the idcs_max_value property of this ResourceTypeSchemaAttribute.
        :type idcs_max_value: int

        :param idcs_multi_language:
            The value to assign to the idcs_multi_language property of this ResourceTypeSchemaAttribute.
        :type idcs_multi_language: bool

        :param idcs_ref_resource_attributes:
            The value to assign to the idcs_ref_resource_attributes property of this ResourceTypeSchemaAttribute.
        :type idcs_ref_resource_attributes: list[str]

        :param idcs_indirect_ref_resource_attributes:
            The value to assign to the idcs_indirect_ref_resource_attributes property of this ResourceTypeSchemaAttribute.
        :type idcs_indirect_ref_resource_attributes: list[str]

        :param idcs_auto_increment_seq_name:
            The value to assign to the idcs_auto_increment_seq_name property of this ResourceTypeSchemaAttribute.
        :type idcs_auto_increment_seq_name: str

        :param idcs_value_persisted:
            The value to assign to the idcs_value_persisted property of this ResourceTypeSchemaAttribute.
        :type idcs_value_persisted: bool

        :param idcs_sensitive:
            The value to assign to the idcs_sensitive property of this ResourceTypeSchemaAttribute.
            Allowed values for this property are: "encrypt", "hash", "hash_sc", "checksum", "none", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_sensitive: str

        :param idcs_internal:
            The value to assign to the idcs_internal property of this ResourceTypeSchemaAttribute.
        :type idcs_internal: bool

        :param idcs_trim_string_value:
            The value to assign to the idcs_trim_string_value property of this ResourceTypeSchemaAttribute.
        :type idcs_trim_string_value: bool

        :param idcs_searchable:
            The value to assign to the idcs_searchable property of this ResourceTypeSchemaAttribute.
        :type idcs_searchable: bool

        :param idcs_generated:
            The value to assign to the idcs_generated property of this ResourceTypeSchemaAttribute.
        :type idcs_generated: bool

        :param idcs_auditable:
            The value to assign to the idcs_auditable property of this ResourceTypeSchemaAttribute.
        :type idcs_auditable: bool

        :param idcs_target_attribute_name:
            The value to assign to the idcs_target_attribute_name property of this ResourceTypeSchemaAttribute.
        :type idcs_target_attribute_name: str

        :param idcs_target_unique_constraint_name:
            The value to assign to the idcs_target_unique_constraint_name property of this ResourceTypeSchemaAttribute.
        :type idcs_target_unique_constraint_name: str

        :param idcs_target_norm_attribute_name:
            The value to assign to the idcs_target_norm_attribute_name property of this ResourceTypeSchemaAttribute.
        :type idcs_target_norm_attribute_name: str

        :param idcs_target_attribute_name_to_migrate_from:
            The value to assign to the idcs_target_attribute_name_to_migrate_from property of this ResourceTypeSchemaAttribute.
        :type idcs_target_attribute_name_to_migrate_from: str

        :param idcs_to_target_mapper:
            The value to assign to the idcs_to_target_mapper property of this ResourceTypeSchemaAttribute.
        :type idcs_to_target_mapper: str

        :param idcs_from_target_mapper:
            The value to assign to the idcs_from_target_mapper property of this ResourceTypeSchemaAttribute.
        :type idcs_from_target_mapper: str

        :param idcs_display_name:
            The value to assign to the idcs_display_name property of this ResourceTypeSchemaAttribute.
        :type idcs_display_name: str

        :param idcs_canonical_value_source_resource_type:
            The value to assign to the idcs_canonical_value_source_resource_type property of this ResourceTypeSchemaAttribute.
        :type idcs_canonical_value_source_resource_type: str

        :param idcs_canonical_value_source_filter:
            The value to assign to the idcs_canonical_value_source_filter property of this ResourceTypeSchemaAttribute.
        :type idcs_canonical_value_source_filter: str

        :param idcs_validate_reference:
            The value to assign to the idcs_validate_reference property of this ResourceTypeSchemaAttribute.
        :type idcs_validate_reference: bool

        :param idcs_composite_key:
            The value to assign to the idcs_composite_key property of this ResourceTypeSchemaAttribute.
        :type idcs_composite_key: list[str]

        :param idcs_fetch_complex_attribute_values:
            The value to assign to the idcs_fetch_complex_attribute_values property of this ResourceTypeSchemaAttribute.
        :type idcs_fetch_complex_attribute_values: bool

        :param idcs_scim_compliant:
            The value to assign to the idcs_scim_compliant property of this ResourceTypeSchemaAttribute.
        :type idcs_scim_compliant: bool

        :param idcs_attribute_mappable:
            The value to assign to the idcs_attribute_mappable property of this ResourceTypeSchemaAttribute.
        :type idcs_attribute_mappable: bool

        :param idcs_ref_resource_attribute:
            The value to assign to the idcs_ref_resource_attribute property of this ResourceTypeSchemaAttribute.
        :type idcs_ref_resource_attribute: str

        :param idcs_attribute_cacheable:
            The value to assign to the idcs_attribute_cacheable property of this ResourceTypeSchemaAttribute.
        :type idcs_attribute_cacheable: bool

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'name': 'str',
            'idcs_display_name_message_id': 'str',
            'resource_type': 'str',
            'idcs_schema_urn': 'str',
            'idcs_fully_qualified_name': 'str',
            'idcs_custom_attribute': 'bool',
            'type': 'str',
            'multi_valued': 'bool',
            'description': 'str',
            'required': 'bool',
            'canonical_values': 'list[str]',
            'case_exact': 'bool',
            'mutability': 'str',
            'end_user_mutability': 'str',
            'end_user_mutability_allowed_values': 'list[str]',
            'returned': 'str',
            'uniqueness': 'str',
            'idcs_csv_column_header_name': 'str',
            'idcs_icf_bundle_attribute_name': 'str',
            'idcs_icf_required': 'bool',
            'idcs_icf_attribute_type': 'str',
            'reference_types': 'list[str]',
            'idcs_deprecated_since_version': 'int',
            'idcs_added_since_version': 'int',
            'idcs_deprecated_since_release_number': 'str',
            'idcs_added_since_release_number': 'str',
            'idcs_min_length': 'int',
            'idcs_max_length': 'int',
            'idcs_min_value': 'int',
            'idcs_max_value': 'int',
            'idcs_multi_language': 'bool',
            'idcs_ref_resource_attributes': 'list[str]',
            'idcs_indirect_ref_resource_attributes': 'list[str]',
            'idcs_auto_increment_seq_name': 'str',
            'idcs_value_persisted': 'bool',
            'idcs_sensitive': 'str',
            'idcs_internal': 'bool',
            'idcs_trim_string_value': 'bool',
            'idcs_searchable': 'bool',
            'idcs_generated': 'bool',
            'idcs_auditable': 'bool',
            'idcs_target_attribute_name': 'str',
            'idcs_target_unique_constraint_name': 'str',
            'idcs_target_norm_attribute_name': 'str',
            'idcs_target_attribute_name_to_migrate_from': 'str',
            'idcs_to_target_mapper': 'str',
            'idcs_from_target_mapper': 'str',
            'idcs_display_name': 'str',
            'idcs_canonical_value_source_resource_type': 'str',
            'idcs_canonical_value_source_filter': 'str',
            'idcs_validate_reference': 'bool',
            'idcs_composite_key': 'list[str]',
            'idcs_fetch_complex_attribute_values': 'bool',
            'idcs_scim_compliant': 'bool',
            'idcs_attribute_mappable': 'bool',
            'idcs_ref_resource_attribute': 'str',
            'idcs_attribute_cacheable': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'name': 'name',
            'idcs_display_name_message_id': 'idcsDisplayNameMessageId',
            'resource_type': 'resourceType',
            'idcs_schema_urn': 'idcsSchemaUrn',
            'idcs_fully_qualified_name': 'idcsFullyQualifiedName',
            'idcs_custom_attribute': 'idcsCustomAttribute',
            'type': 'type',
            'multi_valued': 'multiValued',
            'description': 'description',
            'required': 'required',
            'canonical_values': 'canonicalValues',
            'case_exact': 'caseExact',
            'mutability': 'mutability',
            'end_user_mutability': 'endUserMutability',
            'end_user_mutability_allowed_values': 'endUserMutabilityAllowedValues',
            'returned': 'returned',
            'uniqueness': 'uniqueness',
            'idcs_csv_column_header_name': 'idcsCsvColumnHeaderName',
            'idcs_icf_bundle_attribute_name': 'idcsICFBundleAttributeName',
            'idcs_icf_required': 'idcsICFRequired',
            'idcs_icf_attribute_type': 'idcsICFAttributeType',
            'reference_types': 'referenceTypes',
            'idcs_deprecated_since_version': 'idcsDeprecatedSinceVersion',
            'idcs_added_since_version': 'idcsAddedSinceVersion',
            'idcs_deprecated_since_release_number': 'idcsDeprecatedSinceReleaseNumber',
            'idcs_added_since_release_number': 'idcsAddedSinceReleaseNumber',
            'idcs_min_length': 'idcsMinLength',
            'idcs_max_length': 'idcsMaxLength',
            'idcs_min_value': 'idcsMinValue',
            'idcs_max_value': 'idcsMaxValue',
            'idcs_multi_language': 'idcsMultiLanguage',
            'idcs_ref_resource_attributes': 'idcsRefResourceAttributes',
            'idcs_indirect_ref_resource_attributes': 'idcsIndirectRefResourceAttributes',
            'idcs_auto_increment_seq_name': 'idcsAutoIncrementSeqName',
            'idcs_value_persisted': 'idcsValuePersisted',
            'idcs_sensitive': 'idcsSensitive',
            'idcs_internal': 'idcsInternal',
            'idcs_trim_string_value': 'idcsTrimStringValue',
            'idcs_searchable': 'idcsSearchable',
            'idcs_generated': 'idcsGenerated',
            'idcs_auditable': 'idcsAuditable',
            'idcs_target_attribute_name': 'idcsTargetAttributeName',
            'idcs_target_unique_constraint_name': 'idcsTargetUniqueConstraintName',
            'idcs_target_norm_attribute_name': 'idcsTargetNormAttributeName',
            'idcs_target_attribute_name_to_migrate_from': 'idcsTargetAttributeNameToMigrateFrom',
            'idcs_to_target_mapper': 'idcsToTargetMapper',
            'idcs_from_target_mapper': 'idcsFromTargetMapper',
            'idcs_display_name': 'idcsDisplayName',
            'idcs_canonical_value_source_resource_type': 'idcsCanonicalValueSourceResourceType',
            'idcs_canonical_value_source_filter': 'idcsCanonicalValueSourceFilter',
            'idcs_validate_reference': 'idcsValidateReference',
            'idcs_composite_key': 'idcsCompositeKey',
            'idcs_fetch_complex_attribute_values': 'idcsFetchComplexAttributeValues',
            'idcs_scim_compliant': 'idcsScimCompliant',
            'idcs_attribute_mappable': 'idcsAttributeMappable',
            'idcs_ref_resource_attribute': 'idcsRefResourceAttribute',
            'idcs_attribute_cacheable': 'idcsAttributeCacheable'
        }

        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._name = None
        self._idcs_display_name_message_id = None
        self._resource_type = None
        self._idcs_schema_urn = None
        self._idcs_fully_qualified_name = None
        self._idcs_custom_attribute = None
        self._type = None
        self._multi_valued = None
        self._description = None
        self._required = None
        self._canonical_values = None
        self._case_exact = None
        self._mutability = None
        self._end_user_mutability = None
        self._end_user_mutability_allowed_values = None
        self._returned = None
        self._uniqueness = None
        self._idcs_csv_column_header_name = None
        self._idcs_icf_bundle_attribute_name = None
        self._idcs_icf_required = None
        self._idcs_icf_attribute_type = None
        self._reference_types = None
        self._idcs_deprecated_since_version = None
        self._idcs_added_since_version = None
        self._idcs_deprecated_since_release_number = None
        self._idcs_added_since_release_number = None
        self._idcs_min_length = None
        self._idcs_max_length = None
        self._idcs_min_value = None
        self._idcs_max_value = None
        self._idcs_multi_language = None
        self._idcs_ref_resource_attributes = None
        self._idcs_indirect_ref_resource_attributes = None
        self._idcs_auto_increment_seq_name = None
        self._idcs_value_persisted = None
        self._idcs_sensitive = None
        self._idcs_internal = None
        self._idcs_trim_string_value = None
        self._idcs_searchable = None
        self._idcs_generated = None
        self._idcs_auditable = None
        self._idcs_target_attribute_name = None
        self._idcs_target_unique_constraint_name = None
        self._idcs_target_norm_attribute_name = None
        self._idcs_target_attribute_name_to_migrate_from = None
        self._idcs_to_target_mapper = None
        self._idcs_from_target_mapper = None
        self._idcs_display_name = None
        self._idcs_canonical_value_source_resource_type = None
        self._idcs_canonical_value_source_filter = None
        self._idcs_validate_reference = None
        self._idcs_composite_key = None
        self._idcs_fetch_complex_attribute_values = None
        self._idcs_scim_compliant = None
        self._idcs_attribute_mappable = None
        self._idcs_ref_resource_attribute = None
        self._idcs_attribute_cacheable = None

    @property
    def id(self):
        """
        Gets the id of this ResourceTypeSchemaAttribute.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ResourceTypeSchemaAttribute.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this ResourceTypeSchemaAttribute.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this ResourceTypeSchemaAttribute.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this ResourceTypeSchemaAttribute.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this ResourceTypeSchemaAttribute.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this ResourceTypeSchemaAttribute.

        :return: The meta of this ResourceTypeSchemaAttribute.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this ResourceTypeSchemaAttribute.

        :param meta: The meta of this ResourceTypeSchemaAttribute.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this ResourceTypeSchemaAttribute.

        :return: The idcs_created_by of this ResourceTypeSchemaAttribute.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this ResourceTypeSchemaAttribute.

        :param idcs_created_by: The idcs_created_by of this ResourceTypeSchemaAttribute.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this ResourceTypeSchemaAttribute.

        :return: The idcs_last_modified_by of this ResourceTypeSchemaAttribute.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this ResourceTypeSchemaAttribute.

        :param idcs_last_modified_by: The idcs_last_modified_by of this ResourceTypeSchemaAttribute.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this ResourceTypeSchemaAttribute.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this ResourceTypeSchemaAttribute.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this ResourceTypeSchemaAttribute.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this ResourceTypeSchemaAttribute.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ResourceTypeSchemaAttribute.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this ResourceTypeSchemaAttribute.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this ResourceTypeSchemaAttribute.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this ResourceTypeSchemaAttribute.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this ResourceTypeSchemaAttribute.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this ResourceTypeSchemaAttribute.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this ResourceTypeSchemaAttribute.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this ResourceTypeSchemaAttribute.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this ResourceTypeSchemaAttribute.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this ResourceTypeSchemaAttribute.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this ResourceTypeSchemaAttribute.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this ResourceTypeSchemaAttribute.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def name(self):
        """
        Gets the name of this ResourceTypeSchemaAttribute.
        Attribute's name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :return: The name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ResourceTypeSchemaAttribute.
        Attribute's name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :param name: The name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._name = name

    @property
    def idcs_display_name_message_id(self):
        """
        Gets the idcs_display_name_message_id of this ResourceTypeSchemaAttribute.
        Localized schema attribute display name for use by UI client  for displaying attribute labels

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :return: The idcs_display_name_message_id of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_display_name_message_id

    @idcs_display_name_message_id.setter
    def idcs_display_name_message_id(self, idcs_display_name_message_id):
        """
        Sets the idcs_display_name_message_id of this ResourceTypeSchemaAttribute.
        Localized schema attribute display name for use by UI client  for displaying attribute labels

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :param idcs_display_name_message_id: The idcs_display_name_message_id of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_display_name_message_id = idcs_display_name_message_id

    @property
    def resource_type(self):
        """
        Gets the resource_type of this ResourceTypeSchemaAttribute.
        ResourceType this attribute belongs to.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - idcsSearchable: true
         - uniqueness: none


        :return: The resource_type of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this ResourceTypeSchemaAttribute.
        ResourceType this attribute belongs to.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - idcsSearchable: true
         - uniqueness: none


        :param resource_type: The resource_type of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def idcs_schema_urn(self):
        """
        Gets the idcs_schema_urn of this ResourceTypeSchemaAttribute.
        Schema URN string that this attribute belongs to

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - idcsSearchable: true
         - uniqueness: none


        :return: The idcs_schema_urn of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_schema_urn

    @idcs_schema_urn.setter
    def idcs_schema_urn(self, idcs_schema_urn):
        """
        Sets the idcs_schema_urn of this ResourceTypeSchemaAttribute.
        Schema URN string that this attribute belongs to

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - idcsSearchable: true
         - uniqueness: none


        :param idcs_schema_urn: The idcs_schema_urn of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_schema_urn = idcs_schema_urn

    @property
    def idcs_fully_qualified_name(self):
        """
        Gets the idcs_fully_qualified_name of this ResourceTypeSchemaAttribute.
        Fully qualified name of this attribute

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - idcsSearchable: true
         - uniqueness: none


        :return: The idcs_fully_qualified_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_fully_qualified_name

    @idcs_fully_qualified_name.setter
    def idcs_fully_qualified_name(self, idcs_fully_qualified_name):
        """
        Sets the idcs_fully_qualified_name of this ResourceTypeSchemaAttribute.
        Fully qualified name of this attribute

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - idcsSearchable: true
         - uniqueness: none


        :param idcs_fully_qualified_name: The idcs_fully_qualified_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_fully_qualified_name = idcs_fully_qualified_name

    @property
    def idcs_custom_attribute(self):
        """
        Gets the idcs_custom_attribute of this ResourceTypeSchemaAttribute.
        custom attribute flag.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - idcsSearchable: true
         - uniqueness: none


        :return: The idcs_custom_attribute of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_custom_attribute

    @idcs_custom_attribute.setter
    def idcs_custom_attribute(self, idcs_custom_attribute):
        """
        Sets the idcs_custom_attribute of this ResourceTypeSchemaAttribute.
        custom attribute flag.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - idcsSearchable: true
         - uniqueness: none


        :param idcs_custom_attribute: The idcs_custom_attribute of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_custom_attribute = idcs_custom_attribute

    @property
    def type(self):
        """
        Gets the type of this ResourceTypeSchemaAttribute.
        The attribute's data type--for example, String

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ResourceTypeSchemaAttribute.
        The attribute's data type--for example, String

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param type: The type of this ResourceTypeSchemaAttribute.
        :type: str
        """
        allowed_values = ["string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def multi_valued(self):
        """
        Gets the multi_valued of this ResourceTypeSchemaAttribute.
        Indicates the attribute's plurality

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The multi_valued of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._multi_valued

    @multi_valued.setter
    def multi_valued(self, multi_valued):
        """
        Sets the multi_valued of this ResourceTypeSchemaAttribute.
        Indicates the attribute's plurality

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param multi_valued: The multi_valued of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._multi_valued = multi_valued

    @property
    def description(self):
        """
        Gets the description of this ResourceTypeSchemaAttribute.
        The attribute's human-readable description

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :return: The description of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ResourceTypeSchemaAttribute.
        The attribute's human-readable description

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :param description: The description of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._description = description

    @property
    def required(self):
        """
        Gets the required of this ResourceTypeSchemaAttribute.
        Specifies if the attribute is required

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The required of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this ResourceTypeSchemaAttribute.
        Specifies if the attribute is required

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param required: The required of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._required = required

    @property
    def canonical_values(self):
        """
        Gets the canonical_values of this ResourceTypeSchemaAttribute.
        A collection of canonical values. Applicable Service Providers MUST specify the canonical types specified in the core schema specification--for example, \\\"work\\\", \\\"home\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The canonical_values of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._canonical_values

    @canonical_values.setter
    def canonical_values(self, canonical_values):
        """
        Sets the canonical_values of this ResourceTypeSchemaAttribute.
        A collection of canonical values. Applicable Service Providers MUST specify the canonical types specified in the core schema specification--for example, \\\"work\\\", \\\"home\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param canonical_values: The canonical_values of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        self._canonical_values = canonical_values

    @property
    def case_exact(self):
        """
        Gets the case_exact of this ResourceTypeSchemaAttribute.
        Specifies if the String attribute is case-sensitive

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The case_exact of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._case_exact

    @case_exact.setter
    def case_exact(self, case_exact):
        """
        Sets the case_exact of this ResourceTypeSchemaAttribute.
        Specifies if the String attribute is case-sensitive

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param case_exact: The case_exact of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._case_exact = case_exact

    @property
    def mutability(self):
        """
        Gets the mutability of this ResourceTypeSchemaAttribute.
        Specifies if the attribute is mutable

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none

        Allowed values for this property are: "readOnly", "readWrite", "immutable", "writeOnly", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The mutability of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._mutability

    @mutability.setter
    def mutability(self, mutability):
        """
        Sets the mutability of this ResourceTypeSchemaAttribute.
        Specifies if the attribute is mutable

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :param mutability: The mutability of this ResourceTypeSchemaAttribute.
        :type: str
        """
        allowed_values = ["readOnly", "readWrite", "immutable", "writeOnly"]
        if not value_allowed_none_or_none_sentinel(mutability, allowed_values):
            mutability = 'UNKNOWN_ENUM_VALUE'
        self._mutability = mutability

    @property
    def end_user_mutability(self):
        """
        Gets the end_user_mutability of this ResourceTypeSchemaAttribute.
        Specifies User mutability for this attribute

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "readOnly", "readWrite", "immutable", "hidden", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The end_user_mutability of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._end_user_mutability

    @end_user_mutability.setter
    def end_user_mutability(self, end_user_mutability):
        """
        Sets the end_user_mutability of this ResourceTypeSchemaAttribute.
        Specifies User mutability for this attribute

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param end_user_mutability: The end_user_mutability of this ResourceTypeSchemaAttribute.
        :type: str
        """
        allowed_values = ["readOnly", "readWrite", "immutable", "hidden"]
        if not value_allowed_none_or_none_sentinel(end_user_mutability, allowed_values):
            end_user_mutability = 'UNKNOWN_ENUM_VALUE'
        self._end_user_mutability = end_user_mutability

    @property
    def end_user_mutability_allowed_values(self):
        """
        Gets the end_user_mutability_allowed_values of this ResourceTypeSchemaAttribute.
        Specifies the list of User mutabilities allowed

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "readOnly", "readWrite", "immutable", "hidden", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The end_user_mutability_allowed_values of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._end_user_mutability_allowed_values

    @end_user_mutability_allowed_values.setter
    def end_user_mutability_allowed_values(self, end_user_mutability_allowed_values):
        """
        Sets the end_user_mutability_allowed_values of this ResourceTypeSchemaAttribute.
        Specifies the list of User mutabilities allowed

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param end_user_mutability_allowed_values: The end_user_mutability_allowed_values of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        allowed_values = ["readOnly", "readWrite", "immutable", "hidden"]
        if end_user_mutability_allowed_values:
            end_user_mutability_allowed_values[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in end_user_mutability_allowed_values]
        self._end_user_mutability_allowed_values = end_user_mutability_allowed_values

    @property
    def returned(self):
        """
        Gets the returned of this ResourceTypeSchemaAttribute.
        A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none

        Allowed values for this property are: "always", "never", "default", "request", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The returned of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._returned

    @returned.setter
    def returned(self, returned):
        """
        Sets the returned of this ResourceTypeSchemaAttribute.
        A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :param returned: The returned of this ResourceTypeSchemaAttribute.
        :type: str
        """
        allowed_values = ["always", "never", "default", "request"]
        if not value_allowed_none_or_none_sentinel(returned, allowed_values):
            returned = 'UNKNOWN_ENUM_VALUE'
        self._returned = returned

    @property
    def uniqueness(self):
        """
        Gets the uniqueness of this ResourceTypeSchemaAttribute.
        A single keyword value that specifies how the Service Provider enforces uniqueness of attribute values. A server MAY reject an invalid value based on uniqueness by returning an HTTP response code of 400 (Bad Request). A client MAY enforce uniqueness on the client side to a greater degree than the Service Provider enforces. For example, a client could make a value unique while the server has the uniqueness of \\\"none\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none

        Allowed values for this property are: "none", "server", "global", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The uniqueness of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._uniqueness

    @uniqueness.setter
    def uniqueness(self, uniqueness):
        """
        Sets the uniqueness of this ResourceTypeSchemaAttribute.
        A single keyword value that specifies how the Service Provider enforces uniqueness of attribute values. A server MAY reject an invalid value based on uniqueness by returning an HTTP response code of 400 (Bad Request). A client MAY enforce uniqueness on the client side to a greater degree than the Service Provider enforces. For example, a client could make a value unique while the server has the uniqueness of \\\"none\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :param uniqueness: The uniqueness of this ResourceTypeSchemaAttribute.
        :type: str
        """
        allowed_values = ["none", "server", "global"]
        if not value_allowed_none_or_none_sentinel(uniqueness, allowed_values):
            uniqueness = 'UNKNOWN_ENUM_VALUE'
        self._uniqueness = uniqueness

    @property
    def idcs_csv_column_header_name(self):
        """
        Gets the idcs_csv_column_header_name of this ResourceTypeSchemaAttribute.
        The attribute defining the CSV column header name for import/export

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_csv_column_header_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_csv_column_header_name

    @idcs_csv_column_header_name.setter
    def idcs_csv_column_header_name(self, idcs_csv_column_header_name):
        """
        Sets the idcs_csv_column_header_name of this ResourceTypeSchemaAttribute.
        The attribute defining the CSV column header name for import/export

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_csv_column_header_name: The idcs_csv_column_header_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_csv_column_header_name = idcs_csv_column_header_name

    @property
    def idcs_icf_bundle_attribute_name(self):
        """
        Gets the idcs_icf_bundle_attribute_name of this ResourceTypeSchemaAttribute.
        Maps to ICF target attribute name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_icf_bundle_attribute_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_icf_bundle_attribute_name

    @idcs_icf_bundle_attribute_name.setter
    def idcs_icf_bundle_attribute_name(self, idcs_icf_bundle_attribute_name):
        """
        Sets the idcs_icf_bundle_attribute_name of this ResourceTypeSchemaAttribute.
        Maps to ICF target attribute name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_icf_bundle_attribute_name: The idcs_icf_bundle_attribute_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_icf_bundle_attribute_name = idcs_icf_bundle_attribute_name

    @property
    def idcs_icf_required(self):
        """
        Gets the idcs_icf_required of this ResourceTypeSchemaAttribute.
        Metadata to identify the ICF required attribute

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_icf_required of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_icf_required

    @idcs_icf_required.setter
    def idcs_icf_required(self, idcs_icf_required):
        """
        Sets the idcs_icf_required of this ResourceTypeSchemaAttribute.
        Metadata to identify the ICF required attribute

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_icf_required: The idcs_icf_required of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_icf_required = idcs_icf_required

    @property
    def idcs_icf_attribute_type(self):
        """
        Gets the idcs_icf_attribute_type of this ResourceTypeSchemaAttribute.
        Maps to ICF data type

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "string", "long", "char", "double", "float", "integer", "boolean", "bytes", "bigdecimal", "biginteger", "guardedbytes", "guardedstring", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_icf_attribute_type of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_icf_attribute_type

    @idcs_icf_attribute_type.setter
    def idcs_icf_attribute_type(self, idcs_icf_attribute_type):
        """
        Sets the idcs_icf_attribute_type of this ResourceTypeSchemaAttribute.
        Maps to ICF data type

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_icf_attribute_type: The idcs_icf_attribute_type of this ResourceTypeSchemaAttribute.
        :type: str
        """
        allowed_values = ["string", "long", "char", "double", "float", "integer", "boolean", "bytes", "bigdecimal", "biginteger", "guardedbytes", "guardedstring"]
        if not value_allowed_none_or_none_sentinel(idcs_icf_attribute_type, allowed_values):
            idcs_icf_attribute_type = 'UNKNOWN_ENUM_VALUE'
        self._idcs_icf_attribute_type = idcs_icf_attribute_type

    @property
    def reference_types(self):
        """
        Gets the reference_types of this ResourceTypeSchemaAttribute.
        The names of the Resource types that may be referenced--for example, User. This is only applicable for attributes that are of the \\\"reference\\\" data type.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The reference_types of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._reference_types

    @reference_types.setter
    def reference_types(self, reference_types):
        """
        Sets the reference_types of this ResourceTypeSchemaAttribute.
        The names of the Resource types that may be referenced--for example, User. This is only applicable for attributes that are of the \\\"reference\\\" data type.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param reference_types: The reference_types of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        self._reference_types = reference_types

    @property
    def idcs_deprecated_since_version(self):
        """
        Gets the idcs_deprecated_since_version of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been deprecated since version

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :return: The idcs_deprecated_since_version of this ResourceTypeSchemaAttribute.
        :rtype: int
        """
        return self._idcs_deprecated_since_version

    @idcs_deprecated_since_version.setter
    def idcs_deprecated_since_version(self, idcs_deprecated_since_version):
        """
        Sets the idcs_deprecated_since_version of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been deprecated since version

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :param idcs_deprecated_since_version: The idcs_deprecated_since_version of this ResourceTypeSchemaAttribute.
        :type: int
        """
        self._idcs_deprecated_since_version = idcs_deprecated_since_version

    @property
    def idcs_added_since_version(self):
        """
        Gets the idcs_added_since_version of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been added since version

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :return: The idcs_added_since_version of this ResourceTypeSchemaAttribute.
        :rtype: int
        """
        return self._idcs_added_since_version

    @idcs_added_since_version.setter
    def idcs_added_since_version(self, idcs_added_since_version):
        """
        Sets the idcs_added_since_version of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been added since version

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :param idcs_added_since_version: The idcs_added_since_version of this ResourceTypeSchemaAttribute.
        :type: int
        """
        self._idcs_added_since_version = idcs_added_since_version

    @property
    def idcs_deprecated_since_release_number(self):
        """
        Gets the idcs_deprecated_since_release_number of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been deprecated since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string


        :return: The idcs_deprecated_since_release_number of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_deprecated_since_release_number

    @idcs_deprecated_since_release_number.setter
    def idcs_deprecated_since_release_number(self, idcs_deprecated_since_release_number):
        """
        Sets the idcs_deprecated_since_release_number of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been deprecated since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string


        :param idcs_deprecated_since_release_number: The idcs_deprecated_since_release_number of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_deprecated_since_release_number = idcs_deprecated_since_release_number

    @property
    def idcs_added_since_release_number(self):
        """
        Gets the idcs_added_since_release_number of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been added since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string


        :return: The idcs_added_since_release_number of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_added_since_release_number

    @idcs_added_since_release_number.setter
    def idcs_added_since_release_number(self, idcs_added_since_release_number):
        """
        Sets the idcs_added_since_release_number of this ResourceTypeSchemaAttribute.
        Indicates that the schema has been added since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string


        :param idcs_added_since_release_number: The idcs_added_since_release_number of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_added_since_release_number = idcs_added_since_release_number

    @property
    def idcs_min_length(self):
        """
        Gets the idcs_min_length of this ResourceTypeSchemaAttribute.
        Specifies the minimum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_min_length of this ResourceTypeSchemaAttribute.
        :rtype: int
        """
        return self._idcs_min_length

    @idcs_min_length.setter
    def idcs_min_length(self, idcs_min_length):
        """
        Sets the idcs_min_length of this ResourceTypeSchemaAttribute.
        Specifies the minimum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: integer


        :param idcs_min_length: The idcs_min_length of this ResourceTypeSchemaAttribute.
        :type: int
        """
        self._idcs_min_length = idcs_min_length

    @property
    def idcs_max_length(self):
        """
        Gets the idcs_max_length of this ResourceTypeSchemaAttribute.
        Specifies the maximum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :return: The idcs_max_length of this ResourceTypeSchemaAttribute.
        :rtype: int
        """
        return self._idcs_max_length

    @idcs_max_length.setter
    def idcs_max_length(self, idcs_max_length):
        """
        Sets the idcs_max_length of this ResourceTypeSchemaAttribute.
        Specifies the maximum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :param idcs_max_length: The idcs_max_length of this ResourceTypeSchemaAttribute.
        :type: int
        """
        self._idcs_max_length = idcs_max_length

    @property
    def idcs_min_value(self):
        """
        Gets the idcs_min_value of this ResourceTypeSchemaAttribute.
        Specifies the minimum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :return: The idcs_min_value of this ResourceTypeSchemaAttribute.
        :rtype: int
        """
        return self._idcs_min_value

    @idcs_min_value.setter
    def idcs_min_value(self, idcs_min_value):
        """
        Sets the idcs_min_value of this ResourceTypeSchemaAttribute.
        Specifies the minimum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: integer


        :param idcs_min_value: The idcs_min_value of this ResourceTypeSchemaAttribute.
        :type: int
        """
        self._idcs_min_value = idcs_min_value

    @property
    def idcs_max_value(self):
        """
        Gets the idcs_max_value of this ResourceTypeSchemaAttribute.
        Specifies the maximum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_max_value of this ResourceTypeSchemaAttribute.
        :rtype: int
        """
        return self._idcs_max_value

    @idcs_max_value.setter
    def idcs_max_value(self, idcs_max_value):
        """
        Sets the idcs_max_value of this ResourceTypeSchemaAttribute.
        Specifies the maximum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: integer


        :param idcs_max_value: The idcs_max_value of this ResourceTypeSchemaAttribute.
        :type: int
        """
        self._idcs_max_value = idcs_max_value

    @property
    def idcs_multi_language(self):
        """
        Gets the idcs_multi_language of this ResourceTypeSchemaAttribute.
        If true, specifies that the attribute can have multiple language values set for the attribute on which this is set.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_multi_language of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_multi_language

    @idcs_multi_language.setter
    def idcs_multi_language(self, idcs_multi_language):
        """
        Sets the idcs_multi_language of this ResourceTypeSchemaAttribute.
        If true, specifies that the attribute can have multiple language values set for the attribute on which this is set.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_multi_language: The idcs_multi_language of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_multi_language = idcs_multi_language

    @property
    def idcs_ref_resource_attributes(self):
        """
        Gets the idcs_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        Specifies the directly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string


        :return: The idcs_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._idcs_ref_resource_attributes

    @idcs_ref_resource_attributes.setter
    def idcs_ref_resource_attributes(self, idcs_ref_resource_attributes):
        """
        Sets the idcs_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        Specifies the directly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string


        :param idcs_ref_resource_attributes: The idcs_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        self._idcs_ref_resource_attributes = idcs_ref_resource_attributes

    @property
    def idcs_indirect_ref_resource_attributes(self):
        """
        Gets the idcs_indirect_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        Specifies the indirectly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string


        :return: The idcs_indirect_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._idcs_indirect_ref_resource_attributes

    @idcs_indirect_ref_resource_attributes.setter
    def idcs_indirect_ref_resource_attributes(self, idcs_indirect_ref_resource_attributes):
        """
        Sets the idcs_indirect_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        Specifies the indirectly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string


        :param idcs_indirect_ref_resource_attributes: The idcs_indirect_ref_resource_attributes of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        self._idcs_indirect_ref_resource_attributes = idcs_indirect_ref_resource_attributes

    @property
    def idcs_auto_increment_seq_name(self):
        """
        Gets the idcs_auto_increment_seq_name of this ResourceTypeSchemaAttribute.
        Sequence tracking ID name for the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string


        :return: The idcs_auto_increment_seq_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_auto_increment_seq_name

    @idcs_auto_increment_seq_name.setter
    def idcs_auto_increment_seq_name(self, idcs_auto_increment_seq_name):
        """
        Sets the idcs_auto_increment_seq_name of this ResourceTypeSchemaAttribute.
        Sequence tracking ID name for the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string


        :param idcs_auto_increment_seq_name: The idcs_auto_increment_seq_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_auto_increment_seq_name = idcs_auto_increment_seq_name

    @property
    def idcs_value_persisted(self):
        """
        Gets the idcs_value_persisted of this ResourceTypeSchemaAttribute.
        Specifies whether the value of the Resource attribute is persisted

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The idcs_value_persisted of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_value_persisted

    @idcs_value_persisted.setter
    def idcs_value_persisted(self, idcs_value_persisted):
        """
        Sets the idcs_value_persisted of this ResourceTypeSchemaAttribute.
        Specifies whether the value of the Resource attribute is persisted

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param idcs_value_persisted: The idcs_value_persisted of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_value_persisted = idcs_value_persisted

    @property
    def idcs_sensitive(self):
        """
        Gets the idcs_sensitive of this ResourceTypeSchemaAttribute.
        Flag to specify if the attribute should be encrypted or hashed

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "encrypt", "hash", "hash_sc", "checksum", "none", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_sensitive of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_sensitive

    @idcs_sensitive.setter
    def idcs_sensitive(self, idcs_sensitive):
        """
        Sets the idcs_sensitive of this ResourceTypeSchemaAttribute.
        Flag to specify if the attribute should be encrypted or hashed

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_sensitive: The idcs_sensitive of this ResourceTypeSchemaAttribute.
        :type: str
        """
        allowed_values = ["encrypt", "hash", "hash_sc", "checksum", "none"]
        if not value_allowed_none_or_none_sentinel(idcs_sensitive, allowed_values):
            idcs_sensitive = 'UNKNOWN_ENUM_VALUE'
        self._idcs_sensitive = idcs_sensitive

    @property
    def idcs_internal(self):
        """
        Gets the idcs_internal of this ResourceTypeSchemaAttribute.
        Specifies whether the schema attribute is for internal use only. Internal attributes are not exposed via REST. This attribute overrides mutability for create/update if the request is internal and the attribute internalflag is set to True. This attribute overrides the return attribute while building SCIM response attributes when both the request is internal and the schema attribute is internal.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The idcs_internal of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_internal

    @idcs_internal.setter
    def idcs_internal(self, idcs_internal):
        """
        Sets the idcs_internal of this ResourceTypeSchemaAttribute.
        Specifies whether the schema attribute is for internal use only. Internal attributes are not exposed via REST. This attribute overrides mutability for create/update if the request is internal and the attribute internalflag is set to True. This attribute overrides the return attribute while building SCIM response attributes when both the request is internal and the schema attribute is internal.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param idcs_internal: The idcs_internal of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_internal = idcs_internal

    @property
    def idcs_trim_string_value(self):
        """
        Gets the idcs_trim_string_value of this ResourceTypeSchemaAttribute.
        Trims any leading and trailing blanks from String values. Default is True.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The idcs_trim_string_value of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_trim_string_value

    @idcs_trim_string_value.setter
    def idcs_trim_string_value(self, idcs_trim_string_value):
        """
        Sets the idcs_trim_string_value of this ResourceTypeSchemaAttribute.
        Trims any leading and trailing blanks from String values. Default is True.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param idcs_trim_string_value: The idcs_trim_string_value of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_trim_string_value = idcs_trim_string_value

    @property
    def idcs_searchable(self):
        """
        Gets the idcs_searchable of this ResourceTypeSchemaAttribute.
        Specifies whether this attribute can be included in a search filter

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The idcs_searchable of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_searchable

    @idcs_searchable.setter
    def idcs_searchable(self, idcs_searchable):
        """
        Sets the idcs_searchable of this ResourceTypeSchemaAttribute.
        Specifies whether this attribute can be included in a search filter

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param idcs_searchable: The idcs_searchable of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_searchable = idcs_searchable

    @property
    def idcs_generated(self):
        """
        Gets the idcs_generated of this ResourceTypeSchemaAttribute.
        Specifies whether this attribute value was generated

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The idcs_generated of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_generated

    @idcs_generated.setter
    def idcs_generated(self, idcs_generated):
        """
        Sets the idcs_generated of this ResourceTypeSchemaAttribute.
        Specifies whether this attribute value was generated

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param idcs_generated: The idcs_generated of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_generated = idcs_generated

    @property
    def idcs_auditable(self):
        """
        Gets the idcs_auditable of this ResourceTypeSchemaAttribute.
        Specifies whether changes to this attribute value are audited

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_auditable of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_auditable

    @idcs_auditable.setter
    def idcs_auditable(self, idcs_auditable):
        """
        Sets the idcs_auditable of this ResourceTypeSchemaAttribute.
        Specifies whether changes to this attribute value are audited

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean


        :param idcs_auditable: The idcs_auditable of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_auditable = idcs_auditable

    @property
    def idcs_target_attribute_name(self):
        """
        Gets the idcs_target_attribute_name of this ResourceTypeSchemaAttribute.
        Target attribute name that this attribute gets mapped to for persistence

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_attribute_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_target_attribute_name

    @idcs_target_attribute_name.setter
    def idcs_target_attribute_name(self, idcs_target_attribute_name):
        """
        Sets the idcs_target_attribute_name of this ResourceTypeSchemaAttribute.
        Target attribute name that this attribute gets mapped to for persistence

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_attribute_name: The idcs_target_attribute_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_target_attribute_name = idcs_target_attribute_name

    @property
    def idcs_target_unique_constraint_name(self):
        """
        Gets the idcs_target_unique_constraint_name of this ResourceTypeSchemaAttribute.
        Target index name created for this attribute for performance

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_unique_constraint_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_target_unique_constraint_name

    @idcs_target_unique_constraint_name.setter
    def idcs_target_unique_constraint_name(self, idcs_target_unique_constraint_name):
        """
        Sets the idcs_target_unique_constraint_name of this ResourceTypeSchemaAttribute.
        Target index name created for this attribute for performance

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_unique_constraint_name: The idcs_target_unique_constraint_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_target_unique_constraint_name = idcs_target_unique_constraint_name

    @property
    def idcs_target_norm_attribute_name(self):
        """
        Gets the idcs_target_norm_attribute_name of this ResourceTypeSchemaAttribute.
        Target normalized attribute name that this normalized value of attribute gets mapped to for persistence. Only set for caseExact=false & searchable attributes. Do not use by default.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_norm_attribute_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_target_norm_attribute_name

    @idcs_target_norm_attribute_name.setter
    def idcs_target_norm_attribute_name(self, idcs_target_norm_attribute_name):
        """
        Sets the idcs_target_norm_attribute_name of this ResourceTypeSchemaAttribute.
        Target normalized attribute name that this normalized value of attribute gets mapped to for persistence. Only set for caseExact=false & searchable attributes. Do not use by default.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_norm_attribute_name: The idcs_target_norm_attribute_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_target_norm_attribute_name = idcs_target_norm_attribute_name

    @property
    def idcs_target_attribute_name_to_migrate_from(self):
        """
        Gets the idcs_target_attribute_name_to_migrate_from of this ResourceTypeSchemaAttribute.
        Old Target attribute name from child table for CSVA attribute prior to migration. This maintains this attribute used to get mapped to for persistence

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_attribute_name_to_migrate_from of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_target_attribute_name_to_migrate_from

    @idcs_target_attribute_name_to_migrate_from.setter
    def idcs_target_attribute_name_to_migrate_from(self, idcs_target_attribute_name_to_migrate_from):
        """
        Sets the idcs_target_attribute_name_to_migrate_from of this ResourceTypeSchemaAttribute.
        Old Target attribute name from child table for CSVA attribute prior to migration. This maintains this attribute used to get mapped to for persistence

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_attribute_name_to_migrate_from: The idcs_target_attribute_name_to_migrate_from of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_target_attribute_name_to_migrate_from = idcs_target_attribute_name_to_migrate_from

    @property
    def idcs_to_target_mapper(self):
        """
        Gets the idcs_to_target_mapper of this ResourceTypeSchemaAttribute.
        Specifies the mapper to use when mapping this attribute value to DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_to_target_mapper of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_to_target_mapper

    @idcs_to_target_mapper.setter
    def idcs_to_target_mapper(self, idcs_to_target_mapper):
        """
        Sets the idcs_to_target_mapper of this ResourceTypeSchemaAttribute.
        Specifies the mapper to use when mapping this attribute value to DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_to_target_mapper: The idcs_to_target_mapper of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_to_target_mapper = idcs_to_target_mapper

    @property
    def idcs_from_target_mapper(self):
        """
        Gets the idcs_from_target_mapper of this ResourceTypeSchemaAttribute.
        Specifies the mapper to use when mapping this attribute value from DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_from_target_mapper of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_from_target_mapper

    @idcs_from_target_mapper.setter
    def idcs_from_target_mapper(self, idcs_from_target_mapper):
        """
        Sets the idcs_from_target_mapper of this ResourceTypeSchemaAttribute.
        Specifies the mapper to use when mapping this attribute value from DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_from_target_mapper: The idcs_from_target_mapper of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_from_target_mapper = idcs_from_target_mapper

    @property
    def idcs_display_name(self):
        """
        Gets the idcs_display_name of this ResourceTypeSchemaAttribute.
        Specifies the user-friendly displayable attribute name or catalog key used for localization

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :return: The idcs_display_name of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_display_name

    @idcs_display_name.setter
    def idcs_display_name(self, idcs_display_name):
        """
        Sets the idcs_display_name of this ResourceTypeSchemaAttribute.
        Specifies the user-friendly displayable attribute name or catalog key used for localization

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - idcsSearchable: true
         - type: string
         - uniqueness: none


        :param idcs_display_name: The idcs_display_name of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_display_name = idcs_display_name

    @property
    def idcs_canonical_value_source_resource_type(self):
        """
        Gets the idcs_canonical_value_source_resource_type of this ResourceTypeSchemaAttribute.
        Specifies the Resource type to read from for dynamic canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_resource_type of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_canonical_value_source_resource_type

    @idcs_canonical_value_source_resource_type.setter
    def idcs_canonical_value_source_resource_type(self, idcs_canonical_value_source_resource_type):
        """
        Sets the idcs_canonical_value_source_resource_type of this ResourceTypeSchemaAttribute.
        Specifies the Resource type to read from for dynamic canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_resource_type: The idcs_canonical_value_source_resource_type of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_canonical_value_source_resource_type = idcs_canonical_value_source_resource_type

    @property
    def idcs_canonical_value_source_filter(self):
        """
        Gets the idcs_canonical_value_source_filter of this ResourceTypeSchemaAttribute.
        Filter to use when getting canonical values for this schema attribute

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_filter of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_canonical_value_source_filter

    @idcs_canonical_value_source_filter.setter
    def idcs_canonical_value_source_filter(self, idcs_canonical_value_source_filter):
        """
        Sets the idcs_canonical_value_source_filter of this ResourceTypeSchemaAttribute.
        Filter to use when getting canonical values for this schema attribute

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_filter: The idcs_canonical_value_source_filter of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_canonical_value_source_filter = idcs_canonical_value_source_filter

    @property
    def idcs_validate_reference(self):
        """
        Gets the idcs_validate_reference of this ResourceTypeSchemaAttribute.
        Validate payload reference value during create, replace, and update. Default is True.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_validate_reference of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_validate_reference

    @idcs_validate_reference.setter
    def idcs_validate_reference(self, idcs_validate_reference):
        """
        Sets the idcs_validate_reference of this ResourceTypeSchemaAttribute.
        Validate payload reference value during create, replace, and update. Default is True.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_validate_reference: The idcs_validate_reference of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_validate_reference = idcs_validate_reference

    @property
    def idcs_composite_key(self):
        """
        Gets the idcs_composite_key of this ResourceTypeSchemaAttribute.
        The set of one or more sub attributes' names of a CMVA, whose values uniquely identify an instance of a CMVA

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_composite_key of this ResourceTypeSchemaAttribute.
        :rtype: list[str]
        """
        return self._idcs_composite_key

    @idcs_composite_key.setter
    def idcs_composite_key(self, idcs_composite_key):
        """
        Sets the idcs_composite_key of this ResourceTypeSchemaAttribute.
        The set of one or more sub attributes' names of a CMVA, whose values uniquely identify an instance of a CMVA

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_composite_key: The idcs_composite_key of this ResourceTypeSchemaAttribute.
        :type: list[str]
        """
        self._idcs_composite_key = idcs_composite_key

    @property
    def idcs_fetch_complex_attribute_values(self):
        """
        Gets the idcs_fetch_complex_attribute_values of this ResourceTypeSchemaAttribute.
        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - idcsSearchable: true
        - returned: default
        - type: boolean
        - uniqueness: none
        Whether the CMVA attribute will be fetched or not for current resource in AbstractResourceManager update operation before calling data provider update. Default is true.


        :return: The idcs_fetch_complex_attribute_values of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_fetch_complex_attribute_values

    @idcs_fetch_complex_attribute_values.setter
    def idcs_fetch_complex_attribute_values(self, idcs_fetch_complex_attribute_values):
        """
        Sets the idcs_fetch_complex_attribute_values of this ResourceTypeSchemaAttribute.
        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - idcsSearchable: true
        - returned: default
        - type: boolean
        - uniqueness: none
        Whether the CMVA attribute will be fetched or not for current resource in AbstractResourceManager update operation before calling data provider update. Default is true.


        :param idcs_fetch_complex_attribute_values: The idcs_fetch_complex_attribute_values of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_fetch_complex_attribute_values = idcs_fetch_complex_attribute_values

    @property
    def idcs_scim_compliant(self):
        """
        Gets the idcs_scim_compliant of this ResourceTypeSchemaAttribute.
        Indicates if the attribute is scim compliant, default is true

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_scim_compliant of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_scim_compliant

    @idcs_scim_compliant.setter
    def idcs_scim_compliant(self, idcs_scim_compliant):
        """
        Sets the idcs_scim_compliant of this ResourceTypeSchemaAttribute.
        Indicates if the attribute is scim compliant, default is true

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean


        :param idcs_scim_compliant: The idcs_scim_compliant of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_scim_compliant = idcs_scim_compliant

    @property
    def idcs_attribute_mappable(self):
        """
        Gets the idcs_attribute_mappable of this ResourceTypeSchemaAttribute.
        Specifies if the attribute can be used for mapping with external identity sources such as AD or LDAP. If isSchemaMappable: false for the schema in which this attribute is defined, then this flag is ignored

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :return: The idcs_attribute_mappable of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_attribute_mappable

    @idcs_attribute_mappable.setter
    def idcs_attribute_mappable(self, idcs_attribute_mappable):
        """
        Sets the idcs_attribute_mappable of this ResourceTypeSchemaAttribute.
        Specifies if the attribute can be used for mapping with external identity sources such as AD or LDAP. If isSchemaMappable: false for the schema in which this attribute is defined, then this flag is ignored

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - idcsSearchable: true
         - returned: default
         - type: boolean


        :param idcs_attribute_mappable: The idcs_attribute_mappable of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_attribute_mappable = idcs_attribute_mappable

    @property
    def idcs_ref_resource_attribute(self):
        """
        Gets the idcs_ref_resource_attribute of this ResourceTypeSchemaAttribute.
        Specifies the referenced Resource attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string


        :return: The idcs_ref_resource_attribute of this ResourceTypeSchemaAttribute.
        :rtype: str
        """
        return self._idcs_ref_resource_attribute

    @idcs_ref_resource_attribute.setter
    def idcs_ref_resource_attribute(self, idcs_ref_resource_attribute):
        """
        Sets the idcs_ref_resource_attribute of this ResourceTypeSchemaAttribute.
        Specifies the referenced Resource attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: string


        :param idcs_ref_resource_attribute: The idcs_ref_resource_attribute of this ResourceTypeSchemaAttribute.
        :type: str
        """
        self._idcs_ref_resource_attribute = idcs_ref_resource_attribute

    @property
    def idcs_attribute_cacheable(self):
        """
        Gets the idcs_attribute_cacheable of this ResourceTypeSchemaAttribute.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_attribute_cacheable of this ResourceTypeSchemaAttribute.
        :rtype: bool
        """
        return self._idcs_attribute_cacheable

    @idcs_attribute_cacheable.setter
    def idcs_attribute_cacheable(self, idcs_attribute_cacheable):
        """
        Sets the idcs_attribute_cacheable of this ResourceTypeSchemaAttribute.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - idcsSearchable: true
         - required: false
         - returned: default
         - type: boolean


        :param idcs_attribute_cacheable: The idcs_attribute_cacheable of this ResourceTypeSchemaAttribute.
        :type: bool
        """
        self._idcs_attribute_cacheable = idcs_attribute_cacheable

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
