# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppExtensionManagedappApp(object):
    """
    Managed App
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppExtensionManagedappApp object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connected:
            The value to assign to the connected property of this AppExtensionManagedappApp.
        :type connected: bool

        :param can_be_authoritative:
            The value to assign to the can_be_authoritative property of this AppExtensionManagedappApp.
        :type can_be_authoritative: bool

        :param is_authoritative:
            The value to assign to the is_authoritative property of this AppExtensionManagedappApp.
        :type is_authoritative: bool

        :param is_on_premise_app:
            The value to assign to the is_on_premise_app property of this AppExtensionManagedappApp.
        :type is_on_premise_app: bool

        :param is_directory:
            The value to assign to the is_directory property of this AppExtensionManagedappApp.
        :type is_directory: bool

        :param is_schema_discovery_supported:
            The value to assign to the is_schema_discovery_supported property of this AppExtensionManagedappApp.
        :type is_schema_discovery_supported: bool

        :param is_schema_customization_supported:
            The value to assign to the is_schema_customization_supported property of this AppExtensionManagedappApp.
        :type is_schema_customization_supported: bool

        :param enable_sync:
            The value to assign to the enable_sync property of this AppExtensionManagedappApp.
        :type enable_sync: bool

        :param enable_sync_summary_report_notification:
            The value to assign to the enable_sync_summary_report_notification property of this AppExtensionManagedappApp.
        :type enable_sync_summary_report_notification: bool

        :param enable_auth_sync_new_user_notification:
            The value to assign to the enable_auth_sync_new_user_notification property of this AppExtensionManagedappApp.
        :type enable_auth_sync_new_user_notification: bool

        :param admin_consent_granted:
            The value to assign to the admin_consent_granted property of this AppExtensionManagedappApp.
        :type admin_consent_granted: bool

        :param is_three_legged_o_auth_enabled:
            The value to assign to the is_three_legged_o_auth_enabled property of this AppExtensionManagedappApp.
        :type is_three_legged_o_auth_enabled: bool

        :param is_two_legged_o_auth_enabled:
            The value to assign to the is_two_legged_o_auth_enabled property of this AppExtensionManagedappApp.
        :type is_two_legged_o_auth_enabled: bool

        :param three_legged_o_auth_provider_name:
            The value to assign to the three_legged_o_auth_provider_name property of this AppExtensionManagedappApp.
        :type three_legged_o_auth_provider_name: str

        :param sync_config_last_modified:
            The value to assign to the sync_config_last_modified property of this AppExtensionManagedappApp.
        :type sync_config_last_modified: str

        :param account_form_visible:
            The value to assign to the account_form_visible property of this AppExtensionManagedappApp.
        :type account_form_visible: bool

        :param identity_bridges:
            The value to assign to the identity_bridges property of this AppExtensionManagedappApp.
        :type identity_bridges: list[oci.identity_domains.models.AppIdentityBridges]

        :param connector_bundle:
            The value to assign to the connector_bundle property of this AppExtensionManagedappApp.
        :type connector_bundle: oci.identity_domains.models.AppConnectorBundle

        :param bundle_configuration_properties:
            The value to assign to the bundle_configuration_properties property of this AppExtensionManagedappApp.
        :type bundle_configuration_properties: list[oci.identity_domains.models.AppBundleConfigurationProperties]

        :param object_classes:
            The value to assign to the object_classes property of this AppExtensionManagedappApp.
        :type object_classes: list[oci.identity_domains.models.AppObjectClasses]

        :param bundle_pool_configuration:
            The value to assign to the bundle_pool_configuration property of this AppExtensionManagedappApp.
        :type bundle_pool_configuration: oci.identity_domains.models.AppBundlePoolConfiguration

        :param flat_file_connector_bundle:
            The value to assign to the flat_file_connector_bundle property of this AppExtensionManagedappApp.
        :type flat_file_connector_bundle: oci.identity_domains.models.AppFlatFileConnectorBundle

        :param flat_file_bundle_configuration_properties:
            The value to assign to the flat_file_bundle_configuration_properties property of this AppExtensionManagedappApp.
        :type flat_file_bundle_configuration_properties: list[oci.identity_domains.models.AppFlatFileBundleConfigurationProperties]

        :param three_legged_o_auth_credential:
            The value to assign to the three_legged_o_auth_credential property of this AppExtensionManagedappApp.
        :type three_legged_o_auth_credential: oci.identity_domains.models.AppThreeLeggedOAuthCredential

        """
        self.swagger_types = {
            'connected': 'bool',
            'can_be_authoritative': 'bool',
            'is_authoritative': 'bool',
            'is_on_premise_app': 'bool',
            'is_directory': 'bool',
            'is_schema_discovery_supported': 'bool',
            'is_schema_customization_supported': 'bool',
            'enable_sync': 'bool',
            'enable_sync_summary_report_notification': 'bool',
            'enable_auth_sync_new_user_notification': 'bool',
            'admin_consent_granted': 'bool',
            'is_three_legged_o_auth_enabled': 'bool',
            'is_two_legged_o_auth_enabled': 'bool',
            'three_legged_o_auth_provider_name': 'str',
            'sync_config_last_modified': 'str',
            'account_form_visible': 'bool',
            'identity_bridges': 'list[AppIdentityBridges]',
            'connector_bundle': 'AppConnectorBundle',
            'bundle_configuration_properties': 'list[AppBundleConfigurationProperties]',
            'object_classes': 'list[AppObjectClasses]',
            'bundle_pool_configuration': 'AppBundlePoolConfiguration',
            'flat_file_connector_bundle': 'AppFlatFileConnectorBundle',
            'flat_file_bundle_configuration_properties': 'list[AppFlatFileBundleConfigurationProperties]',
            'three_legged_o_auth_credential': 'AppThreeLeggedOAuthCredential'
        }

        self.attribute_map = {
            'connected': 'connected',
            'can_be_authoritative': 'canBeAuthoritative',
            'is_authoritative': 'isAuthoritative',
            'is_on_premise_app': 'isOnPremiseApp',
            'is_directory': 'isDirectory',
            'is_schema_discovery_supported': 'isSchemaDiscoverySupported',
            'is_schema_customization_supported': 'isSchemaCustomizationSupported',
            'enable_sync': 'enableSync',
            'enable_sync_summary_report_notification': 'enableSyncSummaryReportNotification',
            'enable_auth_sync_new_user_notification': 'enableAuthSyncNewUserNotification',
            'admin_consent_granted': 'adminConsentGranted',
            'is_three_legged_o_auth_enabled': 'isThreeLeggedOAuthEnabled',
            'is_two_legged_o_auth_enabled': 'isTwoLeggedOAuthEnabled',
            'three_legged_o_auth_provider_name': 'threeLeggedOAuthProviderName',
            'sync_config_last_modified': 'syncConfigLastModified',
            'account_form_visible': 'accountFormVisible',
            'identity_bridges': 'identityBridges',
            'connector_bundle': 'connectorBundle',
            'bundle_configuration_properties': 'bundleConfigurationProperties',
            'object_classes': 'objectClasses',
            'bundle_pool_configuration': 'bundlePoolConfiguration',
            'flat_file_connector_bundle': 'flatFileConnectorBundle',
            'flat_file_bundle_configuration_properties': 'flatFileBundleConfigurationProperties',
            'three_legged_o_auth_credential': 'threeLeggedOAuthCredential'
        }

        self._connected = None
        self._can_be_authoritative = None
        self._is_authoritative = None
        self._is_on_premise_app = None
        self._is_directory = None
        self._is_schema_discovery_supported = None
        self._is_schema_customization_supported = None
        self._enable_sync = None
        self._enable_sync_summary_report_notification = None
        self._enable_auth_sync_new_user_notification = None
        self._admin_consent_granted = None
        self._is_three_legged_o_auth_enabled = None
        self._is_two_legged_o_auth_enabled = None
        self._three_legged_o_auth_provider_name = None
        self._sync_config_last_modified = None
        self._account_form_visible = None
        self._identity_bridges = None
        self._connector_bundle = None
        self._bundle_configuration_properties = None
        self._object_classes = None
        self._bundle_pool_configuration = None
        self._flat_file_connector_bundle = None
        self._flat_file_bundle_configuration_properties = None
        self._three_legged_o_auth_credential = None

    @property
    def connected(self):
        """
        Gets the connected of this AppExtensionManagedappApp.
        If true, the accounts of the application are managed through an ICF connector bundle

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The connected of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._connected

    @connected.setter
    def connected(self, connected):
        """
        Sets the connected of this AppExtensionManagedappApp.
        If true, the accounts of the application are managed through an ICF connector bundle

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param connected: The connected of this AppExtensionManagedappApp.
        :type: bool
        """
        self._connected = connected

    @property
    def can_be_authoritative(self):
        """
        Gets the can_be_authoritative of this AppExtensionManagedappApp.
        If true, the managed app can be authoritative.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The can_be_authoritative of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._can_be_authoritative

    @can_be_authoritative.setter
    def can_be_authoritative(self, can_be_authoritative):
        """
        Sets the can_be_authoritative of this AppExtensionManagedappApp.
        If true, the managed app can be authoritative.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param can_be_authoritative: The can_be_authoritative of this AppExtensionManagedappApp.
        :type: bool
        """
        self._can_be_authoritative = can_be_authoritative

    @property
    def is_authoritative(self):
        """
        Gets the is_authoritative of this AppExtensionManagedappApp.
        If true, sync from the managed app will be performed as authoritative sync.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_authoritative of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._is_authoritative

    @is_authoritative.setter
    def is_authoritative(self, is_authoritative):
        """
        Sets the is_authoritative of this AppExtensionManagedappApp.
        If true, sync from the managed app will be performed as authoritative sync.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_authoritative: The is_authoritative of this AppExtensionManagedappApp.
        :type: bool
        """
        self._is_authoritative = is_authoritative

    @property
    def is_on_premise_app(self):
        """
        Gets the is_on_premise_app of this AppExtensionManagedappApp.
        If true, the managed app is an On-Premise app.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_on_premise_app of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._is_on_premise_app

    @is_on_premise_app.setter
    def is_on_premise_app(self, is_on_premise_app):
        """
        Sets the is_on_premise_app of this AppExtensionManagedappApp.
        If true, the managed app is an On-Premise app.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_on_premise_app: The is_on_premise_app of this AppExtensionManagedappApp.
        :type: bool
        """
        self._is_on_premise_app = is_on_premise_app

    @property
    def is_directory(self):
        """
        Gets the is_directory of this AppExtensionManagedappApp.
        If true, the managed app is a directory.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_directory of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._is_directory

    @is_directory.setter
    def is_directory(self, is_directory):
        """
        Sets the is_directory of this AppExtensionManagedappApp.
        If true, the managed app is a directory.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_directory: The is_directory of this AppExtensionManagedappApp.
        :type: bool
        """
        self._is_directory = is_directory

    @property
    def is_schema_discovery_supported(self):
        """
        Gets the is_schema_discovery_supported of this AppExtensionManagedappApp.
        If true, the managed app supports schema discovery.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_schema_discovery_supported of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._is_schema_discovery_supported

    @is_schema_discovery_supported.setter
    def is_schema_discovery_supported(self, is_schema_discovery_supported):
        """
        Sets the is_schema_discovery_supported of this AppExtensionManagedappApp.
        If true, the managed app supports schema discovery.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_schema_discovery_supported: The is_schema_discovery_supported of this AppExtensionManagedappApp.
        :type: bool
        """
        self._is_schema_discovery_supported = is_schema_discovery_supported

    @property
    def is_schema_customization_supported(self):
        """
        Gets the is_schema_customization_supported of this AppExtensionManagedappApp.
        If true, the managed app supports schema customization.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_schema_customization_supported of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._is_schema_customization_supported

    @is_schema_customization_supported.setter
    def is_schema_customization_supported(self, is_schema_customization_supported):
        """
        Sets the is_schema_customization_supported of this AppExtensionManagedappApp.
        If true, the managed app supports schema customization.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_schema_customization_supported: The is_schema_customization_supported of this AppExtensionManagedappApp.
        :type: bool
        """
        self._is_schema_customization_supported = is_schema_customization_supported

    @property
    def enable_sync(self):
        """
        Gets the enable_sync of this AppExtensionManagedappApp.
        If true, sync run-time operations are enabled for this App.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The enable_sync of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._enable_sync

    @enable_sync.setter
    def enable_sync(self, enable_sync):
        """
        Sets the enable_sync of this AppExtensionManagedappApp.
        If true, sync run-time operations are enabled for this App.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param enable_sync: The enable_sync of this AppExtensionManagedappApp.
        :type: bool
        """
        self._enable_sync = enable_sync

    @property
    def enable_sync_summary_report_notification(self):
        """
        Gets the enable_sync_summary_report_notification of this AppExtensionManagedappApp.
        If true, send sync summary as notification upon job completion.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The enable_sync_summary_report_notification of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._enable_sync_summary_report_notification

    @enable_sync_summary_report_notification.setter
    def enable_sync_summary_report_notification(self, enable_sync_summary_report_notification):
        """
        Sets the enable_sync_summary_report_notification of this AppExtensionManagedappApp.
        If true, send sync summary as notification upon job completion.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param enable_sync_summary_report_notification: The enable_sync_summary_report_notification of this AppExtensionManagedappApp.
        :type: bool
        """
        self._enable_sync_summary_report_notification = enable_sync_summary_report_notification

    @property
    def enable_auth_sync_new_user_notification(self):
        """
        Gets the enable_auth_sync_new_user_notification of this AppExtensionManagedappApp.
        If true, send activation email to new users created from authoritative sync.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The enable_auth_sync_new_user_notification of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._enable_auth_sync_new_user_notification

    @enable_auth_sync_new_user_notification.setter
    def enable_auth_sync_new_user_notification(self, enable_auth_sync_new_user_notification):
        """
        Sets the enable_auth_sync_new_user_notification of this AppExtensionManagedappApp.
        If true, send activation email to new users created from authoritative sync.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param enable_auth_sync_new_user_notification: The enable_auth_sync_new_user_notification of this AppExtensionManagedappApp.
        :type: bool
        """
        self._enable_auth_sync_new_user_notification = enable_auth_sync_new_user_notification

    @property
    def admin_consent_granted(self):
        """
        Gets the admin_consent_granted of this AppExtensionManagedappApp.
        If true, admin has granted consent to perform managed app run-time operations.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The admin_consent_granted of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._admin_consent_granted

    @admin_consent_granted.setter
    def admin_consent_granted(self, admin_consent_granted):
        """
        Sets the admin_consent_granted of this AppExtensionManagedappApp.
        If true, admin has granted consent to perform managed app run-time operations.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param admin_consent_granted: The admin_consent_granted of this AppExtensionManagedappApp.
        :type: bool
        """
        self._admin_consent_granted = admin_consent_granted

    @property
    def is_three_legged_o_auth_enabled(self):
        """
        Gets the is_three_legged_o_auth_enabled of this AppExtensionManagedappApp.
        If true, the managed app requires 3-legged OAuth for authorization.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_three_legged_o_auth_enabled of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._is_three_legged_o_auth_enabled

    @is_three_legged_o_auth_enabled.setter
    def is_three_legged_o_auth_enabled(self, is_three_legged_o_auth_enabled):
        """
        Sets the is_three_legged_o_auth_enabled of this AppExtensionManagedappApp.
        If true, the managed app requires 3-legged OAuth for authorization.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_three_legged_o_auth_enabled: The is_three_legged_o_auth_enabled of this AppExtensionManagedappApp.
        :type: bool
        """
        self._is_three_legged_o_auth_enabled = is_three_legged_o_auth_enabled

    @property
    def is_two_legged_o_auth_enabled(self):
        """
        Gets the is_two_legged_o_auth_enabled of this AppExtensionManagedappApp.
        If true, indicates that Oracle Identity Cloud Service can use two-legged OAuth to connect to this ManagedApp.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_two_legged_o_auth_enabled of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._is_two_legged_o_auth_enabled

    @is_two_legged_o_auth_enabled.setter
    def is_two_legged_o_auth_enabled(self, is_two_legged_o_auth_enabled):
        """
        Sets the is_two_legged_o_auth_enabled of this AppExtensionManagedappApp.
        If true, indicates that Oracle Identity Cloud Service can use two-legged OAuth to connect to this ManagedApp.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_two_legged_o_auth_enabled: The is_two_legged_o_auth_enabled of this AppExtensionManagedappApp.
        :type: bool
        """
        self._is_two_legged_o_auth_enabled = is_two_legged_o_auth_enabled

    @property
    def three_legged_o_auth_provider_name(self):
        """
        Gets the three_legged_o_auth_provider_name of this AppExtensionManagedappApp.
        Three legged OAuth provider name in Oracle Identity Cloud Service.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string


        :return: The three_legged_o_auth_provider_name of this AppExtensionManagedappApp.
        :rtype: str
        """
        return self._three_legged_o_auth_provider_name

    @three_legged_o_auth_provider_name.setter
    def three_legged_o_auth_provider_name(self, three_legged_o_auth_provider_name):
        """
        Sets the three_legged_o_auth_provider_name of this AppExtensionManagedappApp.
        Three legged OAuth provider name in Oracle Identity Cloud Service.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string


        :param three_legged_o_auth_provider_name: The three_legged_o_auth_provider_name of this AppExtensionManagedappApp.
        :type: str
        """
        self._three_legged_o_auth_provider_name = three_legged_o_auth_provider_name

    @property
    def sync_config_last_modified(self):
        """
        Gets the sync_config_last_modified of this AppExtensionManagedappApp.
        The most recent DateTime that the configuration of this App was updated. AppServices updates this timestamp whenever AppServices updates an App's configuration with respect to synchronization.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: dateTime
         - uniqueness: none


        :return: The sync_config_last_modified of this AppExtensionManagedappApp.
        :rtype: str
        """
        return self._sync_config_last_modified

    @sync_config_last_modified.setter
    def sync_config_last_modified(self, sync_config_last_modified):
        """
        Sets the sync_config_last_modified of this AppExtensionManagedappApp.
        The most recent DateTime that the configuration of this App was updated. AppServices updates this timestamp whenever AppServices updates an App's configuration with respect to synchronization.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: dateTime
         - uniqueness: none


        :param sync_config_last_modified: The sync_config_last_modified of this AppExtensionManagedappApp.
        :type: str
        """
        self._sync_config_last_modified = sync_config_last_modified

    @property
    def account_form_visible(self):
        """
        Gets the account_form_visible of this AppExtensionManagedappApp.
        If true, then the account form will be displayed in the Oracle Identity Cloud Service UI to interactively create or update an account for this App. If a value is not specified for this attribute, a default value of \\\"false\\\" will be assumed as the value for this attribute.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The account_form_visible of this AppExtensionManagedappApp.
        :rtype: bool
        """
        return self._account_form_visible

    @account_form_visible.setter
    def account_form_visible(self, account_form_visible):
        """
        Sets the account_form_visible of this AppExtensionManagedappApp.
        If true, then the account form will be displayed in the Oracle Identity Cloud Service UI to interactively create or update an account for this App. If a value is not specified for this attribute, a default value of \\\"false\\\" will be assumed as the value for this attribute.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param account_form_visible: The account_form_visible of this AppExtensionManagedappApp.
        :type: bool
        """
        self._account_form_visible = account_form_visible

    @property
    def identity_bridges(self):
        """
        Gets the identity_bridges of this AppExtensionManagedappApp.
        IdentityBridges associated with this App

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The identity_bridges of this AppExtensionManagedappApp.
        :rtype: list[oci.identity_domains.models.AppIdentityBridges]
        """
        return self._identity_bridges

    @identity_bridges.setter
    def identity_bridges(self, identity_bridges):
        """
        Sets the identity_bridges of this AppExtensionManagedappApp.
        IdentityBridges associated with this App

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param identity_bridges: The identity_bridges of this AppExtensionManagedappApp.
        :type: list[oci.identity_domains.models.AppIdentityBridges]
        """
        self._identity_bridges = identity_bridges

    @property
    def connector_bundle(self):
        """
        Gets the connector_bundle of this AppExtensionManagedappApp.

        :return: The connector_bundle of this AppExtensionManagedappApp.
        :rtype: oci.identity_domains.models.AppConnectorBundle
        """
        return self._connector_bundle

    @connector_bundle.setter
    def connector_bundle(self, connector_bundle):
        """
        Sets the connector_bundle of this AppExtensionManagedappApp.

        :param connector_bundle: The connector_bundle of this AppExtensionManagedappApp.
        :type: oci.identity_domains.models.AppConnectorBundle
        """
        self._connector_bundle = connector_bundle

    @property
    def bundle_configuration_properties(self):
        """
        Gets the bundle_configuration_properties of this AppExtensionManagedappApp.
        ConnectorBundle configuration properties

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The bundle_configuration_properties of this AppExtensionManagedappApp.
        :rtype: list[oci.identity_domains.models.AppBundleConfigurationProperties]
        """
        return self._bundle_configuration_properties

    @bundle_configuration_properties.setter
    def bundle_configuration_properties(self, bundle_configuration_properties):
        """
        Sets the bundle_configuration_properties of this AppExtensionManagedappApp.
        ConnectorBundle configuration properties

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param bundle_configuration_properties: The bundle_configuration_properties of this AppExtensionManagedappApp.
        :type: list[oci.identity_domains.models.AppBundleConfigurationProperties]
        """
        self._bundle_configuration_properties = bundle_configuration_properties

    @property
    def object_classes(self):
        """
        Gets the object_classes of this AppExtensionManagedappApp.
        Object classes

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The object_classes of this AppExtensionManagedappApp.
        :rtype: list[oci.identity_domains.models.AppObjectClasses]
        """
        return self._object_classes

    @object_classes.setter
    def object_classes(self, object_classes):
        """
        Sets the object_classes of this AppExtensionManagedappApp.
        Object classes

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param object_classes: The object_classes of this AppExtensionManagedappApp.
        :type: list[oci.identity_domains.models.AppObjectClasses]
        """
        self._object_classes = object_classes

    @property
    def bundle_pool_configuration(self):
        """
        Gets the bundle_pool_configuration of this AppExtensionManagedappApp.

        :return: The bundle_pool_configuration of this AppExtensionManagedappApp.
        :rtype: oci.identity_domains.models.AppBundlePoolConfiguration
        """
        return self._bundle_pool_configuration

    @bundle_pool_configuration.setter
    def bundle_pool_configuration(self, bundle_pool_configuration):
        """
        Sets the bundle_pool_configuration of this AppExtensionManagedappApp.

        :param bundle_pool_configuration: The bundle_pool_configuration of this AppExtensionManagedappApp.
        :type: oci.identity_domains.models.AppBundlePoolConfiguration
        """
        self._bundle_pool_configuration = bundle_pool_configuration

    @property
    def flat_file_connector_bundle(self):
        """
        Gets the flat_file_connector_bundle of this AppExtensionManagedappApp.

        :return: The flat_file_connector_bundle of this AppExtensionManagedappApp.
        :rtype: oci.identity_domains.models.AppFlatFileConnectorBundle
        """
        return self._flat_file_connector_bundle

    @flat_file_connector_bundle.setter
    def flat_file_connector_bundle(self, flat_file_connector_bundle):
        """
        Sets the flat_file_connector_bundle of this AppExtensionManagedappApp.

        :param flat_file_connector_bundle: The flat_file_connector_bundle of this AppExtensionManagedappApp.
        :type: oci.identity_domains.models.AppFlatFileConnectorBundle
        """
        self._flat_file_connector_bundle = flat_file_connector_bundle

    @property
    def flat_file_bundle_configuration_properties(self):
        """
        Gets the flat_file_bundle_configuration_properties of this AppExtensionManagedappApp.
        Flat file connector bundle configuration properties

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The flat_file_bundle_configuration_properties of this AppExtensionManagedappApp.
        :rtype: list[oci.identity_domains.models.AppFlatFileBundleConfigurationProperties]
        """
        return self._flat_file_bundle_configuration_properties

    @flat_file_bundle_configuration_properties.setter
    def flat_file_bundle_configuration_properties(self, flat_file_bundle_configuration_properties):
        """
        Sets the flat_file_bundle_configuration_properties of this AppExtensionManagedappApp.
        Flat file connector bundle configuration properties

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param flat_file_bundle_configuration_properties: The flat_file_bundle_configuration_properties of this AppExtensionManagedappApp.
        :type: list[oci.identity_domains.models.AppFlatFileBundleConfigurationProperties]
        """
        self._flat_file_bundle_configuration_properties = flat_file_bundle_configuration_properties

    @property
    def three_legged_o_auth_credential(self):
        """
        Gets the three_legged_o_auth_credential of this AppExtensionManagedappApp.

        :return: The three_legged_o_auth_credential of this AppExtensionManagedappApp.
        :rtype: oci.identity_domains.models.AppThreeLeggedOAuthCredential
        """
        return self._three_legged_o_auth_credential

    @three_legged_o_auth_credential.setter
    def three_legged_o_auth_credential(self, three_legged_o_auth_credential):
        """
        Sets the three_legged_o_auth_credential of this AppExtensionManagedappApp.

        :param three_legged_o_auth_credential: The three_legged_o_auth_credential of this AppExtensionManagedappApp.
        :type: oci.identity_domains.models.AppThreeLeggedOAuthCredential
        """
        self._three_legged_o_auth_credential = three_legged_o_auth_credential

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
