# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppExtensionDbcsApp(object):
    """
    This extension provides attributes for database service facet of an App
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppExtensionDbcsApp object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param domain_name:
            The value to assign to the domain_name property of this AppExtensionDbcsApp.
        :type domain_name: str

        :param domain_app:
            The value to assign to the domain_app property of this AppExtensionDbcsApp.
        :type domain_app: oci.identity_domains.models.AppDomainApp

        """
        self.swagger_types = {
            'domain_name': 'str',
            'domain_app': 'AppDomainApp'
        }

        self.attribute_map = {
            'domain_name': 'domainName',
            'domain_app': 'domainApp'
        }

        self._domain_name = None
        self._domain_app = None

    @property
    def domain_name(self):
        """
        Gets the domain_name of this AppExtensionDbcsApp.
        The name of the Enterprise Domain that contains any number of DBInstances. If specified, the value must be unique.  A non-null value indicates that App represents a DBDomain. A value of null indicates that the App represents an DB-instance.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :return: The domain_name of this AppExtensionDbcsApp.
        :rtype: str
        """
        return self._domain_name

    @domain_name.setter
    def domain_name(self, domain_name):
        """
        Sets the domain_name of this AppExtensionDbcsApp.
        The name of the Enterprise Domain that contains any number of DBInstances. If specified, the value must be unique.  A non-null value indicates that App represents a DBDomain. A value of null indicates that the App represents an DB-instance.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :param domain_name: The domain_name of this AppExtensionDbcsApp.
        :type: str
        """
        self._domain_name = domain_name

    @property
    def domain_app(self):
        """
        Gets the domain_app of this AppExtensionDbcsApp.

        :return: The domain_app of this AppExtensionDbcsApp.
        :rtype: oci.identity_domains.models.AppDomainApp
        """
        return self._domain_app

    @domain_app.setter
    def domain_app(self, domain_app):
        """
        Sets the domain_app of this AppExtensionDbcsApp.

        :param domain_app: The domain_app of this AppExtensionDbcsApp.
        :type: oci.identity_domains.models.AppDomainApp
        """
        self._domain_app = domain_app

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
