# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeploymentEnvironmentSummary(object):
    """
    The metadata specific to a production or development/testing environment.
    """

    #: A constant which can be used with the environment_type property of a DeploymentEnvironmentSummary.
    #: This constant has a value of "PRODUCTION"
    ENVIRONMENT_TYPE_PRODUCTION = "PRODUCTION"

    #: A constant which can be used with the environment_type property of a DeploymentEnvironmentSummary.
    #: This constant has a value of "DEVELOPMENT_OR_TESTING"
    ENVIRONMENT_TYPE_DEVELOPMENT_OR_TESTING = "DEVELOPMENT_OR_TESTING"

    #: A constant which can be used with the category property of a DeploymentEnvironmentSummary.
    #: This constant has a value of "DATA_REPLICATION"
    CATEGORY_DATA_REPLICATION = "DATA_REPLICATION"

    #: A constant which can be used with the category property of a DeploymentEnvironmentSummary.
    #: This constant has a value of "STREAM_ANALYTICS"
    CATEGORY_STREAM_ANALYTICS = "STREAM_ANALYTICS"

    #: A constant which can be used with the category property of a DeploymentEnvironmentSummary.
    #: This constant has a value of "DATA_TRANSFORMS"
    CATEGORY_DATA_TRANSFORMS = "DATA_TRANSFORMS"

    def __init__(self, **kwargs):
        """
        Initializes a new DeploymentEnvironmentSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param environment_type:
            The value to assign to the environment_type property of this DeploymentEnvironmentSummary.
            Allowed values for this property are: "PRODUCTION", "DEVELOPMENT_OR_TESTING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type environment_type: str

        :param category:
            The value to assign to the category property of this DeploymentEnvironmentSummary.
            Allowed values for this property are: "DATA_REPLICATION", "STREAM_ANALYTICS", "DATA_TRANSFORMS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type category: str

        :param display_name:
            The value to assign to the display_name property of this DeploymentEnvironmentSummary.
        :type display_name: str

        :param min_cpu_core_count:
            The value to assign to the min_cpu_core_count property of this DeploymentEnvironmentSummary.
        :type min_cpu_core_count: int

        :param default_cpu_core_count:
            The value to assign to the default_cpu_core_count property of this DeploymentEnvironmentSummary.
        :type default_cpu_core_count: int

        :param max_cpu_core_count:
            The value to assign to the max_cpu_core_count property of this DeploymentEnvironmentSummary.
        :type max_cpu_core_count: int

        :param is_auto_scaling_enabled_by_default:
            The value to assign to the is_auto_scaling_enabled_by_default property of this DeploymentEnvironmentSummary.
        :type is_auto_scaling_enabled_by_default: bool

        :param network_bandwidth_per_ocpu_in_gbps:
            The value to assign to the network_bandwidth_per_ocpu_in_gbps property of this DeploymentEnvironmentSummary.
        :type network_bandwidth_per_ocpu_in_gbps: int

        :param memory_per_ocpu_in_gbs:
            The value to assign to the memory_per_ocpu_in_gbs property of this DeploymentEnvironmentSummary.
        :type memory_per_ocpu_in_gbs: int

        :param storage_usage_limit_per_ocpu_in_gbs:
            The value to assign to the storage_usage_limit_per_ocpu_in_gbs property of this DeploymentEnvironmentSummary.
        :type storage_usage_limit_per_ocpu_in_gbs: int

        """
        self.swagger_types = {
            'environment_type': 'str',
            'category': 'str',
            'display_name': 'str',
            'min_cpu_core_count': 'int',
            'default_cpu_core_count': 'int',
            'max_cpu_core_count': 'int',
            'is_auto_scaling_enabled_by_default': 'bool',
            'network_bandwidth_per_ocpu_in_gbps': 'int',
            'memory_per_ocpu_in_gbs': 'int',
            'storage_usage_limit_per_ocpu_in_gbs': 'int'
        }

        self.attribute_map = {
            'environment_type': 'environmentType',
            'category': 'category',
            'display_name': 'displayName',
            'min_cpu_core_count': 'minCpuCoreCount',
            'default_cpu_core_count': 'defaultCpuCoreCount',
            'max_cpu_core_count': 'maxCpuCoreCount',
            'is_auto_scaling_enabled_by_default': 'isAutoScalingEnabledByDefault',
            'network_bandwidth_per_ocpu_in_gbps': 'networkBandwidthPerOcpuInGbps',
            'memory_per_ocpu_in_gbs': 'memoryPerOcpuInGBs',
            'storage_usage_limit_per_ocpu_in_gbs': 'storageUsageLimitPerOcpuInGBs'
        }

        self._environment_type = None
        self._category = None
        self._display_name = None
        self._min_cpu_core_count = None
        self._default_cpu_core_count = None
        self._max_cpu_core_count = None
        self._is_auto_scaling_enabled_by_default = None
        self._network_bandwidth_per_ocpu_in_gbps = None
        self._memory_per_ocpu_in_gbs = None
        self._storage_usage_limit_per_ocpu_in_gbs = None

    @property
    def environment_type(self):
        """
        **[Required]** Gets the environment_type of this DeploymentEnvironmentSummary.
        Specifies whether the deployment is used in a production or development/testing environment.

        Allowed values for this property are: "PRODUCTION", "DEVELOPMENT_OR_TESTING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The environment_type of this DeploymentEnvironmentSummary.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this DeploymentEnvironmentSummary.
        Specifies whether the deployment is used in a production or development/testing environment.


        :param environment_type: The environment_type of this DeploymentEnvironmentSummary.
        :type: str
        """
        allowed_values = ["PRODUCTION", "DEVELOPMENT_OR_TESTING"]
        if not value_allowed_none_or_none_sentinel(environment_type, allowed_values):
            environment_type = 'UNKNOWN_ENUM_VALUE'
        self._environment_type = environment_type

    @property
    def category(self):
        """
        **[Required]** Gets the category of this DeploymentEnvironmentSummary.
        The deployment category defines the broad separation of the deployment type into three categories.
        Currently the separation is 'DATA_REPLICATION', 'STREAM_ANALYTICS' and 'DATA_TRANSFORMS'.

        Allowed values for this property are: "DATA_REPLICATION", "STREAM_ANALYTICS", "DATA_TRANSFORMS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The category of this DeploymentEnvironmentSummary.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this DeploymentEnvironmentSummary.
        The deployment category defines the broad separation of the deployment type into three categories.
        Currently the separation is 'DATA_REPLICATION', 'STREAM_ANALYTICS' and 'DATA_TRANSFORMS'.


        :param category: The category of this DeploymentEnvironmentSummary.
        :type: str
        """
        allowed_values = ["DATA_REPLICATION", "STREAM_ANALYTICS", "DATA_TRANSFORMS"]
        if not value_allowed_none_or_none_sentinel(category, allowed_values):
            category = 'UNKNOWN_ENUM_VALUE'
        self._category = category

    @property
    def display_name(self):
        """
        Gets the display_name of this DeploymentEnvironmentSummary.
        An object's Display Name.


        :return: The display_name of this DeploymentEnvironmentSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DeploymentEnvironmentSummary.
        An object's Display Name.


        :param display_name: The display_name of this DeploymentEnvironmentSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def min_cpu_core_count(self):
        """
        **[Required]** Gets the min_cpu_core_count of this DeploymentEnvironmentSummary.
        The minimum CPU core count.


        :return: The min_cpu_core_count of this DeploymentEnvironmentSummary.
        :rtype: int
        """
        return self._min_cpu_core_count

    @min_cpu_core_count.setter
    def min_cpu_core_count(self, min_cpu_core_count):
        """
        Sets the min_cpu_core_count of this DeploymentEnvironmentSummary.
        The minimum CPU core count.


        :param min_cpu_core_count: The min_cpu_core_count of this DeploymentEnvironmentSummary.
        :type: int
        """
        self._min_cpu_core_count = min_cpu_core_count

    @property
    def default_cpu_core_count(self):
        """
        **[Required]** Gets the default_cpu_core_count of this DeploymentEnvironmentSummary.
        The default CPU core count.


        :return: The default_cpu_core_count of this DeploymentEnvironmentSummary.
        :rtype: int
        """
        return self._default_cpu_core_count

    @default_cpu_core_count.setter
    def default_cpu_core_count(self, default_cpu_core_count):
        """
        Sets the default_cpu_core_count of this DeploymentEnvironmentSummary.
        The default CPU core count.


        :param default_cpu_core_count: The default_cpu_core_count of this DeploymentEnvironmentSummary.
        :type: int
        """
        self._default_cpu_core_count = default_cpu_core_count

    @property
    def max_cpu_core_count(self):
        """
        **[Required]** Gets the max_cpu_core_count of this DeploymentEnvironmentSummary.
        The maximum CPU core count.


        :return: The max_cpu_core_count of this DeploymentEnvironmentSummary.
        :rtype: int
        """
        return self._max_cpu_core_count

    @max_cpu_core_count.setter
    def max_cpu_core_count(self, max_cpu_core_count):
        """
        Sets the max_cpu_core_count of this DeploymentEnvironmentSummary.
        The maximum CPU core count.


        :param max_cpu_core_count: The max_cpu_core_count of this DeploymentEnvironmentSummary.
        :type: int
        """
        self._max_cpu_core_count = max_cpu_core_count

    @property
    def is_auto_scaling_enabled_by_default(self):
        """
        **[Required]** Gets the is_auto_scaling_enabled_by_default of this DeploymentEnvironmentSummary.
        Specifies whether the \"Auto scaling\" option should be enabled by default or not.


        :return: The is_auto_scaling_enabled_by_default of this DeploymentEnvironmentSummary.
        :rtype: bool
        """
        return self._is_auto_scaling_enabled_by_default

    @is_auto_scaling_enabled_by_default.setter
    def is_auto_scaling_enabled_by_default(self, is_auto_scaling_enabled_by_default):
        """
        Sets the is_auto_scaling_enabled_by_default of this DeploymentEnvironmentSummary.
        Specifies whether the \"Auto scaling\" option should be enabled by default or not.


        :param is_auto_scaling_enabled_by_default: The is_auto_scaling_enabled_by_default of this DeploymentEnvironmentSummary.
        :type: bool
        """
        self._is_auto_scaling_enabled_by_default = is_auto_scaling_enabled_by_default

    @property
    def network_bandwidth_per_ocpu_in_gbps(self):
        """
        **[Required]** Gets the network_bandwidth_per_ocpu_in_gbps of this DeploymentEnvironmentSummary.
        The multiplier value between CPU core count and network bandwidth.


        :return: The network_bandwidth_per_ocpu_in_gbps of this DeploymentEnvironmentSummary.
        :rtype: int
        """
        return self._network_bandwidth_per_ocpu_in_gbps

    @network_bandwidth_per_ocpu_in_gbps.setter
    def network_bandwidth_per_ocpu_in_gbps(self, network_bandwidth_per_ocpu_in_gbps):
        """
        Sets the network_bandwidth_per_ocpu_in_gbps of this DeploymentEnvironmentSummary.
        The multiplier value between CPU core count and network bandwidth.


        :param network_bandwidth_per_ocpu_in_gbps: The network_bandwidth_per_ocpu_in_gbps of this DeploymentEnvironmentSummary.
        :type: int
        """
        self._network_bandwidth_per_ocpu_in_gbps = network_bandwidth_per_ocpu_in_gbps

    @property
    def memory_per_ocpu_in_gbs(self):
        """
        **[Required]** Gets the memory_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        The multiplier value between CPU core count and memory size.


        :return: The memory_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        :rtype: int
        """
        return self._memory_per_ocpu_in_gbs

    @memory_per_ocpu_in_gbs.setter
    def memory_per_ocpu_in_gbs(self, memory_per_ocpu_in_gbs):
        """
        Sets the memory_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        The multiplier value between CPU core count and memory size.


        :param memory_per_ocpu_in_gbs: The memory_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        :type: int
        """
        self._memory_per_ocpu_in_gbs = memory_per_ocpu_in_gbs

    @property
    def storage_usage_limit_per_ocpu_in_gbs(self):
        """
        **[Required]** Gets the storage_usage_limit_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        The multiplier value between CPU core count and storage usage limit size.


        :return: The storage_usage_limit_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        :rtype: int
        """
        return self._storage_usage_limit_per_ocpu_in_gbs

    @storage_usage_limit_per_ocpu_in_gbs.setter
    def storage_usage_limit_per_ocpu_in_gbs(self, storage_usage_limit_per_ocpu_in_gbs):
        """
        Sets the storage_usage_limit_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        The multiplier value between CPU core count and storage usage limit size.


        :param storage_usage_limit_per_ocpu_in_gbs: The storage_usage_limit_per_ocpu_in_gbs of this DeploymentEnvironmentSummary.
        :type: int
        """
        self._storage_usage_limit_per_ocpu_in_gbs = storage_usage_limit_per_ocpu_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
