# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .cohere_response_format import CohereResponseFormat
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereResponseJsonFormat(CohereResponseFormat):
    """
    The json object format for the model structured output
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereResponseJsonFormat object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereResponseJsonFormat.type` attribute
        of this class is ``JSON_OBJECT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CohereResponseJsonFormat.
            Allowed values for this property are: "JSON_OBJECT", "TEXT"
        :type type: str

        :param schema:
            The value to assign to the schema property of this CohereResponseJsonFormat.
        :type schema: object

        """
        self.swagger_types = {
            'type': 'str',
            'schema': 'object'
        }

        self.attribute_map = {
            'type': 'type',
            'schema': 'schema'
        }

        self._type = None
        self._schema = None
        self._type = 'JSON_OBJECT'

    @property
    def schema(self):
        """
        Gets the schema of this CohereResponseJsonFormat.
        The schema used by the structured output, described as a JSON Schema object.


        :return: The schema of this CohereResponseJsonFormat.
        :rtype: object
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this CohereResponseJsonFormat.
        The schema used by the structured output, described as a JSON Schema object.


        :param schema: The schema of this CohereResponseJsonFormat.
        :type: object
        """
        self._schema = schema

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
