# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from __future__ import absolute_import

from .assistant_message import AssistantMessage
from .base_chat_request import BaseChatRequest
from .base_chat_response import BaseChatResponse
from .chat_choice import ChatChoice
from .chat_content import ChatContent
from .chat_details import ChatDetails
from .chat_result import ChatResult
from .choice import Choice
from .citation import Citation
from .cohere_chat_bot_message import CohereChatBotMessage
from .cohere_chat_request import CohereChatRequest
from .cohere_chat_response import CohereChatResponse
from .cohere_llm_inference_request import CohereLlmInferenceRequest
from .cohere_llm_inference_response import CohereLlmInferenceResponse
from .cohere_message import CohereMessage
from .cohere_parameter_definition import CohereParameterDefinition
from .cohere_response_format import CohereResponseFormat
from .cohere_response_json_format import CohereResponseJsonFormat
from .cohere_response_text_format import CohereResponseTextFormat
from .cohere_system_message import CohereSystemMessage
from .cohere_tool import CohereTool
from .cohere_tool_call import CohereToolCall
from .cohere_tool_message import CohereToolMessage
from .cohere_tool_result import CohereToolResult
from .cohere_user_message import CohereUserMessage
from .dedicated_serving_mode import DedicatedServingMode
from .embed_text_details import EmbedTextDetails
from .embed_text_result import EmbedTextResult
from .generate_text_details import GenerateTextDetails
from .generate_text_result import GenerateTextResult
from .generated_text import GeneratedText
from .generic_chat_request import GenericChatRequest
from .generic_chat_response import GenericChatResponse
from .image_content import ImageContent
from .image_url import ImageUrl
from .llama_llm_inference_request import LlamaLlmInferenceRequest
from .llama_llm_inference_response import LlamaLlmInferenceResponse
from .llm_inference_request import LlmInferenceRequest
from .llm_inference_response import LlmInferenceResponse
from .logprobs import Logprobs
from .message import Message
from .on_demand_serving_mode import OnDemandServingMode
from .search_query import SearchQuery
from .serving_mode import ServingMode
from .summarize_text_details import SummarizeTextDetails
from .summarize_text_result import SummarizeTextResult
from .system_message import SystemMessage
from .text_content import TextContent
from .token_likelihood import TokenLikelihood
from .user_message import UserMessage

# Maps type names to classes for generative_ai_inference services.
generative_ai_inference_type_mapping = {
    "AssistantMessage": AssistantMessage,
    "BaseChatRequest": BaseChatRequest,
    "BaseChatResponse": BaseChatResponse,
    "ChatChoice": ChatChoice,
    "ChatContent": ChatContent,
    "ChatDetails": ChatDetails,
    "ChatResult": ChatResult,
    "Choice": Choice,
    "Citation": Citation,
    "CohereChatBotMessage": CohereChatBotMessage,
    "CohereChatRequest": CohereChatRequest,
    "CohereChatResponse": CohereChatResponse,
    "CohereLlmInferenceRequest": CohereLlmInferenceRequest,
    "CohereLlmInferenceResponse": CohereLlmInferenceResponse,
    "CohereMessage": CohereMessage,
    "CohereParameterDefinition": CohereParameterDefinition,
    "CohereResponseFormat": CohereResponseFormat,
    "CohereResponseJsonFormat": CohereResponseJsonFormat,
    "CohereResponseTextFormat": CohereResponseTextFormat,
    "CohereSystemMessage": CohereSystemMessage,
    "CohereTool": CohereTool,
    "CohereToolCall": CohereToolCall,
    "CohereToolMessage": CohereToolMessage,
    "CohereToolResult": CohereToolResult,
    "CohereUserMessage": CohereUserMessage,
    "DedicatedServingMode": DedicatedServingMode,
    "EmbedTextDetails": EmbedTextDetails,
    "EmbedTextResult": EmbedTextResult,
    "GenerateTextDetails": GenerateTextDetails,
    "GenerateTextResult": GenerateTextResult,
    "GeneratedText": GeneratedText,
    "GenericChatRequest": GenericChatRequest,
    "GenericChatResponse": GenericChatResponse,
    "ImageContent": ImageContent,
    "ImageUrl": ImageUrl,
    "LlamaLlmInferenceRequest": LlamaLlmInferenceRequest,
    "LlamaLlmInferenceResponse": LlamaLlmInferenceResponse,
    "LlmInferenceRequest": LlmInferenceRequest,
    "LlmInferenceResponse": LlmInferenceResponse,
    "Logprobs": Logprobs,
    "Message": Message,
    "OnDemandServingMode": OnDemandServingMode,
    "SearchQuery": SearchQuery,
    "ServingMode": ServingMode,
    "SummarizeTextDetails": SummarizeTextDetails,
    "SummarizeTextResult": SummarizeTextResult,
    "SystemMessage": SystemMessage,
    "TextContent": TextContent,
    "TokenLikelihood": TokenLikelihood,
    "UserMessage": UserMessage
}
