# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .trace import Trace
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RetrievalTrace(Trace):
    """
    The trace that displays the retrieval information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RetrievalTrace object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.RetrievalTrace.trace_type` attribute
        of this class is ``RETRIEVAL_TRACE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_created:
            The value to assign to the time_created property of this RetrievalTrace.
        :type time_created: datetime

        :param trace_type:
            The value to assign to the trace_type property of this RetrievalTrace.
            Allowed values for this property are: "ERROR_TRACE", "RETRIEVAL_TRACE", "GENERATION_TRACE"
        :type trace_type: str

        :param retrieval_input:
            The value to assign to the retrieval_input property of this RetrievalTrace.
        :type retrieval_input: str

        :param citations:
            The value to assign to the citations property of this RetrievalTrace.
        :type citations: list[oci.generative_ai_agent_runtime.models.Citation]

        """
        self.swagger_types = {
            'time_created': 'datetime',
            'trace_type': 'str',
            'retrieval_input': 'str',
            'citations': 'list[Citation]'
        }

        self.attribute_map = {
            'time_created': 'timeCreated',
            'trace_type': 'traceType',
            'retrieval_input': 'retrievalInput',
            'citations': 'citations'
        }

        self._time_created = None
        self._trace_type = None
        self._retrieval_input = None
        self._citations = None
        self._trace_type = 'RETRIEVAL_TRACE'

    @property
    def retrieval_input(self):
        """
        Gets the retrieval_input of this RetrievalTrace.
        The agent's search string for getting the displayed information.


        :return: The retrieval_input of this RetrievalTrace.
        :rtype: str
        """
        return self._retrieval_input

    @retrieval_input.setter
    def retrieval_input(self, retrieval_input):
        """
        Sets the retrieval_input of this RetrievalTrace.
        The agent's search string for getting the displayed information.


        :param retrieval_input: The retrieval_input of this RetrievalTrace.
        :type: str
        """
        self._retrieval_input = retrieval_input

    @property
    def citations(self):
        """
        Gets the citations of this RetrievalTrace.
        A list of citations retrieved from data sources.


        :return: The citations of this RetrievalTrace.
        :rtype: list[oci.generative_ai_agent_runtime.models.Citation]
        """
        return self._citations

    @citations.setter
    def citations(self, citations):
        """
        Sets the citations of this RetrievalTrace.
        A list of citations retrieved from data sources.


        :param citations: The citations of this RetrievalTrace.
        :type: list[oci.generative_ai_agent_runtime.models.Citation]
        """
        self._citations = citations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
