# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .source_location import SourceLocation
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciObjectStorageSourceLocation(SourceLocation):
    """
    The OCI Object Storage that contains the data files.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciObjectStorageSourceLocation object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.OciObjectStorageSourceLocation.source_location_type` attribute
        of this class is ``OCI_OBJECT_STORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_location_type:
            The value to assign to the source_location_type property of this OciObjectStorageSourceLocation.
            Allowed values for this property are: "OCI_OBJECT_STORAGE", "OCI_OPEN_SEARCH", "OCI_DATABASE"
        :type source_location_type: str

        :param url:
            The value to assign to the url property of this OciObjectStorageSourceLocation.
        :type url: str

        """
        self.swagger_types = {
            'source_location_type': 'str',
            'url': 'str'
        }

        self.attribute_map = {
            'source_location_type': 'sourceLocationType',
            'url': 'url'
        }

        self._source_location_type = None
        self._url = None
        self._source_location_type = 'OCI_OBJECT_STORAGE'

    @property
    def url(self):
        """
        Gets the url of this OciObjectStorageSourceLocation.
        The URL of the OCI Object Storage data source.


        :return: The url of this OciObjectStorageSourceLocation.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this OciObjectStorageSourceLocation.
        The URL of the OCI Object Storage data source.


        :param url: The url of this OciObjectStorageSourceLocation.
        :type: str
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
