# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Citation(object):
    """
    The citation displays the location of source text that is the agent uses to create the responses.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Citation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_text:
            The value to assign to the source_text property of this Citation.
        :type source_text: str

        :param source_location:
            The value to assign to the source_location property of this Citation.
        :type source_location: oci.generative_ai_agent_runtime.models.SourceLocation

        """
        self.swagger_types = {
            'source_text': 'str',
            'source_location': 'SourceLocation'
        }

        self.attribute_map = {
            'source_text': 'sourceText',
            'source_location': 'sourceLocation'
        }

        self._source_text = None
        self._source_location = None

    @property
    def source_text(self):
        """
        Gets the source_text of this Citation.
        The text that's the source for the agent's response.


        :return: The source_text of this Citation.
        :rtype: str
        """
        return self._source_text

    @source_text.setter
    def source_text(self, source_text):
        """
        Sets the source_text of this Citation.
        The text that's the source for the agent's response.


        :param source_text: The source_text of this Citation.
        :type: str
        """
        self._source_text = source_text

    @property
    def source_location(self):
        """
        Gets the source_location of this Citation.

        :return: The source_location of this Citation.
        :rtype: oci.generative_ai_agent_runtime.models.SourceLocation
        """
        return self._source_location

    @source_location.setter
    def source_location(self, source_location):
        """
        Sets the source_location of this Citation.

        :param source_location: The source_location of this Citation.
        :type: oci.generative_ai_agent_runtime.models.SourceLocation
        """
        self._source_location = source_location

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
