# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChatDetails(object):
    """
    Chat details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChatDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param user_message:
            The value to assign to the user_message property of this ChatDetails.
        :type user_message: str

        :param should_stream:
            The value to assign to the should_stream property of this ChatDetails.
        :type should_stream: bool

        :param session_id:
            The value to assign to the session_id property of this ChatDetails.
        :type session_id: str

        """
        self.swagger_types = {
            'user_message': 'str',
            'should_stream': 'bool',
            'session_id': 'str'
        }

        self.attribute_map = {
            'user_message': 'userMessage',
            'should_stream': 'shouldStream',
            'session_id': 'sessionId'
        }

        self._user_message = None
        self._should_stream = None
        self._session_id = None

    @property
    def user_message(self):
        """
        **[Required]** Gets the user_message of this ChatDetails.
        The input user message content for the chat.


        :return: The user_message of this ChatDetails.
        :rtype: str
        """
        return self._user_message

    @user_message.setter
    def user_message(self, user_message):
        """
        Sets the user_message of this ChatDetails.
        The input user message content for the chat.


        :param user_message: The user_message of this ChatDetails.
        :type: str
        """
        self._user_message = user_message

    @property
    def should_stream(self):
        """
        Gets the should_stream of this ChatDetails.
        Whether to stream the response.


        :return: The should_stream of this ChatDetails.
        :rtype: bool
        """
        return self._should_stream

    @should_stream.setter
    def should_stream(self, should_stream):
        """
        Sets the should_stream of this ChatDetails.
        Whether to stream the response.


        :param should_stream: The should_stream of this ChatDetails.
        :type: bool
        """
        self._should_stream = should_stream

    @property
    def session_id(self):
        """
        Gets the session_id of this ChatDetails.
        Optional sessionId. If not provided, will chat without any prior context.


        :return: The session_id of this ChatDetails.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this ChatDetails.
        Optional sessionId. If not provided, will chat without any prior context.


        :param session_id: The session_id of this ChatDetails.
        :type: str
        """
        self._session_id = session_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
