# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataIngestionJobStatistics(object):
    """
    **DataIngestionJobStatistics**

    The statistics of data ingestion job.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataIngestionJobStatistics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param number_of_failed_files:
            The value to assign to the number_of_failed_files property of this DataIngestionJobStatistics.
        :type number_of_failed_files: int

        :param number_of_ingested_files:
            The value to assign to the number_of_ingested_files property of this DataIngestionJobStatistics.
        :type number_of_ingested_files: int

        :param duration_in_seconds:
            The value to assign to the duration_in_seconds property of this DataIngestionJobStatistics.
        :type duration_in_seconds: int

        """
        self.swagger_types = {
            'number_of_failed_files': 'int',
            'number_of_ingested_files': 'int',
            'duration_in_seconds': 'int'
        }

        self.attribute_map = {
            'number_of_failed_files': 'numberOfFailedFiles',
            'number_of_ingested_files': 'numberOfIngestedFiles',
            'duration_in_seconds': 'durationInSeconds'
        }

        self._number_of_failed_files = None
        self._number_of_ingested_files = None
        self._duration_in_seconds = None

    @property
    def number_of_failed_files(self):
        """
        Gets the number_of_failed_files of this DataIngestionJobStatistics.
        The number of files that have failed during the ingestion.


        :return: The number_of_failed_files of this DataIngestionJobStatistics.
        :rtype: int
        """
        return self._number_of_failed_files

    @number_of_failed_files.setter
    def number_of_failed_files(self, number_of_failed_files):
        """
        Sets the number_of_failed_files of this DataIngestionJobStatistics.
        The number of files that have failed during the ingestion.


        :param number_of_failed_files: The number_of_failed_files of this DataIngestionJobStatistics.
        :type: int
        """
        self._number_of_failed_files = number_of_failed_files

    @property
    def number_of_ingested_files(self):
        """
        Gets the number_of_ingested_files of this DataIngestionJobStatistics.
        The number of files that have been successfully ingested during the ingestion.


        :return: The number_of_ingested_files of this DataIngestionJobStatistics.
        :rtype: int
        """
        return self._number_of_ingested_files

    @number_of_ingested_files.setter
    def number_of_ingested_files(self, number_of_ingested_files):
        """
        Sets the number_of_ingested_files of this DataIngestionJobStatistics.
        The number of files that have been successfully ingested during the ingestion.


        :param number_of_ingested_files: The number_of_ingested_files of this DataIngestionJobStatistics.
        :type: int
        """
        self._number_of_ingested_files = number_of_ingested_files

    @property
    def duration_in_seconds(self):
        """
        Gets the duration_in_seconds of this DataIngestionJobStatistics.
        The duration of this ingestion job.


        :return: The duration_in_seconds of this DataIngestionJobStatistics.
        :rtype: int
        """
        return self._duration_in_seconds

    @duration_in_seconds.setter
    def duration_in_seconds(self, duration_in_seconds):
        """
        Sets the duration_in_seconds of this DataIngestionJobStatistics.
        The duration of this ingestion job.


        :param duration_in_seconds: The duration_in_seconds of this DataIngestionJobStatistics.
        :type: int
        """
        self._duration_in_seconds = duration_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
