# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAgentDetails(object):
    """
    **CreateAgentDetails**

    The data to create an agent.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAgentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateAgentDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateAgentDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateAgentDetails.
        :type compartment_id: str

        :param knowledge_base_ids:
            The value to assign to the knowledge_base_ids property of this CreateAgentDetails.
        :type knowledge_base_ids: list[str]

        :param welcome_message:
            The value to assign to the welcome_message property of this CreateAgentDetails.
        :type welcome_message: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAgentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAgentDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'knowledge_base_ids': 'list[str]',
            'welcome_message': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'knowledge_base_ids': 'knowledgeBaseIds',
            'welcome_message': 'welcomeMessage',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._knowledge_base_ids = None
        self._welcome_message = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateAgentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateAgentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateAgentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateAgentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateAgentDetails.
        Description about the agent.


        :return: The description of this CreateAgentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateAgentDetails.
        Description about the agent.


        :param description: The description of this CreateAgentDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateAgentDetails.
        The `OCID`__ of the compartment to create the agent in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateAgentDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateAgentDetails.
        The `OCID`__ of the compartment to create the agent in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateAgentDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def knowledge_base_ids(self):
        """
        Gets the knowledge_base_ids of this CreateAgentDetails.
        List of `OCID`__ of the knowledgeBases associated with agent.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_ids of this CreateAgentDetails.
        :rtype: list[str]
        """
        return self._knowledge_base_ids

    @knowledge_base_ids.setter
    def knowledge_base_ids(self, knowledge_base_ids):
        """
        Sets the knowledge_base_ids of this CreateAgentDetails.
        List of `OCID`__ of the knowledgeBases associated with agent.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param knowledge_base_ids: The knowledge_base_ids of this CreateAgentDetails.
        :type: list[str]
        """
        self._knowledge_base_ids = knowledge_base_ids

    @property
    def welcome_message(self):
        """
        Gets the welcome_message of this CreateAgentDetails.
        Details about purpose and responsibility of the agent


        :return: The welcome_message of this CreateAgentDetails.
        :rtype: str
        """
        return self._welcome_message

    @welcome_message.setter
    def welcome_message(self, welcome_message):
        """
        Sets the welcome_message of this CreateAgentDetails.
        Details about purpose and responsibility of the agent


        :param welcome_message: The welcome_message of this CreateAgentDetails.
        :type: str
        """
        self._welcome_message = welcome_message

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAgentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateAgentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAgentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateAgentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAgentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateAgentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAgentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateAgentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
