# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from __future__ import absolute_import

from .agent import Agent
from .agent_collection import AgentCollection
from .agent_endpoint import AgentEndpoint
from .agent_endpoint_collection import AgentEndpointCollection
from .agent_endpoint_summary import AgentEndpointSummary
from .agent_summary import AgentSummary
from .basic_auth_secret import BasicAuthSecret
from .change_agent_compartment_details import ChangeAgentCompartmentDetails
from .change_agent_endpoint_compartment_details import ChangeAgentEndpointCompartmentDetails
from .change_knowledge_base_compartment_details import ChangeKnowledgeBaseCompartmentDetails
from .content_moderation_config import ContentModerationConfig
from .create_agent_details import CreateAgentDetails
from .create_agent_endpoint_details import CreateAgentEndpointDetails
from .create_data_ingestion_job_details import CreateDataIngestionJobDetails
from .create_data_source_details import CreateDataSourceDetails
from .create_knowledge_base_details import CreateKnowledgeBaseDetails
from .data_ingestion_job import DataIngestionJob
from .data_ingestion_job_collection import DataIngestionJobCollection
from .data_ingestion_job_statistics import DataIngestionJobStatistics
from .data_ingestion_job_summary import DataIngestionJobSummary
from .data_source import DataSource
from .data_source_collection import DataSourceCollection
from .data_source_config import DataSourceConfig
from .data_source_summary import DataSourceSummary
from .database_connection import DatabaseConnection
from .database_function import DatabaseFunction
from .database_tool_connection import DatabaseToolConnection
from .default_index_config import DefaultIndexConfig
from .idcs_secret import IdcsSecret
from .index import Index
from .index_config import IndexConfig
from .index_schema import IndexSchema
from .knowledge_base import KnowledgeBase
from .knowledge_base_collection import KnowledgeBaseCollection
from .knowledge_base_summary import KnowledgeBaseSummary
from .object_storage_prefix import ObjectStoragePrefix
from .oci_database_config import OciDatabaseConfig
from .oci_object_storage_data_source_config import OciObjectStorageDataSourceConfig
from .oci_open_search_index_config import OciOpenSearchIndexConfig
from .secret_detail import SecretDetail
from .session_config import SessionConfig
from .update_agent_details import UpdateAgentDetails
from .update_agent_endpoint_details import UpdateAgentEndpointDetails
from .update_data_source_details import UpdateDataSourceDetails
from .update_knowledge_base_details import UpdateKnowledgeBaseDetails
from .work_request import WorkRequest
from .work_request_error import WorkRequestError
from .work_request_error_collection import WorkRequestErrorCollection
from .work_request_log_entry import WorkRequestLogEntry
from .work_request_log_entry_collection import WorkRequestLogEntryCollection
from .work_request_resource import WorkRequestResource
from .work_request_summary import WorkRequestSummary
from .work_request_summary_collection import WorkRequestSummaryCollection

# Maps type names to classes for generative_ai_agent services.
generative_ai_agent_type_mapping = {
    "Agent": Agent,
    "AgentCollection": AgentCollection,
    "AgentEndpoint": AgentEndpoint,
    "AgentEndpointCollection": AgentEndpointCollection,
    "AgentEndpointSummary": AgentEndpointSummary,
    "AgentSummary": AgentSummary,
    "BasicAuthSecret": BasicAuthSecret,
    "ChangeAgentCompartmentDetails": ChangeAgentCompartmentDetails,
    "ChangeAgentEndpointCompartmentDetails": ChangeAgentEndpointCompartmentDetails,
    "ChangeKnowledgeBaseCompartmentDetails": ChangeKnowledgeBaseCompartmentDetails,
    "ContentModerationConfig": ContentModerationConfig,
    "CreateAgentDetails": CreateAgentDetails,
    "CreateAgentEndpointDetails": CreateAgentEndpointDetails,
    "CreateDataIngestionJobDetails": CreateDataIngestionJobDetails,
    "CreateDataSourceDetails": CreateDataSourceDetails,
    "CreateKnowledgeBaseDetails": CreateKnowledgeBaseDetails,
    "DataIngestionJob": DataIngestionJob,
    "DataIngestionJobCollection": DataIngestionJobCollection,
    "DataIngestionJobStatistics": DataIngestionJobStatistics,
    "DataIngestionJobSummary": DataIngestionJobSummary,
    "DataSource": DataSource,
    "DataSourceCollection": DataSourceCollection,
    "DataSourceConfig": DataSourceConfig,
    "DataSourceSummary": DataSourceSummary,
    "DatabaseConnection": DatabaseConnection,
    "DatabaseFunction": DatabaseFunction,
    "DatabaseToolConnection": DatabaseToolConnection,
    "DefaultIndexConfig": DefaultIndexConfig,
    "IdcsSecret": IdcsSecret,
    "Index": Index,
    "IndexConfig": IndexConfig,
    "IndexSchema": IndexSchema,
    "KnowledgeBase": KnowledgeBase,
    "KnowledgeBaseCollection": KnowledgeBaseCollection,
    "KnowledgeBaseSummary": KnowledgeBaseSummary,
    "ObjectStoragePrefix": ObjectStoragePrefix,
    "OciDatabaseConfig": OciDatabaseConfig,
    "OciObjectStorageDataSourceConfig": OciObjectStorageDataSourceConfig,
    "OciOpenSearchIndexConfig": OciOpenSearchIndexConfig,
    "SecretDetail": SecretDetail,
    "SessionConfig": SessionConfig,
    "UpdateAgentDetails": UpdateAgentDetails,
    "UpdateAgentEndpointDetails": UpdateAgentEndpointDetails,
    "UpdateDataSourceDetails": UpdateDataSourceDetails,
    "UpdateKnowledgeBaseDetails": UpdateKnowledgeBaseDetails,
    "WorkRequest": WorkRequest,
    "WorkRequestError": WorkRequestError,
    "WorkRequestErrorCollection": WorkRequestErrorCollection,
    "WorkRequestLogEntry": WorkRequestLogEntry,
    "WorkRequestLogEntryCollection": WorkRequestLogEntryCollection,
    "WorkRequestResource": WorkRequestResource,
    "WorkRequestSummary": WorkRequestSummary,
    "WorkRequestSummaryCollection": WorkRequestSummaryCollection
}
