# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateFsuCycleDetails(object):
    """
    Update Exadata Fleet Update Cycle resource details.
    """

    #: A constant which can be used with the type property of a UpdateFsuCycleDetails.
    #: This constant has a value of "PATCH"
    TYPE_PATCH = "PATCH"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateFsuCycleDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.UpdatePatchFsuCycle`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateFsuCycleDetails.
        :type display_name: str

        :param type:
            The value to assign to the type property of this UpdateFsuCycleDetails.
            Allowed values for this property are: "PATCH"
        :type type: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this UpdateFsuCycleDetails.
        :type goal_version_details: oci.fleet_software_update.models.FsuGoalVersionDetails

        :param batching_strategy:
            The value to assign to the batching_strategy property of this UpdateFsuCycleDetails.
        :type batching_strategy: oci.fleet_software_update.models.UpdateBatchingStrategyDetails

        :param diagnostics_collection:
            The value to assign to the diagnostics_collection property of this UpdateFsuCycleDetails.
        :type diagnostics_collection: oci.fleet_software_update.models.DiagnosticsCollectionDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateFsuCycleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateFsuCycleDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'type': 'str',
            'goal_version_details': 'FsuGoalVersionDetails',
            'batching_strategy': 'UpdateBatchingStrategyDetails',
            'diagnostics_collection': 'DiagnosticsCollectionDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'type': 'type',
            'goal_version_details': 'goalVersionDetails',
            'batching_strategy': 'batchingStrategy',
            'diagnostics_collection': 'diagnosticsCollection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._type = None
        self._goal_version_details = None
        self._batching_strategy = None
        self._diagnostics_collection = None
        self._freeform_tags = None
        self._defined_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'PATCH':
            return 'UpdatePatchFsuCycle'
        else:
            return 'UpdateFsuCycleDetails'

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateFsuCycleDetails.
        Exadata Fleet Update Cycle display name.


        :return: The display_name of this UpdateFsuCycleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateFsuCycleDetails.
        Exadata Fleet Update Cycle display name.


        :param display_name: The display_name of this UpdateFsuCycleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this UpdateFsuCycleDetails.
        Type of Exadata Fleet Update Cycle to update.
        This will not change the Maintenance Cycle type, it is to define the set of properties that can be updated depending on the Cycle type.
        Type value should match the Maintenance Cycle type.

        Allowed values for this property are: "PATCH"


        :return: The type of this UpdateFsuCycleDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this UpdateFsuCycleDetails.
        Type of Exadata Fleet Update Cycle to update.
        This will not change the Maintenance Cycle type, it is to define the set of properties that can be updated depending on the Cycle type.
        Type value should match the Maintenance Cycle type.


        :param type: The type of this UpdateFsuCycleDetails.
        :type: str
        """
        allowed_values = ["PATCH"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def goal_version_details(self):
        """
        Gets the goal_version_details of this UpdateFsuCycleDetails.

        :return: The goal_version_details of this UpdateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.FsuGoalVersionDetails
        """
        return self._goal_version_details

    @goal_version_details.setter
    def goal_version_details(self, goal_version_details):
        """
        Sets the goal_version_details of this UpdateFsuCycleDetails.

        :param goal_version_details: The goal_version_details of this UpdateFsuCycleDetails.
        :type: oci.fleet_software_update.models.FsuGoalVersionDetails
        """
        self._goal_version_details = goal_version_details

    @property
    def batching_strategy(self):
        """
        Gets the batching_strategy of this UpdateFsuCycleDetails.

        :return: The batching_strategy of this UpdateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.UpdateBatchingStrategyDetails
        """
        return self._batching_strategy

    @batching_strategy.setter
    def batching_strategy(self, batching_strategy):
        """
        Sets the batching_strategy of this UpdateFsuCycleDetails.

        :param batching_strategy: The batching_strategy of this UpdateFsuCycleDetails.
        :type: oci.fleet_software_update.models.UpdateBatchingStrategyDetails
        """
        self._batching_strategy = batching_strategy

    @property
    def diagnostics_collection(self):
        """
        Gets the diagnostics_collection of this UpdateFsuCycleDetails.

        :return: The diagnostics_collection of this UpdateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.DiagnosticsCollectionDetails
        """
        return self._diagnostics_collection

    @diagnostics_collection.setter
    def diagnostics_collection(self, diagnostics_collection):
        """
        Sets the diagnostics_collection of this UpdateFsuCycleDetails.

        :param diagnostics_collection: The diagnostics_collection of this UpdateFsuCycleDetails.
        :type: oci.fleet_software_update.models.DiagnosticsCollectionDetails
        """
        self._diagnostics_collection = diagnostics_collection

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateFsuCycleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateFsuCycleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateFsuCycleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateFsuCycleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateFsuCycleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateFsuCycleDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateFsuCycleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateFsuCycleDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
