# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .db_fleet_discovery_filter import DbFleetDiscoveryFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbHomeNameFilter(DbFleetDiscoveryFilter):
    """
    Database home name to include in the discovery.
    '*' Wildcard is allowed for 'startsWith' or 'endsWith' filtering.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbHomeNameFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.DbHomeNameFilter.type` attribute
        of this class is ``DB_HOME_NAME`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DbHomeNameFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "DB_NAME", "DB_UNIQUE_NAME", "DB_HOME_NAME", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID"
        :type type: str

        :param mode:
            The value to assign to the mode property of this DbHomeNameFilter.
            Allowed values for this property are: "INCLUDE", "EXCLUDE"
        :type mode: str

        :param names:
            The value to assign to the names property of this DbHomeNameFilter.
        :type names: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'mode': 'str',
            'names': 'list[str]'
        }

        self.attribute_map = {
            'type': 'type',
            'mode': 'mode',
            'names': 'names'
        }

        self._type = None
        self._mode = None
        self._names = None
        self._type = 'DB_HOME_NAME'

    @property
    def names(self):
        """
        **[Required]** Gets the names of this DbHomeNameFilter.
        List of Database home names to include in the discovery.


        :return: The names of this DbHomeNameFilter.
        :rtype: list[str]
        """
        return self._names

    @names.setter
    def names(self, names):
        """
        Sets the names of this DbHomeNameFilter.
        List of Database home names to include in the discovery.


        :param names: The names of this DbHomeNameFilter.
        :type: list[str]
        """
        self._names = names

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
