# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TaskNotificationPreferences(object):
    """
    Preferences to send notifications on the task activities.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TaskNotificationPreferences object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param should_notify_on_pause:
            The value to assign to the should_notify_on_pause property of this TaskNotificationPreferences.
        :type should_notify_on_pause: bool

        :param should_notify_on_task_failure:
            The value to assign to the should_notify_on_task_failure property of this TaskNotificationPreferences.
        :type should_notify_on_task_failure: bool

        :param should_notify_on_task_success:
            The value to assign to the should_notify_on_task_success property of this TaskNotificationPreferences.
        :type should_notify_on_task_success: bool

        """
        self.swagger_types = {
            'should_notify_on_pause': 'bool',
            'should_notify_on_task_failure': 'bool',
            'should_notify_on_task_success': 'bool'
        }

        self.attribute_map = {
            'should_notify_on_pause': 'shouldNotifyOnPause',
            'should_notify_on_task_failure': 'shouldNotifyOnTaskFailure',
            'should_notify_on_task_success': 'shouldNotifyOnTaskSuccess'
        }

        self._should_notify_on_pause = None
        self._should_notify_on_task_failure = None
        self._should_notify_on_task_success = None

    @property
    def should_notify_on_pause(self):
        """
        Gets the should_notify_on_pause of this TaskNotificationPreferences.
        Enables notification on pause.


        :return: The should_notify_on_pause of this TaskNotificationPreferences.
        :rtype: bool
        """
        return self._should_notify_on_pause

    @should_notify_on_pause.setter
    def should_notify_on_pause(self, should_notify_on_pause):
        """
        Sets the should_notify_on_pause of this TaskNotificationPreferences.
        Enables notification on pause.


        :param should_notify_on_pause: The should_notify_on_pause of this TaskNotificationPreferences.
        :type: bool
        """
        self._should_notify_on_pause = should_notify_on_pause

    @property
    def should_notify_on_task_failure(self):
        """
        Gets the should_notify_on_task_failure of this TaskNotificationPreferences.
        Enables or disables notification on Task Failures.


        :return: The should_notify_on_task_failure of this TaskNotificationPreferences.
        :rtype: bool
        """
        return self._should_notify_on_task_failure

    @should_notify_on_task_failure.setter
    def should_notify_on_task_failure(self, should_notify_on_task_failure):
        """
        Sets the should_notify_on_task_failure of this TaskNotificationPreferences.
        Enables or disables notification on Task Failures.


        :param should_notify_on_task_failure: The should_notify_on_task_failure of this TaskNotificationPreferences.
        :type: bool
        """
        self._should_notify_on_task_failure = should_notify_on_task_failure

    @property
    def should_notify_on_task_success(self):
        """
        Gets the should_notify_on_task_success of this TaskNotificationPreferences.
        Enables or disables notification on Task Success.


        :return: The should_notify_on_task_success of this TaskNotificationPreferences.
        :rtype: bool
        """
        return self._should_notify_on_task_success

    @should_notify_on_task_success.setter
    def should_notify_on_task_success(self, should_notify_on_task_success):
        """
        Sets the should_notify_on_task_success of this TaskNotificationPreferences.
        Enables or disables notification on Task Success.


        :param should_notify_on_task_success: The should_notify_on_task_success of this TaskNotificationPreferences.
        :type: bool
        """
        self._should_notify_on_task_success = should_notify_on_task_success

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
