# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Schedule(object):
    """
    Schedule Information.
    """

    #: A constant which can be used with the type property of a Schedule.
    #: This constant has a value of "CUSTOM"
    TYPE_CUSTOM = "CUSTOM"

    #: A constant which can be used with the type property of a Schedule.
    #: This constant has a value of "MAINTENANCE_WINDOW"
    TYPE_MAINTENANCE_WINDOW = "MAINTENANCE_WINDOW"

    def __init__(self, **kwargs):
        """
        Initializes a new Schedule object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this Schedule.
            Allowed values for this property are: "CUSTOM", "MAINTENANCE_WINDOW", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param execution_startdate:
            The value to assign to the execution_startdate property of this Schedule.
        :type execution_startdate: datetime

        :param maintenance_window_id:
            The value to assign to the maintenance_window_id property of this Schedule.
        :type maintenance_window_id: str

        :param recurrences:
            The value to assign to the recurrences property of this Schedule.
        :type recurrences: str

        :param duration:
            The value to assign to the duration property of this Schedule.
        :type duration: str

        """
        self.swagger_types = {
            'type': 'str',
            'execution_startdate': 'datetime',
            'maintenance_window_id': 'str',
            'recurrences': 'str',
            'duration': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'execution_startdate': 'executionStartdate',
            'maintenance_window_id': 'maintenanceWindowId',
            'recurrences': 'recurrences',
            'duration': 'duration'
        }

        self._type = None
        self._execution_startdate = None
        self._maintenance_window_id = None
        self._recurrences = None
        self._duration = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this Schedule.
        Schedule Type

        Allowed values for this property are: "CUSTOM", "MAINTENANCE_WINDOW", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this Schedule.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Schedule.
        Schedule Type


        :param type: The type of this Schedule.
        :type: str
        """
        allowed_values = ["CUSTOM", "MAINTENANCE_WINDOW"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def execution_startdate(self):
        """
        **[Required]** Gets the execution_startdate of this Schedule.
        Start Date for the schedule. An RFC3339 formatted datetime string


        :return: The execution_startdate of this Schedule.
        :rtype: datetime
        """
        return self._execution_startdate

    @execution_startdate.setter
    def execution_startdate(self, execution_startdate):
        """
        Sets the execution_startdate of this Schedule.
        Start Date for the schedule. An RFC3339 formatted datetime string


        :param execution_startdate: The execution_startdate of this Schedule.
        :type: datetime
        """
        self._execution_startdate = execution_startdate

    @property
    def maintenance_window_id(self):
        """
        Gets the maintenance_window_id of this Schedule.
        Provide MaintenanceWindowId if Schedule Type is Maintenance Window


        :return: The maintenance_window_id of this Schedule.
        :rtype: str
        """
        return self._maintenance_window_id

    @maintenance_window_id.setter
    def maintenance_window_id(self, maintenance_window_id):
        """
        Sets the maintenance_window_id of this Schedule.
        Provide MaintenanceWindowId if Schedule Type is Maintenance Window


        :param maintenance_window_id: The maintenance_window_id of this Schedule.
        :type: str
        """
        self._maintenance_window_id = maintenance_window_id

    @property
    def recurrences(self):
        """
        Gets the recurrences of this Schedule.
        Recurrence rule specification if Schedule Type is Custom and Recurring


        :return: The recurrences of this Schedule.
        :rtype: str
        """
        return self._recurrences

    @recurrences.setter
    def recurrences(self, recurrences):
        """
        Sets the recurrences of this Schedule.
        Recurrence rule specification if Schedule Type is Custom and Recurring


        :param recurrences: The recurrences of this Schedule.
        :type: str
        """
        self._recurrences = recurrences

    @property
    def duration(self):
        """
        Gets the duration of this Schedule.
        Duration if schedule type is Custom


        :return: The duration of this Schedule.
        :rtype: str
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """
        Sets the duration of this Schedule.
        Duration if schedule type is Custom


        :param duration: The duration of this Schedule.
        :type: str
        """
        self._duration = duration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
