# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831

from .artifact_details import ArtifactDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PlatformSpecificArtifactDetails(ArtifactDetails):
    """
    Patch artifact description and content details which is platform specific
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PlatformSpecificArtifactDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.PlatformSpecificArtifactDetails.category` attribute
        of this class is ``PLATFORM_SPECIFIC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param category:
            The value to assign to the category property of this PlatformSpecificArtifactDetails.
            Allowed values for this property are: "GENERIC", "PLATFORM_SPECIFIC"
        :type category: str

        :param artifacts:
            The value to assign to the artifacts property of this PlatformSpecificArtifactDetails.
        :type artifacts: list[oci.fleet_apps_management.models.PlatformSpecificArtifact]

        """
        self.swagger_types = {
            'category': 'str',
            'artifacts': 'list[PlatformSpecificArtifact]'
        }

        self.attribute_map = {
            'category': 'category',
            'artifacts': 'artifacts'
        }

        self._category = None
        self._artifacts = None
        self._category = 'PLATFORM_SPECIFIC'

    @property
    def artifacts(self):
        """
        **[Required]** Gets the artifacts of this PlatformSpecificArtifactDetails.
        Artifacts.


        :return: The artifacts of this PlatformSpecificArtifactDetails.
        :rtype: list[oci.fleet_apps_management.models.PlatformSpecificArtifact]
        """
        return self._artifacts

    @artifacts.setter
    def artifacts(self, artifacts):
        """
        Sets the artifacts of this PlatformSpecificArtifactDetails.
        Artifacts.


        :param artifacts: The artifacts of this PlatformSpecificArtifactDetails.
        :type: list[oci.fleet_apps_management.models.PlatformSpecificArtifact]
        """
        self._artifacts = artifacts

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
