# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831

from .patch_selection_details import PatchSelectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchNameSelectionDetails(PatchSelectionDetails):
    """
    Patch Name Details.
    If you set the policy rule by selecting this option, provide a specific patch name.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchNameSelectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.PatchNameSelectionDetails.selection_type` attribute
        of this class is ``PATCH_NAME`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param selection_type:
            The value to assign to the selection_type property of this PatchNameSelectionDetails.
            Allowed values for this property are: "PATCH_LEVEL", "PATCH_NAME", "PATCH_RELEASE_DATE"
        :type selection_type: str

        :param patch_name:
            The value to assign to the patch_name property of this PatchNameSelectionDetails.
        :type patch_name: str

        """
        self.swagger_types = {
            'selection_type': 'str',
            'patch_name': 'str'
        }

        self.attribute_map = {
            'selection_type': 'selectionType',
            'patch_name': 'patchName'
        }

        self._selection_type = None
        self._patch_name = None
        self._selection_type = 'PATCH_NAME'

    @property
    def patch_name(self):
        """
        **[Required]** Gets the patch_name of this PatchNameSelectionDetails.
        Patch Name.


        :return: The patch_name of this PatchNameSelectionDetails.
        :rtype: str
        """
        return self._patch_name

    @patch_name.setter
    def patch_name(self, patch_name):
        """
        Sets the patch_name of this PatchNameSelectionDetails.
        Patch Name.


        :param patch_name: The patch_name of this PatchNameSelectionDetails.
        :type: str
        """
        self._patch_name = patch_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
