# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831

from .artifact_details import ArtifactDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericArtifactDetails(ArtifactDetails):
    """
    Patch artifact description and content details if common for all platforms.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenericArtifactDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.GenericArtifactDetails.category` attribute
        of this class is ``GENERIC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param category:
            The value to assign to the category property of this GenericArtifactDetails.
            Allowed values for this property are: "GENERIC", "PLATFORM_SPECIFIC"
        :type category: str

        :param artifact:
            The value to assign to the artifact property of this GenericArtifactDetails.
        :type artifact: oci.fleet_apps_management.models.GenericArtifact

        """
        self.swagger_types = {
            'category': 'str',
            'artifact': 'GenericArtifact'
        }

        self.attribute_map = {
            'category': 'category',
            'artifact': 'artifact'
        }

        self._category = None
        self._artifact = None
        self._category = 'GENERIC'

    @property
    def artifact(self):
        """
        **[Required]** Gets the artifact of this GenericArtifactDetails.

        :return: The artifact of this GenericArtifactDetails.
        :rtype: oci.fleet_apps_management.models.GenericArtifact
        """
        return self._artifact

    @artifact.setter
    def artifact(self, artifact):
        """
        Sets the artifact of this GenericArtifactDetails.

        :param artifact: The artifact of this GenericArtifactDetails.
        :type: oci.fleet_apps_management.models.GenericArtifact
        """
        self._artifact = artifact

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
