# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetSummary(object):
    """
    Summary of a Fleet.A fleet is a collection or grouping of resources based on criteria.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FleetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FleetSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this FleetSummary.
        :type compartment_id: str

        :param resource_region:
            The value to assign to the resource_region property of this FleetSummary.
        :type resource_region: str

        :param display_name:
            The value to assign to the display_name property of this FleetSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this FleetSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this FleetSummary.
        :type time_updated: datetime

        :param fleet_type:
            The value to assign to the fleet_type property of this FleetSummary.
        :type fleet_type: str

        :param environment_type:
            The value to assign to the environment_type property of this FleetSummary.
        :type environment_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FleetSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this FleetSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this FleetSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this FleetSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this FleetSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'resource_region': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'fleet_type': 'str',
            'environment_type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'resource_region': 'resourceRegion',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'fleet_type': 'fleetType',
            'environment_type': 'environmentType',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._compartment_id = None
        self._resource_region = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._fleet_type = None
        self._environment_type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FleetSummary.
        The OCID of the resource.


        :return: The id of this FleetSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FleetSummary.
        The OCID of the resource.


        :param id: The id of this FleetSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FleetSummary.
        Tenancy OCID


        :return: The compartment_id of this FleetSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FleetSummary.
        Tenancy OCID


        :param compartment_id: The compartment_id of this FleetSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_region(self):
        """
        Gets the resource_region of this FleetSummary.
        Associated region


        :return: The resource_region of this FleetSummary.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this FleetSummary.
        Associated region


        :param resource_region: The resource_region of this FleetSummary.
        :type: str
        """
        self._resource_region = resource_region

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FleetSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this FleetSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FleetSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this FleetSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FleetSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this FleetSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FleetSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this FleetSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this FleetSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this FleetSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this FleetSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this FleetSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def fleet_type(self):
        """
        **[Required]** Gets the fleet_type of this FleetSummary.
        Type of the Fleet.
        PRODUCT - A fleet of product-specific resources for a product type.
        ENVIRONMENT - A fleet of environment-specific resources for a product stack.
        GROUP - A fleet of a fleet of either environment or product fleets.
        GENERIC - A fleet of resources selected dynamically or manually for reporting purposes


        :return: The fleet_type of this FleetSummary.
        :rtype: str
        """
        return self._fleet_type

    @fleet_type.setter
    def fleet_type(self, fleet_type):
        """
        Sets the fleet_type of this FleetSummary.
        Type of the Fleet.
        PRODUCT - A fleet of product-specific resources for a product type.
        ENVIRONMENT - A fleet of environment-specific resources for a product stack.
        GROUP - A fleet of a fleet of either environment or product fleets.
        GENERIC - A fleet of resources selected dynamically or manually for reporting purposes


        :param fleet_type: The fleet_type of this FleetSummary.
        :type: str
        """
        self._fleet_type = fleet_type

    @property
    def environment_type(self):
        """
        Gets the environment_type of this FleetSummary.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :return: The environment_type of this FleetSummary.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this FleetSummary.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :param environment_type: The environment_type of this FleetSummary.
        :type: str
        """
        self._environment_type = environment_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FleetSummary.
        The lifecycle state of the Fleet.


        :return: The lifecycle_state of this FleetSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FleetSummary.
        The lifecycle state of the Fleet.


        :param lifecycle_state: The lifecycle_state of this FleetSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this FleetSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this FleetSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this FleetSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this FleetSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this FleetSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this FleetSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this FleetSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this FleetSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this FleetSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this FleetSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this FleetSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this FleetSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this FleetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this FleetSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this FleetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this FleetSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
