# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportComplianceReportDetails(object):
    """
    Details for generating Compliance Report
    """

    #: A constant which can be used with the compliance_state property of a ExportComplianceReportDetails.
    #: This constant has a value of "UNKNOWN"
    COMPLIANCE_STATE_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the compliance_state property of a ExportComplianceReportDetails.
    #: This constant has a value of "COMPLIANT"
    COMPLIANCE_STATE_COMPLIANT = "COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ExportComplianceReportDetails.
    #: This constant has a value of "NON_COMPLIANT"
    COMPLIANCE_STATE_NON_COMPLIANT = "NON_COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ExportComplianceReportDetails.
    #: This constant has a value of "WARNING"
    COMPLIANCE_STATE_WARNING = "WARNING"

    def __init__(self, **kwargs):
        """
        Initializes a new ExportComplianceReportDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ExportComplianceReportDetails.
        :type compartment_id: str

        :param entity_id:
            The value to assign to the entity_id property of this ExportComplianceReportDetails.
        :type entity_id: str

        :param resource_id:
            The value to assign to the resource_id property of this ExportComplianceReportDetails.
        :type resource_id: str

        :param product_stack:
            The value to assign to the product_stack property of this ExportComplianceReportDetails.
        :type product_stack: str

        :param product_name:
            The value to assign to the product_name property of this ExportComplianceReportDetails.
        :type product_name: str

        :param compliance_state:
            The value to assign to the compliance_state property of this ExportComplianceReportDetails.
            Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING"
        :type compliance_state: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'entity_id': 'str',
            'resource_id': 'str',
            'product_stack': 'str',
            'product_name': 'str',
            'compliance_state': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'entity_id': 'entityId',
            'resource_id': 'resourceId',
            'product_stack': 'productStack',
            'product_name': 'productName',
            'compliance_state': 'complianceState'
        }

        self._compartment_id = None
        self._entity_id = None
        self._resource_id = None
        self._product_stack = None
        self._product_name = None
        self._compliance_state = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ExportComplianceReportDetails.
        The OCID of the compartment.


        :return: The compartment_id of this ExportComplianceReportDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ExportComplianceReportDetails.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this ExportComplianceReportDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def entity_id(self):
        """
        Gets the entity_id of this ExportComplianceReportDetails.
        The OCID of the entity for which the compliance is calculated.Ex.FleetId


        :return: The entity_id of this ExportComplianceReportDetails.
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id):
        """
        Sets the entity_id of this ExportComplianceReportDetails.
        The OCID of the entity for which the compliance is calculated.Ex.FleetId


        :param entity_id: The entity_id of this ExportComplianceReportDetails.
        :type: str
        """
        self._entity_id = entity_id

    @property
    def resource_id(self):
        """
        Gets the resource_id of this ExportComplianceReportDetails.
        The OCID to identify the resource.


        :return: The resource_id of this ExportComplianceReportDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this ExportComplianceReportDetails.
        The OCID to identify the resource.


        :param resource_id: The resource_id of this ExportComplianceReportDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def product_stack(self):
        """
        Gets the product_stack of this ExportComplianceReportDetails.
        Product Stack.


        :return: The product_stack of this ExportComplianceReportDetails.
        :rtype: str
        """
        return self._product_stack

    @product_stack.setter
    def product_stack(self, product_stack):
        """
        Sets the product_stack of this ExportComplianceReportDetails.
        Product Stack.


        :param product_stack: The product_stack of this ExportComplianceReportDetails.
        :type: str
        """
        self._product_stack = product_stack

    @property
    def product_name(self):
        """
        Gets the product_name of this ExportComplianceReportDetails.
        Product Name.


        :return: The product_name of this ExportComplianceReportDetails.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this ExportComplianceReportDetails.
        Product Name.


        :param product_name: The product_name of this ExportComplianceReportDetails.
        :type: str
        """
        self._product_name = product_name

    @property
    def compliance_state(self):
        """
        Gets the compliance_state of this ExportComplianceReportDetails.
        Last known compliance state of target.

        Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING"


        :return: The compliance_state of this ExportComplianceReportDetails.
        :rtype: str
        """
        return self._compliance_state

    @compliance_state.setter
    def compliance_state(self, compliance_state):
        """
        Sets the compliance_state of this ExportComplianceReportDetails.
        Last known compliance state of target.


        :param compliance_state: The compliance_state of this ExportComplianceReportDetails.
        :type: str
        """
        allowed_values = ["UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING"]
        if not value_allowed_none_or_none_sentinel(compliance_state, allowed_values):
            raise ValueError(
                f"Invalid value for `compliance_state`, must be None or one of {allowed_values}"
            )
        self._compliance_state = compliance_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
